/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;

public class WsTrustTokenGenerationAttrContractState
extends CreateAttributeContractState
implements AttributeNamesApi {
    private static final long serialVersionUID = 1L;

    public WsTrustTokenGenerationAttrContractState(Tasklet value) {
        super(value);
        this.contract = new WsTrustTokenAttributeContract();
    }

    @Override
    public void onStateActivated() {
    }

    @Override
    public void populate(Object dataFromDisk) {
        WsTrustFederatedWspSettings wsTrustSettings = (WsTrustFederatedWspSettings)dataFromDisk;
        this.setComponentState(null);
        AttributeContract localContract = this.makeEmptyAttributeContract(false, false);
        WsTrustTokenAttributeContract existingContract = wsTrustSettings.getAttributeContract();
        if (existingContract != null) {
            HashSet immutableAttributeNames = new HashSet(existingContract.getImmutableAttributeNames());
            localContract.setImmutableAttributeNames(immutableAttributeNames);
            HashSet attributeNames = new HashSet(existingContract.getMutableAttributeNames());
            localContract.setMutableAttributeNames(attributeNames);
            this.maskedAttributeNames = new HashSet(existingContract.getMaskedAttributeNames());
        }
        this.setContract(localContract);
    }

    @Override
    public boolean populateAllStates(Object data) {
        IdpConnection connection = (IdpConnection)data;
        this.setContract((AttributeContract)connection.getWsTrustSettings().getAttributeContract());
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustFederatedWspSettings wsTrustSettings = (WsTrustFederatedWspSettings)dataToDisk;
        WsTrustTokenAttributeContract wsTrustAttributeContract = (WsTrustTokenAttributeContract)this.makeEmptyAttributeContract(false, false);
        wsTrustAttributeContract.setImmutableAttributeNames(this.getContract().getImmutableAttributeNames());
        wsTrustAttributeContract.setMutableAttributeNames(new HashSet(this.getContract().getMutableAttributeNames()));
        wsTrustAttributeContract.setMaskedAttributeNames(new HashSet(this.maskedAttributeNames));
        wsTrustSettings.setAttributeContract(wsTrustAttributeContract);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String item : this.contract.getAllAttrNamesSorted()) {
            summaryList.add(new SummaryInfo("Attribute", item, this));
        }
    }

    @Override
    public Boolean isMaskValues() {
        return true;
    }

    @Override
    public Boolean isIncludeAttributeNameFormat() {
        return false;
    }

    @Override
    public Boolean isIncludeSubjectNameFormat() {
        return false;
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.contract.getAllAttrNamesSorted();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.contract.getAllAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.contract.getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.contract.getSortedMutableAttributeNames();
    }

    @Override
    protected AttributeContract makeEmptyAttributeContract(boolean includePseudonym, boolean includeTransientId) {
        return new WsTrustTokenAttributeContract();
    }
}

