/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.AttributeSourceApiTaskletListState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGeneratorMappingTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenPluginManager;

public class WsTrustTokenGeneratorMappingState
extends AttributeSourceApiTaskletListState {
    private static final long serialVersionUID = 1L;
    private Collection<TokenPluginAttributeMapping> attributeMappings = new ArrayList<TokenPluginAttributeMapping>();
    private final List<String> closedDataStoreConnections = new ArrayList<String>();
    private String defaultAssertionToTokenMappingsMappingId;

    public WsTrustTokenGeneratorMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Token Generator Mapping & User Lookup");
    }

    @Override
    public void populate(Object dataFromDisk) {
        WsTrustFederatedWspSettings wsSettings = (WsTrustFederatedWspSettings)dataFromDisk;
        this.defaultAssertionToTokenMappingsMappingId = wsSettings.getDefaultAssertionToTokenMappingsMappingId();
        this.attributeMappings = new ArrayList<TokenPluginAttributeMapping>(wsSettings.getAssertionToTokenMappingsMappings());
        this.populate(this.attributeMappings);
    }

    private void populate(Collection<TokenPluginAttributeMapping> mappings) {
        this.deleteAllTasklets();
        for (TokenPluginAttributeMapping mapping : mappings) {
            TokenPluginManager tokenProcessorManager = (TokenPluginManager)GlobalRegistry.getService(TokenGeneratorManager.class);
            TokenPluginInstance tokenPluginInstance = (TokenPluginInstance)tokenProcessorManager.getInstance(mapping.getPluginId());
            if (tokenPluginInstance == null) continue;
            WsTrustTokenGeneratorMappingTasklet tasklet = this.createTasklet(WsTrustTokenGeneratorMappingTasklet.class);
            if (mapping.getPluginId().equals(this.defaultAssertionToTokenMappingsMappingId)) {
                tasklet.setDefaultTokenForConnection(true);
            }
            tasklet.setMode(Mode.edit);
            tasklet.populate(mapping);
            this.addTasklet(tasklet);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        WsTrustFederatedWspSettings wsSettings = (WsTrustFederatedWspSettings)dataToDisk;
        ArrayList<TokenPluginAttributeMapping> mappings = new ArrayList<TokenPluginAttributeMapping>();
        for (Tasklet t : this.getTasklets()) {
            WsTrustTokenGeneratorMappingTasklet wsTrustTokenGeneratorMappingTasklet = (WsTrustTokenGeneratorMappingTasklet)t;
            if (!wsTrustTokenGeneratorMappingTasklet.isItDeleted()) {
                TokenPluginAttributeMapping mapping = new TokenPluginAttributeMapping();
                wsTrustTokenGeneratorMappingTasklet.save(mapping);
                mappings.add(mapping);
            }
            if (!wsTrustTokenGeneratorMappingTasklet.isDefaultTokenForConnection()) continue;
            wsSettings.setDefaultAssertionToTokenMappingsMappingId(wsTrustTokenGeneratorMappingTasklet.getPluginId());
        }
        wsSettings.setAssertionToTokenMappings(mappings);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isDefaultDefined()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Default_required"), ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    private boolean isDefaultDefined() {
        for (Tasklet t : this.getTasklets()) {
            WsTrustTokenGeneratorMappingTasklet wsTrustTokenGeneratorMappingTasklet = (WsTrustTokenGeneratorMappingTasklet)t;
            if (wsTrustTokenGeneratorMappingTasklet.isItDeleted() || !wsTrustTokenGeneratorMappingTasklet.isDefaultTokenForConnection()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.deleteAllTasklets();
        this.attributeMappings = new ArrayList<TokenPluginAttributeMapping>();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenGeneratorMappingTasklet t = (WsTrustTokenGeneratorMappingTasklet)tasklet;
            summaryList.add(new SummaryInfo("Generator instance name", t.getSelectedPlugin().getName(), this));
        }
    }

    public Collection<TokenPluginAttributeMapping> getAttributeMappings() {
        return this.attributeMappings;
    }

    public void setAttributeMappings(Collection<TokenPluginAttributeMapping> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    public List<String> getGeneratorsInUseByConnection() {
        ArrayList<String> generatorsInUse = new ArrayList<String>();
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenGeneratorMappingTasklet wsTrustTokenGeneratorMappingTasklet = (WsTrustTokenGeneratorMappingTasklet)tasklet;
            String selectedTokenGeneratorId = wsTrustTokenGeneratorMappingTasklet.getSelectedPluginId();
            if (selectedTokenGeneratorId == null) continue;
            generatorsInUse.add(selectedTokenGeneratorId);
        }
        return generatorsInUse;
    }

    public void setDefault(String mappingToSetAsDefault) {
        for (Tasklet tasklet : this.getTasklets()) {
            ((WsTrustTokenGeneratorMappingTasklet)tasklet).setDefaultTokenForConnection(false);
        }
        for (Tasklet tasklet : this.getTasklets()) {
            WsTrustTokenGeneratorMappingTasklet t = (WsTrustTokenGeneratorMappingTasklet)tasklet;
            if (!t.getDescription().equals(mappingToSetAsDefault)) continue;
            t.setDefaultTokenForConnection(true);
            return;
        }
    }
}

