/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.SpWsTrustTokenLifetimeValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;

public class WsTrustTokenLifetimeState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String tokenLifetimeBeforeMinutes = String.valueOf(5);
    private String tokenLifetimeAfterMinutes = String.valueOf(30);

    public WsTrustTokenLifetimeState(Tasklet value) {
        super(value);
        this.setMenuName("Token Lifetime");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof SpConnection) {
            SpConnection spConnection = (SpConnection)dataFromDisk;
            WsTrustFederatedWscSettings wsTrustSettings = spConnection.getWsTrustSettings();
            this.tokenLifetimeAfterMinutes = String.valueOf(wsTrustSettings.getAssertionValidityAfterMinutes());
            this.tokenLifetimeBeforeMinutes = String.valueOf(wsTrustSettings.getAssertionValidityBeforeMinutes());
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof SpConnection) {
            SpConnection spConnection = (SpConnection)dataToDisk;
            WsTrustFederatedWscSettings wsTrustSettings = spConnection.getWsTrustSettings();
            wsTrustSettings.setAssertionValidityAfterMinutes(Integer.parseInt(this.tokenLifetimeAfterMinutes));
            wsTrustSettings.setAssertionValidityBeforeMinutes(Integer.parseInt(this.tokenLifetimeBeforeMinutes));
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        SpWsTrustTokenLifetimeValidator validator = new SpWsTrustTokenLifetimeValidator(this.tokenLifetimeBeforeMinutes, this.tokenLifetimeAfterMinutes);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void reset() {
        this.tokenLifetimeBeforeMinutes = String.valueOf(5);
        this.tokenLifetimeAfterMinutes = String.valueOf(30);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Token_lifetime_minutes_before"), this.tokenLifetimeBeforeMinutes, this));
        summaryList.add(new SummaryInfo(this.getMessage("Token_lifetime_assertion_minutes_after"), this.tokenLifetimeAfterMinutes, this));
    }

    public String getTokenLifetimeBeforeMinutes() {
        return this.tokenLifetimeBeforeMinutes;
    }

    public void setTokenLifetimeBeforeMinutes(String tokenLifetimeBeforeMinutes) {
        this.tokenLifetimeBeforeMinutes = tokenLifetimeBeforeMinutes;
    }

    public String getTokenLifetimeAfterMinutes() {
        return this.tokenLifetimeAfterMinutes;
    }

    public void setTokenLifetimeAfterMinutes(String tokenLifetimeAfterMinutes) {
        this.tokenLifetimeAfterMinutes = tokenLifetimeAfterMinutes;
    }
}

