/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenProcessorMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.handlers.TokenPluginSupport;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class WsTrustTokenProcessorInstanceState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private transient TokenPluginInstance selectedProcessor;
    private String selectedProcessorId;
    private List<String> attributeList;
    private boolean isNewProcessor = true;
    private boolean overrideAdapterConnectionSettings;
    private transient TokenPluginInstance connectionOverrideInstance;

    public WsTrustTokenProcessorInstanceState(Tasklet value) {
        super(value);
        this.setMenuName("Token Processor Instance");
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenPluginAttributeMapping mapping = (TokenPluginAttributeMapping)dataFromDisk;
        TokenPluginSupport tokenPluginSupport = new TokenPluginSupport();
        this.selectedProcessor = tokenPluginSupport.getProcessorInstanceFromId(mapping.getPluginId());
        if (this.selectedProcessor != null) {
            this.selectedProcessorId = this.selectedProcessor.getId();
            this.connectionOverrideInstance = mapping.getConnectionOverrideInstance();
            this.setOverrideAdapterConnectionSettings(this.selectedProcessor.isConnectionBasedPlugin());
        }
        this.createAttributeList();
        this.getParent().reconfigureTransitions(this);
        this.isNewProcessor = false;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.selectedProcessor != null) {
            if (this.isOverrideSettingUnchecked()) {
                PluginMappingApi pluginMappingApi = (PluginMappingApi)((Object)this.getParent());
                TokenPluginInstance selectedProcessor = this.getSelectedProcessor();
                TokenPluginInstance parentProcessor = (TokenPluginInstance)((TokenProcessorManager)GlobalRegistry.getService(TokenProcessorManager.class)).getInstance(selectedProcessor.getParentId());
                this.setSelectedProcessor(parentProcessor);
                pluginMappingApi.removeConnectionOverride();
            }
            this.createAttributeList();
        } else {
            this.attributeList = null;
        }
        if (this.getTaskletToEdit() != null) {
            this.setTaskletToEditToNull();
        }
    }

    @Override
    public void reset() {
        this.selectedProcessor = null;
        this.selectedProcessorId = null;
        this.attributeList = null;
        this.isNewProcessor = true;
    }

    @Override
    public void onResumeDraft() {
        if (this.selectedProcessor == null && this.selectedProcessorId != null) {
            TokenPluginSupport tokenPluginSupport = new TokenPluginSupport();
            this.selectedProcessor = tokenPluginSupport.getProcessorInstanceFromId(this.selectedProcessorId);
        }
    }

    @Override
    public void refreshState() {
        this.setTaskletToEditToNull();
        if (this.selectedProcessor == null && this.selectedProcessorId != null) {
            TokenPluginSupport tokenPluginSupport = new TokenPluginSupport();
            this.selectedProcessor = tokenPluginSupport.getProcessorInstanceFromId(this.selectedProcessorId);
            this.createAttributeList();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenPluginAttributeMapping mapping = (TokenPluginAttributeMapping)dataToDisk;
        mapping.setPluginId(this.selectedProcessorId);
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedProcessor == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("You_must_select_a_token_processor"), ValidationConstraint.REQUIRED);
        }
    }

    public StringPairPropertySelectionModel getProcessorList() {
        StringPairPropertySelectionModel processorList = new StringPairPropertySelectionModel(true);
        WsTrustTokenProcessorMappingTasklet wsTrustTokenProcessorMappingTasklet = (WsTrustTokenProcessorMappingTasklet)this.getParent();
        List<String> processorsInUseByConnection = wsTrustTokenProcessorMappingTasklet.getProcessorsInUseByConnection();
        ArrayList<ConfigurablePluginInstance> connectionBasedRelatedPlugins = new ArrayList<ConfigurablePluginInstance>();
        TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
        for (ConfigurablePluginInstance instance : tokenProcessorManager.getInstances()) {
            String parentId;
            ConfigurablePluginInstance parentInstance;
            boolean processorInUse = processorsInUseByConnection.contains(instance.getId());
            if (processorInUse && instance.isConnectionBasedPlugin() && (parentInstance = tokenProcessorManager.getInstance(parentId = instance.getParentId())) != null) {
                connectionBasedRelatedPlugins.add(parentInstance);
            }
            if (processorInUse || instance.isConnectionBasedPlugin()) continue;
            processorList.add(instance.getName(), instance);
        }
        for (ConfigurablePluginInstance instance : connectionBasedRelatedPlugins) {
            processorList.remove(instance.getName());
        }
        return processorList;
    }

    public void createAttributeList() {
        TokenPluginInstance instance = this.getSelectedProcessor();
        if (instance != null) {
            PluginMappingApi pluginMappingApi = (PluginMappingApi)((Object)this.getParent());
            if (pluginMappingApi.isOverridePluginPopulated()) {
                this.attributeList = pluginMappingApi.getPluginContract();
            } else {
                instance = pluginMappingApi.isOverridePluginConnectionSettings() && this.connectionOverrideInstance != null ? this.connectionOverrideInstance : this.getSelectedProcessor();
                AttributeContract contract = instance.getAttributeContract();
                this.selectedProcessorId = instance.getId();
                this.attributeList = new ArrayList<String>(contract.getAllAttrNamesSorted());
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Selected_processor"), this.selectedProcessor.getName(), this));
    }

    public TokenPluginInstance getSelectedProcessor() {
        return this.selectedProcessor;
    }

    public void setSelectedProcessor(TokenPluginInstance selectedProcessor) {
        this.selectedProcessor = selectedProcessor;
        this.selectedProcessorId = selectedProcessor != null ? selectedProcessor.getId() : null;
    }

    public List<String> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<String> attributeList) {
        this.attributeList = attributeList;
    }

    public boolean isNewProcessor() {
        return this.isNewProcessor;
    }

    public void setNewProcessor(boolean isNewProcessor) {
        this.isNewProcessor = isNewProcessor;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return this.getSelectedProcessor() != null;
    }

    public String getSelectedPluginId() {
        return this.selectedProcessorId;
    }

    public boolean isOverrideAdapterConnectionSettings() {
        return this.overrideAdapterConnectionSettings;
    }

    public void setOverrideAdapterConnectionSettings(boolean overrideAdapterConnectionSettings) {
        PluginMappingApi parent = (PluginMappingApi)((Object)this.getParent());
        parent.removeConnectionOverride();
        this.overrideAdapterConnectionSettings = overrideAdapterConnectionSettings;
    }

    public boolean isOverrideSettingUnchecked() {
        return !this.isOverrideAdapterConnectionSettings() && this.getSelectedProcessor() != null && this.getSelectedProcessor().isConnectionBasedPlugin();
    }
}

