/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.fragments;

import com.pingidentity.admin.api.validator.AuthenticationPolicyFragmentValidator;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.authnselection.ui.fragments.DisplayNameVisitor;
import com.pingidentity.authnselection.ui.fragments.InvalidFragmentContractVisitor;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PolicyFragmentState
extends AbstractPolicyState {
    private static final long serialVersionUID = 20201130L;
    private final transient C2cContractManager contractManager = MgmtFactory.getC2cContractManager();
    private String selectedInputContractName;
    private String selectedInputContractTypeAndID;
    private String selectedOutputContractName;
    private String selectedOutputContractTypeAndID;

    public PolicyFragmentState(Tasklet value) {
        super(value);
        this.setMenuName("Fragment");
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.getParent().isModeCreate() && AuthenticationPolicyFragmentValidator.fragmentIdContainReservedWord((String)this.getId())) {
            this.recordErrorMsg("'" + this.getId() + "' is a reserved keyword and cannot be used as the fragment ID. Please choose another ID.");
        }
        String outputContractId = Optional.ofNullable(this.selectedOutputContractTypeAndID).map(SelectionFilterList::parseSelectedOptionString).map(SelectedOption::getId).orElse("");
        PreOrderTraversal traversal = new PreOrderTraversal();
        InvalidFragmentContractVisitor visitor = new InvalidFragmentContractVisitor(outputContractId);
        Tree<AsUiAction> tree = this.getAuthnSelectionTree();
        traversal.traverse(tree, (TraversalVisitor)visitor);
        this.getNodeIdsWithError().clear();
        if (visitor.isInvalidContract()) {
            if (StringUtils.isBlank((String)visitor.getValidContractId())) {
                PolicyFragmentState.recordErrorMsg("A fragment without an output policy contract cannot end with an authentication policy contract or a local identity profile.", delegate);
            } else {
                PolicyFragmentState.recordErrorMsg("All end nodes must use the output policy contract or a local identity profile that uses the same contract as the output policy contract.", delegate);
            }
        }
        this.getNodeIdsWithError().addAll(visitor.getNodesMissingOptions().stream().map(option -> ((AsUiAction)option.getData()).getNodeId()).collect(Collectors.toList()));
        super.appendErrors(delegate, component, fastFail);
    }

    @Override
    public void performPasteValidation(IValidationDelegate delegate, List<String> messages) {
        super.performPasteValidation(delegate, messages);
    }

    @Override
    protected void addOtherInputSourceAttributes(Map<String, Set<String>> allAvailableAttributeContracts) {
        C2cContract contract;
        if (this.getInputContractId() != null && (contract = this.contractManager.getContract(this.getInputContractId())) != null) {
            allAvailableAttributeContracts.put("Inputs", contract.getAllAttributeNames());
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        C2cContract outputContract;
        PolicyFragment fragment = (PolicyFragment)dataFromDisk;
        this.id = fragment.getId();
        this.name = fragment.getName();
        this.description = fragment.getDescription();
        C2cContract inputContract = fragment.getInputContract();
        if (inputContract != null) {
            this.setSelectedInputContractTypeAndID(new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT, inputContract.getId()).toString());
            this.setSelectedInputContractName(inputContract.getName());
        }
        if ((outputContract = fragment.getOutputContract()) != null) {
            this.setSelectedOutputContractTypeAndID(new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT, outputContract.getId()).toString());
            this.setSelectedOutputContractName(outputContract.getName());
        }
        super.populate(fragment.getRootNode());
    }

    @Override
    public void refreshState() {
        PreOrderTraversal preOrderTraversal = new PreOrderTraversal();
        DisplayNameVisitor displayNameVisitor = new DisplayNameVisitor();
        preOrderTraversal.traverse(this.getAuthnSelectionTree(), (TraversalVisitor)displayNameVisitor);
        this.appendErrors((IValidationDelegate)this.getDelegate(), null, false);
    }

    @Override
    public List<String> getAvailableSourceIdsOnSuccessBranches(Tree.Node<AsUiAction> selectedNode) {
        List<String> sourceIds = super.getAvailableSourceIdsOnSuccessBranches(selectedNode);
        if (!StringUtils.isEmpty((String)this.selectedInputContractTypeAndID)) {
            sourceIds.add(PolicyFragmentState.getAuthnSourceKey("Inputs", SourceType.INPUTS));
        }
        return sourceIds;
    }

    @Override
    public void loadAttributeContracts(AsActionOption selectedOption) {
        super.loadAttributeContracts(selectedOption);
        if (!StringUtils.isEmpty((String)this.selectedInputContractTypeAndID)) {
            SelectedOption selectedInputContract = SelectionFilterList.parseSelectedOptionString(this.selectedInputContractTypeAndID);
            C2cContract inputContract = this.contractManager.getContract(selectedInputContract.getId());
            this.getAttributeContractsMap().put(PolicyFragmentState.getAuthnSourceKey("Inputs", SourceType.INPUTS), inputContract.getAllAttributeNames());
            this.idsToNamesMap.put(PolicyFragmentState.getAuthnSourceKey("Inputs", SourceType.INPUTS), new NameValuePair(SourceType.INPUTS.name(), "Inputs"));
        }
    }

    public PolicyFragment getPolicyFragment() {
        PolicyFragment fragment = new PolicyFragment(this.buildTree(null, null));
        fragment.setId(this.getId());
        fragment.setName(this.getName());
        fragment.setDescription(this.getDescription());
        if (!StringUtils.isEmpty((String)this.selectedInputContractTypeAndID)) {
            SelectedOption inputContract = SelectionFilterList.parseSelectedOptionString(this.selectedInputContractTypeAndID);
            fragment.setInputContractId(inputContract.getId());
        }
        if (!StringUtils.isEmpty((String)this.selectedOutputContractTypeAndID)) {
            SelectedOption outputContract = SelectionFilterList.parseSelectedOptionString(this.selectedOutputContractTypeAndID);
            fragment.setOutputContractId(outputContract.getId());
        }
        return fragment;
    }

    public String getSelectedInputContractName() {
        return this.selectedInputContractName;
    }

    public void setSelectedInputContractName(String selectedInputContractName) {
        this.selectedInputContractName = selectedInputContractName;
    }

    public String getSelectedInputContractTypeAndID() {
        return this.selectedInputContractTypeAndID;
    }

    public void setSelectedInputContractTypeAndID(String selectedInputContractTypeAndID) {
        if (!StringUtils.equals((String)this.selectedInputContractTypeAndID, (String)selectedInputContractTypeAndID)) {
            this.selectedInputContractTypeAndID = selectedInputContractTypeAndID;
            this.updateSourceIds(new PreOrderTraversal());
        }
    }

    public String getSelectedOutputContractName() {
        return this.selectedOutputContractName;
    }

    public void setSelectedOutputContractName(String selectedOutputContractName) {
        this.selectedOutputContractName = selectedOutputContractName;
    }

    public String getSelectedOutputContractTypeAndID() {
        return this.selectedOutputContractTypeAndID;
    }

    public void setSelectedOutputContractTypeAndID(String selectedOutputContractTypeAndID) {
        this.selectedOutputContractTypeAndID = selectedOutputContractTypeAndID;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypesToEdit() {
        return Collections.singletonList(FilterableSelectionFieldDescriptor.SearchableTypeConfig.AUTH_POLICY_CONTRACT);
    }

    @Override
    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes(AsUiAction asUiAction) {
        List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> searchableTypes = super.getSearchableTypes(asUiAction);
        String outputId = "";
        if (!StringUtils.isEmpty((String)this.getSelectedOutputContractTypeAndID())) {
            SelectedOption outputContract = SelectionFilterList.parseSelectedOptionString(this.selectedOutputContractTypeAndID);
            outputId = outputContract.getId();
        }
        if (asUiAction != null && !asUiAction.isRootNode()) {
            List<FilterableSelectionFieldDescriptor.QueryParam> apcQueryParams = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("filter", outputId));
            searchableTypes.add(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.AUTHN_POLICY_CONTRACT, apcQueryParams));
            List<FilterableSelectionFieldDescriptor.QueryParam> lipQueryParams = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("apcId", outputId));
            searchableTypes.add(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.LOCAL_IDENTITY_PROFILE, lipQueryParams));
        }
        return searchableTypes;
    }

    public String getInputContractId() {
        SelectedOption inputContract;
        if (!StringUtils.isEmpty((String)this.selectedInputContractTypeAndID) && (inputContract = SelectionFilterList.parseSelectedOptionString(this.selectedInputContractTypeAndID)) != null) {
            return inputContract.getId();
        }
        return null;
    }

    @Override
    public boolean isShowDone(AsUiAction action) {
        return !action.isRootNode();
    }

    public void removeOutputContract() {
        this.setSelectedOutputContractName(null);
        this.setSelectedOutputContractTypeAndID(null);
    }

    public void removeInputContract() {
        this.setSelectedInputContractName(null);
        this.setSelectedInputContractTypeAndID(null);
    }

    @Override
    public String getTypeString() {
        return "fragment";
    }
}

