/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.DataStoreConfigTasklet;
import com.pingidentity.localidentity.DataStoreAttribute;
import com.pingidentity.localidentity.LdapDataStoreConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class LdapGeneralInfoState
extends ConfigLdapDirSearchState {
    public LdapGeneralInfoState(Tasklet value) {
        super(value);
        this.setMenuName("LDAP Configuration");
    }

    @Override
    public String getBaseDN() {
        return this.baseDN;
    }

    @Override
    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    @Override
    protected boolean needsSubjectDn() {
        return false;
    }

    @Override
    public boolean save(Object dataToDisk) {
        LdapDataStoreConfig mapping = (LdapDataStoreConfig)((LocalIdentityProfile)dataToDisk).getDataStoreConfig();
        mapping.setBaseDN(this.baseDN);
        mapping.setSearchScope("ONELEVEL_SCOPE");
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityProfile policy = (LocalIdentityProfile)dataFromDisk;
        LdapDataStoreConfig config = (LdapDataStoreConfig)policy.getDataStoreConfig();
        this.dataSource = (LdapDataSource)config.getAttributeSource().getDataSource();
        this.baseDN = config.getBaseDN();
        this.selectedAttributes = new ArrayList();
        for (Map.Entry attribute : policy.getDataStoreConfig().getDataStoreMapping().entrySet()) {
            if (this.selectedAttributes.contains(((DataStoreAttribute)attribute.getValue()).getName())) continue;
            this.selectedAttributes.add(((DataStoreAttribute)attribute.getValue()).getName());
        }
        this.populate();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.baseDN)) {
            delegate.record(this.getMessage("base_dn_required"), ValidationConstraint.REQUIRED);
            return;
        }
        if (this.selectedAttributes.isEmpty() || this.selectedAttributes.size() < this.getSizeOfContractToFulfill()) {
            delegate.record(this.getMessage("ldap_attribute_required", new Object[]{this.getSizeOfContractToFulfill()}), ValidationConstraint.REQUIRED);
            return;
        }
        super.appendErrors(delegate, component, fastFail);
    }

    @Override
    protected Collection<String> getAvailableSubstitutionAttributes() {
        DataStoreConfigTasklet parentTasklet = this.getParent(DataStoreConfigTasklet.class);
        List<String> contractToFulfill = parentTasklet.getContractToFulfill();
        List availableCustomAttributes = LocalIdentityStorageManager.getInstance((LdapInfo.LdapType)this.dataSource.getLdapType()).getAvailableCustomAttributes();
        contractToFulfill.addAll(availableCustomAttributes);
        return contractToFulfill;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.doBaseDNSummary(summaryList);
        this.doAttributeSummary(summaryList);
    }

    @Override
    public String getLinkText() {
        return "View Local Identity Fields";
    }

    private int getSizeOfContractToFulfill() {
        DataStoreConfigTasklet parentTasklet = this.getParent(DataStoreConfigTasklet.class);
        return parentTasklet.getContractToFulfill().size();
    }

    public void remove(String dataStoreValueToRemove) {
        this.selectedAttributes.remove(dataStoreValueToRemove);
    }

    @Override
    protected boolean isAttributeOptionsSupported() {
        return false;
    }
}

