/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.attrupdates.AuthSourceUpdatePolicy;
import com.pingidentity.localidentity.attrupdates.AuthSourceUpdatePolicyImpl;
import com.pingidentity.localidentity.attrupdates.DefaultAuthSourceUpdatePolicy;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSourceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class LocalIdentityAuthSourcesState
extends TaskletState
implements TableEditor.TableEditorListener,
TableEditor.TableEditorRowOrdering {
    private final SimpleFieldDescriptor AUTH_SOURCE_ID = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Auth Source ID", 240, true, null);
    private final SimpleFieldDescriptor AUTH_SOURCE_NAME = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Authentication Source", 240);
    private final List<SimpleFieldDescriptor> descriptors = new ArrayList<SimpleFieldDescriptor>();
    private List<TableRow> authSources = new ArrayList<TableRow>();
    private Object componentState;
    private boolean enableAttributeStorage;
    private boolean updateAttributes;
    private boolean retainAttributes;
    private String updateInterval;

    public LocalIdentityAuthSourcesState(Tasklet owner) {
        super(owner);
        this.setMenuName("Authentication Sources");
        this.descriptors.add(this.AUTH_SOURCE_ID);
        this.descriptors.add(this.AUTH_SOURCE_NAME);
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.setComponentState(null);
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityProfile profile = (LocalIdentityProfile)dataFromDisk;
        this.authSources = this.createRowsForSources(profile.getAuthSources());
        if (profile.getAuthSources().size() > 0) {
            LocalIdentityAuthSource authSource = (LocalIdentityAuthSource)profile.getAuthSources().get(0);
            AuthSourceUpdatePolicy updatePolicy = authSource.getUpdatePolicy();
            this.enableAttributeStorage = updatePolicy.isStoreAttributes();
            this.updateAttributes = updatePolicy.isUpdateAttributes();
            this.retainAttributes = updatePolicy.isRetainAttributes();
            if (this.updateAttributes) {
                this.updateInterval = updatePolicy.getUpdateIntervalStringInDays();
            }
        }
    }

    private List<TableRow> createRowsForSources(List<LocalIdentityAuthSource> authSources) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        authSources.forEach(source -> {
            ArrayList<FieldItem> items = new ArrayList<FieldItem>();
            items.add(new FieldItem(this.AUTH_SOURCE_ID, source.getId()));
            items.add(new FieldItem(this.AUTH_SOURCE_NAME, source.getSource()));
            rows.add(new TableRow(items));
        });
        return rows;
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile profile = (LocalIdentityProfile)dataToDisk;
        profile.setAuthSources(this.getAuthSourcesFromRows());
        return super.save(dataToDisk);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        for (TableRow row : this.authSources) {
            summaryList.add(new SummaryInfo("Authentication Source", this.getSourceNameFromRow(row), this));
        }
        if (this.isRegistrationOrProfileEnabled()) {
            AuthSourceUpdatePolicy updatePolicy = this.createUpdatePolicy();
            summaryList.add(new SummaryInfo("Store Attributes", Boolean.toString(updatePolicy.isStoreAttributes()), this));
            if (updatePolicy.isStoreAttributes()) {
                summaryList.add(new SummaryInfo("Keep attributes after users disconnect", Boolean.toString(updatePolicy.isRetainAttributes()), this));
                summaryList.add(new SummaryInfo("Update attributes when users authenticate", Boolean.toString(updatePolicy.isUpdateAttributes()), this));
                if (this.updateAttributes) {
                    summaryList.add(new SummaryInfo("Minimum number of days between updates", updatePolicy.getUpdateIntervalStringInDays(), this));
                }
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        if (this.enableAttributeStorage && this.getAuthSources().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("auth_sources_required"), ValidationConstraint.REQUIRED);
        }
        if (this.isRegistrationOrProfileEnabled() && this.enableAttributeStorage && this.updateAttributes) {
            if (StringUtils.isBlank((String)this.updateInterval)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("update_interval_required"), ValidationConstraint.REQUIRED);
            } else {
                try {
                    Double value = Double.parseDouble(this.getUpdateInterval());
                    if (value < 0.0 || value > 99999.0) {
                        delegate.setFormComponent(null);
                        delegate.record(this.getMessage("invalid_update_interval_number"), ValidationConstraint.NUMBER_FORMAT);
                    }
                }
                catch (NumberFormatException e) {
                    Object[] objects = new Object[]{this.getUpdateInterval()};
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("invalid_update_interval", objects), ValidationConstraint.NUMBER_FORMAT);
                }
            }
        }
    }

    public List<TableRow> getAuthSources() {
        return this.authSources;
    }

    public void setAuthSources(List<TableRow> authSources) {
        this.authSources = authSources;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<SimpleFieldDescriptor> getAuthSourcesDescriptors() {
        return this.descriptors;
    }

    public List<LocalIdentityAuthSource> getAuthSourcesFromRows() {
        ArrayList<LocalIdentityAuthSource> sources = new ArrayList<LocalIdentityAuthSource>(this.authSources.size());
        AuthSourceUpdatePolicy updatePolicy = this.createUpdatePolicy();
        this.authSources.forEach(row -> {
            if (!row.isMarkedForDelete()) {
                sources.add((LocalIdentityAuthSource)new LocalIdentityAuthSourceImpl(this.getSourceIdFromRow((TableRow)row), this.getSourceNameFromRow((TableRow)row), updatePolicy));
            }
        });
        return sources;
    }

    private AuthSourceUpdatePolicy createUpdatePolicy() {
        if (this.isRegistrationOrProfileEnabled() && this.isEnableAttributeStorage()) {
            Double updateIntervalDouble = StringUtils.isBlank((String)this.updateInterval) ? null : Double.valueOf(Double.parseDouble(this.updateInterval));
            return new AuthSourceUpdatePolicyImpl(this.enableAttributeStorage, this.retainAttributes, this.updateAttributes, updateIntervalDouble);
        }
        return new DefaultAuthSourceUpdatePolicy();
    }

    private String getSourceIdFromRow(TableRow row) {
        return row.getFields().get(0).getValue().trim();
    }

    private String getSourceNameFromRow(TableRow row) {
        return row.getFields().get(1).getValue().trim();
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        String sourceToAdd = this.getSourceNameFromRow(row);
        if (StringUtils.isBlank((String)sourceToAdd)) {
            errors.add(this.getMessage("blank_value"));
        }
        for (TableRow currentRow : list) {
            if (originalRow != null && currentRow.equals(originalRow) || !sourceToAdd.equalsIgnoreCase(this.getSourceNameFromRow(currentRow))) continue;
            errors.add(this.getMessage("duplicate_name", new Object[]{sourceToAdd}));
        }
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
        newRow.getFields().get(0).setValue(LocalIdentityAuthSource.generateId());
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    @Override
    public void moveUp(int index) {
        if (index > 0) {
            TableRow item = this.authSources.get(index);
            this.authSources.set(index, this.authSources.get(index - 1));
            this.authSources.set(index - 1, item);
        }
    }

    @Override
    public void moveDown(int index) {
        if (index < this.authSources.size() - 1) {
            TableRow item = this.authSources.get(index);
            this.authSources.set(index, this.authSources.get(index + 1));
            this.authSources.set(index + 1, item);
        }
    }

    public boolean isRegistrationOrProfileEnabled() {
        LocalIdentityProfileTasklet tasklet = this.getParent(LocalIdentityProfileTasklet.class);
        return tasklet.isProfileEnabled() || tasklet.isRegistrationEnabled();
    }

    public boolean isEnableAttributeStorage() {
        return this.enableAttributeStorage;
    }

    public void setEnableAttributeStorage(boolean enableAttributeStorage) {
        this.enableAttributeStorage = enableAttributeStorage;
    }

    public boolean isUpdateAttributes() {
        return this.updateAttributes;
    }

    public void setUpdateAttributes(boolean updateAttributes) {
        this.updateAttributes = updateAttributes;
    }

    public boolean isRetainAttributes() {
        return this.retainAttributes;
    }

    public void setRetainAttributes(boolean retainAttributes) {
        this.retainAttributes = retainAttributes;
    }

    public String getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(String updateInterval) {
        this.updateInterval = updateInterval;
    }
}

