/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.admin.api.validator.localidentity.LocalIdentityProfileEmailVerificationTypeValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.EmailVerificationConfig;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.fieldtypes.EmailField;
import com.pingidentity.localidentity.fieldtypes.HiddenField;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.fieldtypes.TextField;
import com.pingidentity.localidentity.type.DefaultEmailVerificationConfig;
import com.pingidentity.localidentity.type.EmailVerificationType;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityEmailVerificationState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private boolean emailVerificationEnabled = false;
    private String verifyEmailTemplateName;
    private String emailVerificationSentTemplateName;
    private String emailVerificationSuccessTemplateName;
    private String emailVerificationErrorTemplateName;
    private EmailVerificationType emailVerificationType;
    private String otpLength;
    private String otpRetryAttempts;
    private String allowedOtpCharacterSet;
    private String otpTimeToLive;
    private String emailVerificationOtpTemplateName;
    private String otlTimeToLive;
    private String fieldUsedForOwnershipVerification;
    private String fieldStoringVerificationStatus;
    private String notificationPublisherId;
    private boolean requireVerifiedEmail = false;
    private String requireVerifiedEmailTemplateName;
    private static final String emailVerificationEnabledDesc = "Enable Email Ownership Verification";
    private static final String verifyEmailTemplateDesc = "Email Template";
    private static final String verificationSentTemplateDesc = "Sent Template";
    private static final String verificationSuccessTemplateDesc = "Success Template";
    private static final String verificationErrorTemplateDesc = "Error Template";
    private static final String emailVerificationTypeDesc = "Email Verification Type";
    private static final String otpLengthDesc = "OTP Length";
    private static final String otpRetryAttemptsDesc = "OTP Retry Attempts";
    private static final String allowedOtpCharacterSetDesc = "Allowed OTP Character Set";
    private static final String otpTimeToLiveDesc = "One-Time Passcode Lifetime";
    private static final String verificationOtpTemplateDesc = "OTP Template";
    private static final String otlTimeToLiveDesc = "One-Time Link Lifetime";
    private static final String verificationEmailFieldDesc = "Email Address Field";
    private static final String verificationStatusFieldDesc = "Ownership Status Field";
    private static final String notificationSendersFieldDesc = "Notification Publisher";
    private static final String requireVerifiedEmailDesc = "Require Verified Email";
    private static final String requireVerifiedEmailTemplateDesc = "Require Verified Email Template";

    public LocalIdentityEmailVerificationState(IWizard owner) {
        super(owner);
        this.setMenuName("Email Verification");
        this.verifyEmailTemplateName = "message-template-email-ownership-verification.html";
        this.emailVerificationSentTemplateName = "local.identity.email.verification.sent.html";
        this.emailVerificationSuccessTemplateName = "local.identity.email.verification.success.html";
        this.emailVerificationErrorTemplateName = "local.identity.email.verification.error.html";
        this.requireVerifiedEmailTemplateName = "local.identity.email.verification.required.html";
        this.emailVerificationType = EmailVerificationType.OTP;
        this.otpLength = String.valueOf(8);
        this.otpRetryAttempts = String.valueOf(3);
        this.allowedOtpCharacterSet = "23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz";
        this.otpTimeToLive = String.valueOf(15);
        this.emailVerificationOtpTemplateName = "local.identity.email.verification.otp.html";
        this.otlTimeToLive = String.valueOf(1440);
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        LocalIdentityProfile policy = (LocalIdentityProfile)dataFromDisk;
        EmailVerificationConfig config = policy.getEmailOwnershipVerificationConfig();
        if (config != null) {
            this.emailVerificationEnabled = config.isEmailVerificationEnabled();
            this.verifyEmailTemplateName = config.getVerifyEmailTemplateName();
            this.emailVerificationSentTemplateName = config.getEmailVerificationSentTemplateName();
            this.emailVerificationSuccessTemplateName = config.getEmailVerificationSuccessTemplateName();
            this.emailVerificationErrorTemplateName = config.getEmailVerificationErrorTemplateName();
            this.emailVerificationType = config.getEmailVerificationType() == null ? EmailVerificationType.OTL : config.getEmailVerificationType();
            this.otpLength = config.getOtpLength() == null ? String.valueOf(8) : String.valueOf(config.getOtpLength());
            this.otpRetryAttempts = config.getOtpRetryAttempts() == null ? String.valueOf(3) : String.valueOf(config.getOtpRetryAttempts());
            this.allowedOtpCharacterSet = config.getAllowedOtpCharacterSet() == null ? "23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz" : config.getAllowedOtpCharacterSet();
            this.otpTimeToLive = config.getOtpTimeToLive() == null ? String.valueOf(15) : String.valueOf(config.getOtpTimeToLive());
            this.emailVerificationOtpTemplateName = StringUtils.defaultIfEmpty((String)config.getEmailVerificationOtpTemplateName(), (String)"local.identity.email.verification.otp.html");
            this.otlTimeToLive = String.valueOf(config.getOtlTimeToLive());
            this.fieldUsedForOwnershipVerification = config.getFieldUsedForOwnershipVerification();
            this.fieldStoringVerificationStatus = config.getFieldStoringVerificationStatus();
            this.notificationPublisherId = config.getNotificationPublisherId();
            this.requireVerifiedEmail = config.isRequireVerifiedEmail();
            if (StringUtils.isNotBlank((String)config.getRequireVerifiedEmailTemplateName())) {
                this.requireVerifiedEmailTemplateName = config.getRequireVerifiedEmailTemplateName();
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityProfile lip = (LocalIdentityProfile)dataToDisk;
        EmailVerificationConfig config = lip.getEmailOwnershipVerificationConfig();
        if (config == null) {
            config = new EmailVerificationConfig();
            lip.setEmailOwnershipVerificationConfig(config);
        }
        config.setEmailVerificationEnabled(this.emailVerificationEnabled);
        config.setEmailVerificationType(this.emailVerificationType);
        if (this.isEmailVerificationEnabled()) {
            config.setVerifyEmailTemplateName(this.verifyEmailTemplateName);
            config.setEmailVerificationSentTemplateName(this.emailVerificationSentTemplateName);
            config.setEmailVerificationSuccessTemplateName(this.emailVerificationSuccessTemplateName);
            config.setEmailVerificationErrorTemplateName(this.emailVerificationErrorTemplateName);
            config.setEmailVerificationType(this.emailVerificationType);
            config.setOtpLength(Integer.valueOf(Integer.parseInt(this.otpLength)));
            config.setOtpRetryAttempts(Integer.valueOf(Integer.parseInt(this.otpRetryAttempts)));
            config.setAllowedOtpCharacterSet(this.allowedOtpCharacterSet);
            config.setOtpTimeToLive(Integer.valueOf(Integer.parseInt(this.otpTimeToLive)));
            config.setEmailVerificationOtpTemplateName(this.emailVerificationOtpTemplateName);
            config.setOtlTimeToLive(Integer.parseInt(this.otlTimeToLive));
            config.setFieldUsedForOwnershipVerification(this.fieldUsedForOwnershipVerification);
            config.setFieldStoringVerificationStatus(this.fieldStoringVerificationStatus);
            config.setNotificationPublisherId(this.notificationPublisherId);
            config.setRequireVerifiedEmail(this.requireVerifiedEmail);
            if (StringUtils.isNotBlank((String)this.requireVerifiedEmailTemplateName)) {
                config.setRequireVerifiedEmailTemplateName(this.requireVerifiedEmailTemplateName);
            } else {
                config.setRequireVerifiedEmailTemplateName("local.identity.email.verification.required.html");
            }
        } else {
            lip.setEmailOwnershipVerificationConfig((EmailVerificationConfig)new DefaultEmailVerificationConfig());
        }
        return super.save(dataToDisk);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        super.doSummary(summaryList);
        summaryList.add(new SummaryInfo(emailVerificationEnabledDesc, Boolean.toString(this.emailVerificationEnabled), this));
        if (this.isEmailVerificationEnabled()) {
            summaryList.add(new SummaryInfo(verifyEmailTemplateDesc, this.verifyEmailTemplateName, this));
            if (!EmailVerificationType.OTP.equals((Object)this.emailVerificationType)) {
                summaryList.add(new SummaryInfo(verificationSentTemplateDesc, this.emailVerificationSentTemplateName, this));
            }
            summaryList.add(new SummaryInfo(verificationSuccessTemplateDesc, this.emailVerificationSuccessTemplateName, this));
            summaryList.add(new SummaryInfo(verificationErrorTemplateDesc, this.emailVerificationErrorTemplateName, this));
            summaryList.add(new SummaryInfo(emailVerificationTypeDesc, this.emailVerificationType.getType(), this));
            if (EmailVerificationType.OTP.equals((Object)this.emailVerificationType)) {
                summaryList.add(new SummaryInfo(otpLengthDesc, this.otpLength, this));
                summaryList.add(new SummaryInfo(otpRetryAttemptsDesc, this.otpRetryAttempts, this));
                summaryList.add(new SummaryInfo(allowedOtpCharacterSetDesc, this.allowedOtpCharacterSet, this));
                summaryList.add(new SummaryInfo(otpTimeToLiveDesc, this.otpTimeToLive, this));
                summaryList.add(new SummaryInfo(verificationOtpTemplateDesc, this.emailVerificationOtpTemplateName, this));
            } else {
                summaryList.add(new SummaryInfo(otlTimeToLiveDesc, String.valueOf(this.otlTimeToLive), this));
            }
            summaryList.add(new SummaryInfo(verificationEmailFieldDesc, this.fieldUsedForOwnershipVerification, this));
            summaryList.add(new SummaryInfo(verificationStatusFieldDesc, this.fieldStoringVerificationStatus, this));
            if (StringUtils.isNotBlank((String)this.notificationPublisherId)) {
                summaryList.add(new SummaryInfo(notificationSendersFieldDesc, this.getNotificationPublisherName(this.notificationPublisherId), this));
            } else {
                summaryList.add(new SummaryInfo(notificationSendersFieldDesc, "Default", this));
            }
            summaryList.add(new SummaryInfo(requireVerifiedEmailDesc, Boolean.toString(this.requireVerifiedEmail), this));
            if (this.requireVerifiedEmail && !EmailVerificationType.OTP.equals((Object)this.emailVerificationType)) {
                summaryList.add(new SummaryInfo(requireVerifiedEmailTemplateDesc, this.requireVerifiedEmailTemplateName, this));
            }
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        LocalIdentityProfileEmailVerificationTypeValidator.Builder emailVerificationTypeBuilder = new LocalIdentityProfileEmailVerificationTypeValidator.Builder();
        emailVerificationTypeBuilder.setAdminApiValidation(false).setEmailVerificationEnabled(this.emailVerificationEnabled).setEmailVerificationType(this.emailVerificationType).setOtpLength(this.otpLength).setAllowedOtpCharacterSet(this.allowedOtpCharacterSet).setOtpRetryAttempts(this.otpRetryAttempts).setOtpTimeToLive(this.otpTimeToLive).setEmailVerificationOtpTemplateName(this.emailVerificationOtpTemplateName).setOtlTimeToLive(this.otlTimeToLive).setRequireEmailVerificationTemplateName(this.requireVerifiedEmailTemplateName).setEmailVerificationSentTemplateName(this.emailVerificationSentTemplateName);
        LocalIdentityProfileEmailVerificationTypeValidator emailVerificationTypeValidator = emailVerificationTypeBuilder.build();
        if (!emailVerificationTypeValidator.validate()) {
            this.recordErrors(emailVerificationTypeValidator.getErrors(), delegate);
        }
        if (this.emailVerificationEnabled) {
            boolean isNotificationPublisherPresent = StringUtils.isNotBlank((String)this.notificationPublisherId);
            LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
            if (!localSettings.isEnableSP()) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("sp_role_required_for_email_verification"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.verifyEmailTemplateName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("VerifyEmailTemplateName_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.emailVerificationSentTemplateName) && !EmailVerificationType.OTP.equals((Object)this.emailVerificationType)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("EmailVerificationSentTemplateName_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.emailVerificationSuccessTemplateName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("EmailVerificationSuccessTemplateName_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.emailVerificationErrorTemplateName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("EmailVerificationErrorTemplateName_required"), ValidationConstraint.REQUIRED);
            }
            if (this.requireVerifiedEmail && StringUtils.isBlank((String)this.requireVerifiedEmailTemplateName) && !EmailVerificationType.OTP.equals((Object)this.emailVerificationType)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("RequireVerifiedEmailTemplateName_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.fieldUsedForOwnershipVerification) || !this.getCurrentEmailAndTextFields().contains(this.fieldUsedForOwnershipVerification)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("FieldUsedForOwnershipVerification_required"), ValidationConstraint.REQUIRED);
            }
            if (StringUtils.isBlank((String)this.fieldStoringVerificationStatus) || !this.getCurrentHiddenFields().contains(this.fieldStoringVerificationStatus)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("FieldStoringVerificationStatus_required"), ValidationConstraint.REQUIRED);
            }
            NotificationSenderPluginInstance notificationSenderPluginInstance = (NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getDefaultInstance();
            if (!isNotificationPublisherPresent && notificationSenderPluginInstance == null) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("MailSettings_Notification_Publisher_required"), ValidationConstraint.REQUIRED);
            }
        }
    }

    public boolean isEmailVerificationEnabled() {
        return this.emailVerificationEnabled;
    }

    public void setEmailVerificationEnabled(boolean emailVerificationEnabled) {
        this.emailVerificationEnabled = emailVerificationEnabled;
    }

    public String getVerifyEmailTemplateName() {
        return this.verifyEmailTemplateName;
    }

    public void setVerifyEmailTemplateName(String verifyEmailTemplateName) {
        this.verifyEmailTemplateName = verifyEmailTemplateName;
    }

    public String getEmailVerificationSentTemplateName() {
        return this.emailVerificationSentTemplateName;
    }

    public void setEmailVerificationSentTemplateName(String emailVerificationSentTemplateName) {
        this.emailVerificationSentTemplateName = emailVerificationSentTemplateName;
    }

    public String getEmailVerificationSuccessTemplateName() {
        return this.emailVerificationSuccessTemplateName;
    }

    public void setEmailVerificationSuccessTemplateName(String emailVerificationSuccessTemplateName) {
        this.emailVerificationSuccessTemplateName = emailVerificationSuccessTemplateName;
    }

    public String getEmailVerificationErrorTemplateName() {
        return this.emailVerificationErrorTemplateName;
    }

    public void setEmailVerificationErrorTemplateName(String emailVerificationErrorTemplateName) {
        this.emailVerificationErrorTemplateName = emailVerificationErrorTemplateName;
    }

    public EmailVerificationType getEmailVerificationType() {
        return this.emailVerificationType;
    }

    public void setEmailVerificationType(EmailVerificationType emailVerificationType) {
        this.emailVerificationType = emailVerificationType;
    }

    public String getOtpLength() {
        return this.otpLength;
    }

    public void setOtpLength(String otpLength) {
        this.otpLength = otpLength;
    }

    public String getOtpRetryAttempts() {
        return this.otpRetryAttempts;
    }

    public void setOtpRetryAttempts(String otpRetryAttempts) {
        this.otpRetryAttempts = otpRetryAttempts;
    }

    public String getAllowedOtpCharacterSet() {
        return this.allowedOtpCharacterSet;
    }

    public void setAllowedOtpCharacterSet(String allowedOtpCharacterSet) {
        this.allowedOtpCharacterSet = allowedOtpCharacterSet;
    }

    public String getOtpTimeToLive() {
        return this.otpTimeToLive;
    }

    public void setOtpTimeToLive(String otpTimeToLive) {
        this.otpTimeToLive = otpTimeToLive;
    }

    public String getEmailVerificationOtpTemplateName() {
        return this.emailVerificationOtpTemplateName;
    }

    public void setEmailVerificationOtpTemplateName(String emailVerificationOtpTemplateName) {
        this.emailVerificationOtpTemplateName = emailVerificationOtpTemplateName;
    }

    public String getOtlTimeToLive() {
        return this.otlTimeToLive;
    }

    public void setOtlTimeToLive(String otlTimeToLive) {
        this.otlTimeToLive = otlTimeToLive;
    }

    public String getFieldUsedForOwnershipVerification() {
        return this.fieldUsedForOwnershipVerification;
    }

    public void setFieldUsedForOwnershipVerification(String fieldUsedForOwnershipVerification) {
        this.fieldUsedForOwnershipVerification = fieldUsedForOwnershipVerification;
    }

    public String getFieldStoringVerificationStatus() {
        return this.fieldStoringVerificationStatus;
    }

    public void setFieldStoringVerificationStatus(String fieldStoringVerificationStatus) {
        this.fieldStoringVerificationStatus = fieldStoringVerificationStatus;
    }

    public String getNotificationPublisherId() {
        return this.notificationPublisherId;
    }

    public void setNotificationPublisherId(String notificationPublisherId) {
        this.notificationPublisherId = notificationPublisherId;
    }

    public boolean isRequireVerifiedEmail() {
        return this.requireVerifiedEmail;
    }

    public void setRequireVerifiedEmail(boolean requireVerifiedEmail) {
        this.requireVerifiedEmail = requireVerifiedEmail;
    }

    public String getRequireVerifiedEmailTemplateName() {
        return this.requireVerifiedEmailTemplateName;
    }

    public void setRequireVerifiedEmailTemplateName(String requireVerifiedEmailTemplateName) {
        this.requireVerifiedEmailTemplateName = requireVerifiedEmailTemplateName;
    }

    private List<String> getCurrentConfiguredFields() {
        List<LocalIdentityField<?>> fields = this.findParent(LocalIdentityProfileTasklet.class).getFields();
        return fields.stream().filter(field -> !field.isMarkedForDelete()).map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    private List<String> getCurrentEmailAndTextFields() {
        List<LocalIdentityField<?>> fields = this.findParent(LocalIdentityProfileTasklet.class).getFields();
        return fields.stream().filter(field -> !field.isMarkedForDelete() && (field instanceof EmailField || field instanceof TextField)).map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    private List<String> getCurrentHiddenFields() {
        List<LocalIdentityField<?>> fields = this.findParent(LocalIdentityProfileTasklet.class).getFields();
        return fields.stream().filter(field -> !field.isMarkedForDelete() && field instanceof HiddenField).map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    public IPropertySelectionModel getFieldsUsedForVerificationSelectionList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        String[] fields = this.getCurrentEmailAndTextFields().toArray(new String[0]);
        model.addAllStrings(fields);
        return model;
    }

    public IPropertySelectionModel getNotificationPublisherSelectionList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel("Default");
        for (NotificationSenderPluginInstance instance : MgmtFactory.getNotificationPublisherPluginManager().getInstances()) {
            model.add(instance.getName(), instance.getId());
        }
        model.sort();
        return model;
    }

    public IPropertySelectionModel getFieldsStoringVerificationStatusSelectionList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        String[] fields = this.getCurrentHiddenFields().toArray(new String[0]);
        model.addAllStrings(fields);
        return model;
    }

    private String getNotificationPublisherName(String notificationPublisherId) {
        return ((NotificationSenderPluginInstance)MgmtFactory.getNotificationPublisherPluginManager().getInstance(notificationPublisherId)).getName();
    }

    public boolean isShowNotificationPublisherButton() {
        return this.emailVerificationEnabled;
    }
}

