/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.admin.api.model.JdbcAttributeSource;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.state.impl.LocalIdentityProfileMappingTasklet;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityBranchUtil;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.util.ExtStringPropertySelectionModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityInboundMappingState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 201710180001L;
    private List<TableRow> mappingRows;
    private DataMap.Sources sources = new DataMap.Sources();
    private AttributeMapping attributeMapping = new AttributeMapping();
    private transient Object componentState;
    private boolean testingExpression;
    private List<TestDataItem> testDataList = new ArrayList<TestDataItem>();
    private Object expressionTestState;
    private String expressionToTest;
    private final SimpleFieldDescriptor LIP_FIELDS = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Inbound Mapping Fulfillment", 300, false, "", "--INVALID FIELD--");
    private final SimpleFieldDescriptor SOURCE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Source", 300, false, true);
    private final SimpleFieldDescriptor TEXT_VALUE = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 300, false, "", "--INVALID VALUE--");
    private static final int LIP_FIELD_INDEX = 0;
    private static final int SOURCE_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private String previousNewItemSource = "";
    private String previousEditItemSource = "";

    public LocalIdentityInboundMappingState(Tasklet value, String name) {
        super(value, name);
    }

    public LocalIdentityInboundMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Inbound Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityMappingAction localIdentityMappingAction = (LocalIdentityMappingAction)dataFromDisk;
        if (localIdentityMappingAction.getInboundAttributeMapping() != null) {
            this.attributeMapping = this.shallowCopyOfAttributeMapping(localIdentityMappingAction.getInboundAttributeMapping());
        }
        this.gatherSources();
        this.buildActionModel();
        this.populateMappingRows();
        this.setDescription();
    }

    public void setDescription() {
        if (this.getBranchUtil().isRegistrationBranch()) {
            this.setNoteKey("LocalIdentityInboundMappingState_registration_note");
        } else {
            this.setNoteKey("LocalIdentityInboundMappingState_note");
        }
    }

    private LocalIdentityBranchUtil getBranchUtil() {
        return this.getParentTasklet().getBranchUtil();
    }

    @Override
    public void cancel(Object newData) {
        super.cancel(newData);
        this.setComponentState(null);
    }

    @Override
    public Object[] getFormatObjects() {
        Object[] requiredAttrs = new Object[]{StringUtils.join(this.getBranchUtil().getRequiredAttributes(), (String)",")};
        return requiredAttrs;
    }

    private void populateMappingRows() {
        if (this.mappingRows == null) {
            this.mappingRows = new ArrayList<TableRow>();
        }
        this.mappingRows.clear();
        if (this.attributeMapping != null) {
            Map attrMap = this.attributeMapping.getAttributeMapping();
            for (Map.Entry entry : attrMap.entrySet()) {
                String sourceKey;
                AttrMappingValue attrMappingValue = (AttrMappingValue)((List)entry.getValue()).get(0);
                SimpleFieldDescriptor descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 300);
                String attrSourceId = "";
                if (attrMappingValue.getAttributeSourceId() != null || attrMappingValue.getType().equals((Object)SourceType.TRACKED_HTTP_PARAMS)) {
                    attrSourceId = attrMappingValue.getAttributeSourceId();
                    sourceKey = this.getAttrSourceKey(SourceTypeString.getTypeString((SourceType)attrMappingValue.getType()), attrSourceId);
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Value", 300, false, "", "--INVALID VALUE--");
                    descriptor.setModelValues(this.getValuesModel(sourceKey));
                } else if (attrMappingValue.getAttributeSourceId() != null && attrMappingValue.getType().equals((Object)SourceType.EXPRESSION)) {
                    descriptor.setType(SimpleFieldDescriptor.FieldType.TEXTAREA);
                }
                sourceKey = this.getAttrSourceKey(SourceTypeString.getTypeString((SourceType)attrMappingValue.getType()), attrSourceId);
                String value = attrMappingValue.getValue();
                this.mappingRows.add(this.makeRowFromEntry((String)entry.getKey(), sourceKey, descriptor, value, attrMappingValue.getType().equals((Object)SourceType.EXPRESSION)));
            }
        }
    }

    private void populateAttributeMappingFromMappingRows() {
        HashMap attrMap = new HashMap();
        for (TableRow mappingRow : this.mappingRows) {
            if (mappingRow.isMarkedForDelete()) continue;
            FieldItem lipField = mappingRow.getFields().get(0);
            FieldItem source = mappingRow.getFields().get(1);
            FieldItem value = mappingRow.getFields().get(2);
            String sourceId = DataMap.Sources.getSourceIdFromKey(source.getValue());
            SourceType sourceType = SourceTypeString.strToType((String)DataMap.Sources.getSourceTypeFromKey(source.getValue()));
            AttrMappingValue attrMappingValue = new AttrMappingValue(sourceType, value.getValue(), null, sourceId);
            ArrayList<AttrMappingValue> attrMappingValueList = new ArrayList<AttrMappingValue>();
            attrMappingValueList.add(attrMappingValue);
            attrMap.put(lipField.getValue(), attrMappingValueList);
        }
        if (this.attributeMapping == null) {
            this.attributeMapping = new AttributeMapping();
        }
        this.attributeMapping.setAttributeMap2(attrMap);
    }

    private IPropertySelectionModel getValuesModel(String attrSourceKey) {
        IPropertySelectionModel valuesModel = (IPropertySelectionModel)this.sources.get(attrSourceKey);
        if (valuesModel == null) {
            valuesModel = new StringPairPropertySelectionModel(true);
        }
        return valuesModel;
    }

    public String getAttrSourceKey(String sourceTypeAsString, String sourceId) {
        return DataMap.Sources.createSourceKey(sourceTypeAsString, sourceId);
    }

    protected TableRow makeRowFromEntry(String lipField, String sourceKey, SimpleFieldDescriptor valueFieldDescriptor, String value, boolean isExpression) {
        ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
        fields.add(new FieldItem(this.LIP_FIELDS, lipField));
        fields.add(new FieldItem(this.SOURCE, sourceKey));
        fields.add(new FieldItem(valueFieldDescriptor, value));
        TableRow tableRow = new TableRow(fields);
        tableRow.setExpression(isExpression);
        return tableRow;
    }

    private void updateTrackedParamsRows() {
        this.mappingRows.forEach(row -> {
            FieldItem source = row.getFields().get(1);
            if (source.getLabel().equals("Tracked HTTP Parameters")) {
                FieldItem value = row.getFields().get(2);
                MappingTasklet parent = this.findParent(MappingTasklet.class);
                value.getDescriptor().setModelValues(parent.getTrackedParamsStringPairModel());
            }
        });
    }

    private void setupTestDataList() {
        ArrayList<TestDataItem> refreshedTestDataList = new ArrayList<TestDataItem>();
        for (Map.Entry<String, String> validSubstituterEntry : this.sources.getValidSubstituterValues().entrySet()) {
            String validSubstitutorKey = validSubstituterEntry.getKey();
            boolean foundIt = false;
            for (TestDataItem testDataItem : this.testDataList) {
                if (!validSubstitutorKey.equals(testDataItem.getFieldName())) continue;
                refreshedTestDataList.add(testDataItem);
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            refreshedTestDataList.add(new TestDataItem(validSubstitutorKey, ""));
        }
        this.testDataList = refreshedTestDataList;
    }

    private void buildActionModel() {
        this.LIP_FIELDS.setModelValues(this.getAllLipFieldNameModelValues());
        this.SOURCE.setModelValues(this.getSourcesModel());
        this.TEXT_VALUE.setEnabled(false);
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityMappingAction localIdentityMappingAction = (LocalIdentityMappingAction)dataToDisk;
        AttributeMapping outmap = localIdentityMappingAction.getInboundAttributeMapping();
        if (outmap != null) {
            Map attrMap = this.attributeMapping.getAttributeMapping();
            outmap.setAttributeMap2(attrMap);
        }
        return true;
    }

    @Override
    public void onStateActivated() {
        this.gatherSources();
        this.setupTestDataList();
        if (this.mappingRows == null || this.mappingRows.isEmpty()) {
            this.mappingRows = new ArrayList<TableRow>();
        }
        this.buildActionModel();
        this.updateTrackedParamsRows();
    }

    @Override
    public void reset() {
    }

    @Override
    public List<String> validate(TableRow updatedRow, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> errors = new ArrayList<String>();
        String lipField = updatedRow.getFields().get(0).getValue();
        if (StringUtils.isBlank((String)lipField)) {
            errors.add("The 'Inbound Mapping Fulfillment' is empty.");
        } else if (originalRow == null || !originalRow.getFields().get(0).getValue().equals(lipField)) {
            for (TableRow tableRow : list) {
                if (!tableRow.getFields().get(0).getValue().equals(lipField)) continue;
                errors.add("Duplicate 'Inbound Mapping Fulfillment' " + lipField + ". Please select a different field.");
            }
        }
        if (StringUtils.isBlank((String)updatedRow.getFields().get(1).getValue())) {
            errors.add("The 'Source' is empty.");
        }
        if (StringUtils.isBlank((String)updatedRow.getFields().get(2).getValue())) {
            errors.add("The 'Value' is empty.");
        }
        return errors;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
        this.populateAttributeMappingFromMappingRows();
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
        this.populateAttributeMappingFromMappingRows();
    }

    @Override
    public void onDeleteItem(TableEditor owner, TableRow deletedRow) {
        this.populateAttributeMappingFromMappingRows();
    }

    @Override
    public void onUndeleteItem(TableEditor owner, TableRow deletedRow) {
        this.populateAttributeMappingFromMappingRows();
    }

    @Override
    public void onEditItem(TableEditor owner, TableRow originalRow, TableRow newRow) {
        this.previousEditItemSource = originalRow.getFields().get(1).getValue();
    }

    @Override
    public void onTestExpressionItem(TableEditor owner, TableRow currentRow, TableRow newRow) {
        this.setTestingExpression(true);
        if (newRow != null) {
            this.setExpressionToTest(newRow.getFields().get(2).getValue());
        } else {
            this.setExpressionToTest(currentRow.getFields().get(2).getValue());
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        TableRow updateItem = ((TableEditor.State)this.componentState).getUpdateItem();
        TableRow newItem = ((TableEditor.State)this.componentState).getNewItem();
        TableRow editItem = ((TableEditor.State)this.componentState).getEditItem();
        boolean isEditMode = ((TableEditor.State)this.componentState).isEditMode();
        if (isEditMode) {
            SimpleFieldDescriptor descriptor;
            FieldItem updatedSourceItem = updateItem.getFields().get(1);
            String sourceId = DataMap.Sources.getSourceIdFromKey(updatedSourceItem.getValue());
            String sourceType = DataMap.Sources.getSourceTypeFromKey(updatedSourceItem.getValue());
            editItem.setExpression(false);
            updateItem.setExpression(false);
            if (sourceId == null && sourceType != null && !"Tracked HTTP Parameters".equalsIgnoreCase(sourceType)) {
                if ("Expression".equalsIgnoreCase(sourceType)) {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXTAREA, "Value", 300);
                    editItem.setExpression(true);
                    updateItem.setExpression(true);
                } else {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 300);
                }
                descriptor.setModelValues(null);
            } else {
                descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Value", 300);
                descriptor.setModelValues(this.getValuesModel(updatedSourceItem.getValue()));
            }
            updateItem.getFields().get(2).setDescriptor(descriptor);
            if (updatedSourceItem.getValue() != null) {
                if (!this.previousEditItemSource.equals(updatedSourceItem.getValue())) {
                    updateItem.getFields().get(2).setValue(null);
                }
                this.previousEditItemSource = updatedSourceItem.getValue();
            }
        } else if (newItem != null) {
            String newItemSourceValue = newItem.getFields().get(1).getValue();
            newItem.setExpression(false);
            if (newItemSourceValue != null && !newItemSourceValue.isEmpty()) {
                SimpleFieldDescriptor descriptor;
                String sourceId = DataMap.Sources.getSourceIdFromKey(newItemSourceValue);
                String sourceType = DataMap.Sources.getSourceTypeFromKey(newItemSourceValue);
                if (sourceId == null && sourceType != null && !"Tracked HTTP Parameters".equalsIgnoreCase(sourceType)) {
                    if ("Expression".equalsIgnoreCase(sourceType)) {
                        descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXTAREA, "Value", 300);
                        newItem.setExpression(true);
                    } else {
                        descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Value", 300);
                    }
                    descriptor.setModelValues(null);
                } else {
                    descriptor = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.DROPDOWN, "Value", 300);
                    descriptor.setModelValues(this.getValuesModel(newItemSourceValue));
                }
                newItem.getFields().get(2).setDescriptor(descriptor);
                newItem.getFields().get(2).setEnabled(true);
            }
            if (this.previousNewItemSource != null && !this.previousNewItemSource.equals(newItemSourceValue)) {
                newItem.getFields().get(2).setValue(null);
            }
            this.previousNewItemSource = newItemSourceValue;
        }
    }

    private LocalIdentityProfileMappingTasklet getParentTasklet() {
        return this.findParent(LocalIdentityProfileMappingTasklet.class);
    }

    public IPropertySelectionModel getAllLipFieldNameModelValues() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (String lipField : this.getAllAttributes()) {
            model.add(lipField, lipField);
        }
        return model;
    }

    private IPropertySelectionModel getAllSourceNameModelValues() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (String sourceValue : this.sources.getSourceKeysToLabels().values()) {
            model.add(sourceValue, sourceValue);
        }
        return model;
    }

    public IPropertySelectionModel getSourcesModel() {
        ArrayList<String> l = new ArrayList<String>(this.sources.getSourceMap().keySet());
        Collections.sort(l, String.CASE_INSENSITIVE_ORDER);
        StringPairPropertySelectionModel sourcesModel = new StringPairPropertySelectionModel(true);
        for (String sourceKey : l) {
            String sourceLabel = this.sources.getSourceKeysToLabels().get(sourceKey);
            if (sourceLabel == null) {
                sourceLabel = sourceKey;
            }
            sourcesModel.add(sourceLabel, sourceKey);
        }
        return sourcesModel;
    }

    private void gatherSources() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        LocalIdentityProfileMappingTasklet registrationMappingTasklet = this.findParent(LocalIdentityProfileMappingTasklet.class);
        registrationMappingTasklet.getUpstreamSources(this.sources);
        this.sources.addTextSource("Text");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        if (this.attributeMapping != null && this.attributeMapping.getAttributeSources() != null && !this.attributeMapping.getAttributeSources().isEmpty()) {
            HashMap<AttributeSource, IPropertySelectionModel> models = new HashMap<AttributeSource, IPropertySelectionModel>();
            for (AttributeSource attributeSource : this.attributeMapping.getAttributeSources()) {
                IPropertySelectionModel model = this.getIPropertySelectionModel(attributeSource);
                models.put(attributeSource, model);
            }
            for (Map.Entry entry : models.entrySet()) {
                String selectionLabel = ((AttributeSource)entry.getKey()).getType() + " (" + ((AttributeSource)entry.getKey()).getDescription() + ")";
                this.sources.addPropertySelectionSource(((AttributeSource)entry.getKey()).getType(), ((AttributeSource)entry.getKey()).getId(), selectionLabel, (IPropertySelectionModel)entry.getValue());
            }
        }
        registrationMappingTasklet.addTrackedParamsToSelectionSources(this.sources);
        registrationMappingTasklet.addInputContractToSelectionSources(this.sources);
    }

    private IPropertySelectionModel getIPropertySelectionModel(AttributeSource attributeSource) {
        return new ExtStringPropertySelectionModel(this.initExpectedAttributes(attributeSource).toArray(new String[0]));
    }

    private List<String> initExpectedAttributes(AttributeSource attributeSource) {
        ArrayList<String> expectedAttributes = new ArrayList<String>();
        if (attributeSource != null && attributeSource.getDataSourceId() != null) {
            String dsId = attributeSource.getDataSourceId();
            if (attributeSource.getType().equals("Other")) {
                CustomDataSource customStore = MgmtFactory.getDataSourceManager().getCustomDataSource(dsId);
                if (customStore != null) {
                    if (customStore.getDriver() == null) {
                        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                        dsMgr.loadCustomDataSourceDriver(customStore);
                    }
                    expectedAttributes.addAll(customStore.getDriver().getAvailableFields());
                }
            } else if (attributeSource.getType().equals("LDAP")) {
                LdapDataSource ldapStore = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
                if (ldapStore != null) {
                    expectedAttributes.add("Subject DN");
                    expectedAttributes.addAll(ldapStore.getLDAPAttributeNameList());
                }
            } else if (attributeSource.getType().equals("JDBC") && attributeSource instanceof JdbcAttributeSource) {
                JdbcAttributeSource jdbcAttrSource = (JdbcAttributeSource)attributeSource;
                JdbcDataSource jdbcStore = MgmtFactory.getDataSourceManager().getJdbcDataSource(dsId);
                if (jdbcStore != null) {
                    expectedAttributes.addAll(jdbcStore.getUnsortedColumns(jdbcAttrSource.getSchema(), jdbcAttrSource.getTable()));
                }
            }
        }
        return expectedAttributes;
    }

    public List<TableRow> getMappingRows() {
        return this.mappingRows;
    }

    public void setMappingRows(List<TableRow> mappingRows) {
        this.mappingRows = mappingRows;
    }

    public List<SimpleFieldDescriptor> getRegistrationMappingColumnDescriptors() {
        ArrayList<SimpleFieldDescriptor> tableList = new ArrayList<SimpleFieldDescriptor>();
        tableList.add(this.LIP_FIELDS);
        tableList.add(this.SOURCE);
        tableList.add(this.TEXT_VALUE);
        return tableList;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public AttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(AttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        this.populateAttributeMappingFromMappingRows();
        if (this.attributeMapping != null) {
            List<String> targets;
            Map attrMap = this.attributeMapping.getAttributeMapping();
            if (attrMap.isEmpty()) {
                summaryList.add(new SummaryInfo(this.getMessage("Mappings"), "(None)", this));
            }
            if ((targets = this.getParentTasklet().getLocalIdentityFields()) == null) {
                targets = new ArrayList<String>();
            }
            targets.addAll(this.getBranchUtil().getRequiredAttributes());
            for (Map.Entry entry : attrMap.entrySet()) {
                if (!targets.contains(entry.getKey())) continue;
                for (AttrMappingValue v : (List)entry.getValue()) {
                    if (v != null) {
                        summaryList.add(new SummaryInfo((String)entry.getKey(), this.getAttrValueForDisplay(v) + " (" + v.getTypeString() + ")", this));
                        continue;
                    }
                    summaryList.add(new SummaryInfo((String)entry.getKey(), "Not defined", this));
                }
            }
        }
    }

    public String getAttrValueForDisplay(AttrMappingValue attrMappingValue) {
        return attrMappingValue.getValue();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.isViewOnly()) {
            this.onStateActivated();
            if (this.attributeMapping == null && !this.getBranchUtil().getRequiredAttributes().isEmpty()) {
                Object[] objects = new Object[]{StringUtils.join(this.getBranchUtil().getRequiredAttributes(), (String)", ")};
                delegate.record(this.getMessage("Required_attrs_missing", objects), ValidationConstraint.REQUIRED);
            }
            if (this.attributeMapping != null) {
                Map attribMap = this.attributeMapping.getAttributeMapping();
                for (String requiredAttr : this.getBranchUtil().getRequiredAttributes()) {
                    if (attribMap.containsKey(requiredAttr)) continue;
                    Object[] objects = new Object[]{requiredAttr};
                    delegate.record(this.getMessage("Required_attr_missing", objects), ValidationConstraint.REQUIRED);
                }
                List<String> allAttrs = this.getAllAttributes();
                boolean foundInvalidAttr = false;
                for (Map.Entry entry : attribMap.entrySet()) {
                    Object[] objects = new Object[]{entry.getKey()};
                    if (!allAttrs.contains(entry.getKey())) {
                        foundInvalidAttr = true;
                    }
                    for (AttrMappingValue amv : (List)entry.getValue()) {
                        String sourceKey = this.getAttrSourceKey(SourceTypeString.getTypeString((SourceType)amv.getType()), amv.getAttributeSourceId());
                        if (StringUtils.isBlank((String)amv.getValue()) && amv.getType() != SourceType.TEXT) {
                            delegate.setFormComponent(null);
                            delegate.record(this.getMessage("Does_not_have_mapped_value", objects), ValidationConstraint.REQUIRED);
                            continue;
                        }
                        if (this.sources.isValidSourceValue(sourceKey, amv.getValue())) continue;
                        delegate.setFormComponent(null);
                        if (this.sources.getCustomizedErrorMessage() != null) {
                            delegate.record(this.sources.getCustomizedErrorMessage(), ValidationConstraint.REQUIRED);
                            continue;
                        }
                        ExpressionManager expressionManager = ExpressionManager.getInstance();
                        if (amv.getType() == SourceType.EXPRESSION && expressionManager.isEvaluateExpressionsOff()) {
                            delegate.record(this.getMessage("Expressions_turned_off", objects), ValidationConstraint.REQUIRED);
                            continue;
                        }
                        delegate.record(this.getMessage("Must_have_valid_value", objects), ValidationConstraint.REQUIRED);
                    }
                }
                if (foundInvalidAttr) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("invalid_inbound_attribute"), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    private AttributeMapping shallowCopyOfAttributeMapping(AttributeMapping attributeMapping) {
        AttributeMapping clone = new AttributeMapping();
        if (attributeMapping.getAttributeSource() != null) {
            clone.setAttributeSource(attributeMapping.getAttributeSource());
        }
        clone.setAttributeMap2(attributeMapping.getAttributeMapping());
        clone.setTokenAuthorizationIssuanceCriteria(attributeMapping.getTokenAuthorizationIssuanceCriteria());
        return clone;
    }

    public List<String> getAllAttributes() {
        List<String> fields = this.getParentTasklet().getLocalIdentityFields();
        ArrayList<String> allAttrs = new ArrayList<String>();
        if (fields != null) {
            allAttrs.addAll(fields);
        }
        allAttrs.addAll(this.getBranchUtil().getExtraAttributes());
        return allAttrs;
    }

    public boolean isTestingExpression() {
        return this.testingExpression;
    }

    public void setTestingExpression(boolean testingExpression) {
        this.testingExpression = testingExpression;
    }

    public DataMap.Sources getSources() {
        return this.sources;
    }

    public String getExpressionToTest() {
        return this.expressionToTest;
    }

    public void setExpressionToTest(String expression) {
        this.expressionToTest = expression;
        TableRow updateItem = ((TableEditor.State)this.componentState).getUpdateItem();
        if (updateItem != null) {
            updateItem.getFields().get(2).setValue(expression);
        }
    }

    public List<TestDataItem> getTestDataList() {
        return this.testDataList;
    }

    public void setTestDataList(List<TestDataItem> testDataList) {
        this.testDataList = testDataList;
    }

    public Object getExpressionTestState() {
        return this.expressionTestState;
    }

    public void setExpressionTestState(Object state) {
        this.expressionTestState = state;
    }
}

