/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.localidentity;

import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.LocalIdentityProfileMappingTasklet;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.localidentity.FieldConfig;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.AttributeMapping;

public class LocalIdentityOutboundContractMappingState
extends MappingState
implements Serializable {
    private static final String OUTBOUND_MODEL_TARGET_NAME = "Outbound Contract Fulfillment";

    public LocalIdentityOutboundContractMappingState(Tasklet value) {
        super(value, "mapping");
        this.setMenuName("Contract Fulfillment");
        this.model.setTargetName("Contract Fulfillment");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalIdentityMappingAction localIdentityMappingAction = (LocalIdentityMappingAction)dataFromDisk;
        this.attributeMapping = localIdentityMappingAction.getOutboundAttributeMapping();
        super.populate(this.attributeMapping);
        this.model = new SAML2MappingModel(OUTBOUND_MODEL_TARGET_NAME, this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalIdentityMappingAction localIdentityMappingAction = (LocalIdentityMappingAction)dataToDisk;
        AttributeMapping outmap = localIdentityMappingAction.getOutboundAttributeMapping();
        Map attrMap = this.model.getMapping().getAttributeMapping();
        outmap.setAttributeMap2(attrMap);
        return true;
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        LocalIdentityProfileMappingTasklet registrationMappingTasklet = this.findParent(LocalIdentityProfileMappingTasklet.class);
        registrationMappingTasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        this.sources.addTextSource("Text");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        registrationMappingTasklet.addLipToPropertySelectionSources(this.sources);
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
    }

    @Override
    public void reset() {
        this.sources = null;
        this.model = new SAML2MappingModel(this.getCurrentUser());
        this.model.setTargetName(OUTBOUND_MODEL_TARGET_NAME);
    }

    @Override
    public Collection<String> getTarget() {
        LocalIdentityProfileMappingTasklet parentTasklet = this.findParent(LocalIdentityProfileMappingTasklet.class);
        return new HashSet<String>(parentTasklet.getContractToFulfill());
    }

    private List<String> getLipFieldIdLabels(FieldConfig fieldConfig) {
        List fields = fieldConfig.getListOfAllFields();
        return fields.stream().map(field -> field.getData().getId()).collect(Collectors.toList());
    }
}

