/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorPolicyManagementTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;

public class ProcessorMappingContractFulfillmentState
extends MappingState
implements Serializable {
    private static final long serialVersionUID = 2019102801L;
    private static final String TARGET_NAME = "Processor Policy Contract";

    public ProcessorMappingContractFulfillmentState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Contract Fulfillment");
        this.model.setTargetName(TARGET_NAME);
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof TokenExchangeProcessorMapping) {
            TokenExchangeProcessorMapping mapping = (TokenExchangeProcessorMapping)dataFromDisk;
            this.attributeMapping = mapping.getAttributeMapping();
            this.model = new SAML2MappingModel(TARGET_NAME, this.attributeMapping, this.getCurrentUser());
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof TokenExchangeProcessorMapping) {
            TokenExchangeProcessorMapping mapping = (TokenExchangeProcessorMapping)dataToDisk;
            AttributeMapping attributeMapping = mapping.getAttributeMapping();
            attributeMapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        }
        return true;
    }

    @Override
    public Collection<String> getTarget() {
        ProcessorPolicyManagementTasklet parent = this.findParent(ProcessorPolicyManagementTasklet.class);
        return parent.getAllAttributeNames();
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        ProcessorMappingTasklet parent = this.findParent(ProcessorMappingTasklet.class);
        parent.addContextSources(this.sources);
        parent.addTokenProcessorSources(this.sources);
    }

    public List<String> getDataMapListOrder() {
        return new ArrayList<String>(this.getTarget());
    }

    @Override
    public String getAttrValueForDisplay(AttrMappingValue attrMappingValue) {
        String value = attrMappingValue.getValue();
        if (value.startsWith("subjecttoken.") || value.startsWith("actortoken.") || value.startsWith("context.")) {
            value = StringUtils.substringAfter((String)value, (String)".");
        }
        return value;
    }
}

