/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorMappingValidator;
import com.pingidentity.admin.api.validator.oauth.exchange.UiProcessorMappingTokenTypeValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorMappingTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;

public class ProcessorMappingState
extends TaskletState
implements Serializable {
    private static final String MENU_NAME = "Token Processor Mapping";
    private List<ProcessorMappingTasklet> processorMappingTasklets = new ArrayList<ProcessorMappingTasklet>();

    public ProcessorMappingState(IWizard owner) {
        super(owner);
        this.setMenuName(MENU_NAME);
    }

    public Optional<ProcessorMappingTasklet> getTaskletById(String taskletId) {
        return this.processorMappingTasklets.stream().filter(tasklet -> taskletId.equals(tasklet.getTaskletId())).findFirst();
    }

    public void delete(String id) {
        this.getTaskletById(id).ifPresent(tasklet -> tasklet.setItDeleted(true));
    }

    public void undelete(String id) {
        this.getTaskletById(id).ifPresent(tasklet -> tasklet.setItDeleted(false));
    }

    @Override
    public void updateVisit(Visit freshVisit) {
        this.processorMappingTasklets.forEach(tasklet -> tasklet.updateVisit(freshVisit));
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        super.getSummary(summaryList);
        this.processorMappingTasklets.stream().filter(tasklet -> !tasklet.isItDeleted()).forEach(Tasklet::getSummary);
    }

    @Override
    public void initialize() {
        this.processorMappingTasklets.forEach(Tasklet::initialize);
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (!taskletToEdit.isCancelled() && !this.processorMappingTasklets.contains(taskletToEdit) && taskletToEdit instanceof ProcessorMappingTasklet) {
            ProcessorMappingTasklet tasklet = (ProcessorMappingTasklet)taskletToEdit;
            tasklet.setMode(Mode.edit);
            this.processorMappingTasklets.add(tasklet);
            Collections.sort(this.processorMappingTasklets);
        }
    }

    @Override
    public void reset() {
        this.processorMappingTasklets.clear();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.reset();
        TokenExchangeProcessorPolicy policy = (TokenExchangeProcessorPolicy)dataFromDisk;
        for (TokenExchangeProcessorMapping processorMapping : policy.getTokenExchangeProcessorMappings().values()) {
            ProcessorMappingTasklet tasklet = this.createTasklet(ProcessorMappingTasklet.class);
            tasklet.setMode(Mode.edit);
            tasklet.populate(processorMapping);
            this.processorMappingTasklets.add(tasklet);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenExchangeProcessorPolicy policy = (TokenExchangeProcessorPolicy)dataToDisk;
        this.processorMappingTasklets.stream().filter(tasklet -> !tasklet.isItDeleted()).map(tasklet -> {
            TokenExchangeProcessorMapping mapping = new TokenExchangeProcessorMapping();
            tasklet.save(mapping);
            return mapping;
        }).forEach(arg_0 -> ((TokenExchangeProcessorPolicy)policy).addTokenExchangeProcessorMapping(arg_0));
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        ProcessorMappingValidator validator = new ProcessorMappingValidator(this.getEffectiveMappingList());
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        } else {
            for (ProcessorMappingTasklet tasklet : this.processorMappingTasklets) {
                if (tasklet.isItDeleted()) continue;
                tasklet.appendErrors(delegate, component, fastFail);
            }
        }
    }

    private boolean hasNoMapping() {
        return this.processorMappingTasklets.isEmpty() || this.processorMappingTasklets.stream().allMatch(Tasklet::isItDeleted);
    }

    private List<?> getEffectiveMappingList() {
        return this.processorMappingTasklets.stream().filter(tasklet -> !tasklet.isItDeleted()).collect(Collectors.toList());
    }

    @Override
    public boolean onStateExit() {
        this.processorMappingTasklets.removeIf(Tasklet::isItDeleted);
        return !this.processorMappingTasklets.isEmpty();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        Function<ProcessorMappingTasklet, SummaryInfo> tasklet2SummaryInfo = tasklet -> {
            String subjectTokenType = tasklet.getSubjectTokenType();
            String actorTokenType = tasklet.getActorTokenType();
            String value = StringUtils.isBlank((String)actorTokenType) ? String.format("Mapping of [%s] subject token type", subjectTokenType) : String.format("Mapping of [%s] subject token type and [%s] actor token type", subjectTokenType, actorTokenType);
            return new SummaryInfo(MENU_NAME, value, this);
        };
        List summaryInfos = this.processorMappingTasklets.stream().map(tasklet2SummaryInfo).sorted().collect(Collectors.toList());
        summaryList.addAll(summaryInfos);
    }

    public List<ProcessorMappingTasklet> getProcessorMappingTasklets() {
        return this.processorMappingTasklets;
    }

    public void setProcessorMappingTasklets(List<ProcessorMappingTasklet> processorMappingTasklets) {
        this.processorMappingTasklets = processorMappingTasklets;
    }

    public List<UiProcessorMappingTokenTypeValidator.TokenTypePair> getTokenTypePairs(String taskletId) {
        return this.processorMappingTasklets.stream().filter(tasklet -> !tasklet.isItDeleted()).filter(tasklet -> !tasklet.getTaskletId().equals(taskletId)).map(tasklet -> new UiProcessorMappingTokenTypeValidator.TokenTypePair(tasklet.getSubjectTokenType(), tasklet.getActorTokenType())).collect(Collectors.toList());
    }
}

