/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.admin.api.validator.oauth.exchange.UiProcessorMappingTokenTypeValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.ProcessorPolicyManagementTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.util.TokenExchangeTokenTypeLookupUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class ProcessorMappingTokenTypeState
extends TaskletState {
    private String subjectTokenType;
    private String subjectTokenProcessor;
    private String actorTokenType;
    private String actorTokenProcessor;
    private final TokenProcessorManager tokenProcessorMgr = MgmtFactory.getTokenProcessorManager();
    private final Function<Collection<TokenProcessorInstance>, IPropertySelectionModel> toSelectionModel = instances -> {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        for (TokenProcessorInstance instance : instances) {
            if (instance.getDescriptor() == null) continue;
            model.add(instance.getName(), instance.getId());
        }
        model.sort();
        return model;
    };

    public ProcessorMappingTokenTypeState(IWizard owner) {
        super(owner);
        this.setMenuName("Token Types");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof TokenExchangeProcessorMapping) {
            TokenExchangeProcessorMapping mapping = (TokenExchangeProcessorMapping)dataFromDisk;
            this.setSubjectTokenType(mapping.getSubjectTokenType());
            this.setSubjectTokenProcessor(mapping.getSubjectTokenProcessorId());
            this.setActorTokenType(mapping.getActorTokenType());
            this.setActorTokenProcessor(mapping.getActorTokenProcessorId());
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (dataToDisk instanceof TokenExchangeProcessorMapping) {
            TokenExchangeProcessorMapping mapping = (TokenExchangeProcessorMapping)dataToDisk;
            mapping.setSubjectTokenType(StringUtils.trim((String)this.getSubjectTokenType()));
            mapping.setSubjectTokenProcessorId(this.getSubjectTokenProcessor());
            mapping.setActorTokenType(StringUtils.trim((String)this.getActorTokenType()));
            mapping.setActorTokenProcessorId(this.getActorTokenProcessor());
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Subject Token Processor", this.subjectTokenProcessor, this));
        summaryList.add(new SummaryInfo("Subject Token Type", this.subjectTokenType, this));
        summaryList.add(new SummaryInfo("Actor Token Processor", this.actorTokenProcessor, this));
        summaryList.add(new SummaryInfo("Actor Token Type", this.actorTokenType, this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        UiProcessorMappingTokenTypeValidator validator = new UiProcessorMappingTokenTypeValidator(this.tokenProcessorMgr, this.getSubjectTokenType(), this.getSubjectTokenProcessor());
        if (this.isActorTokenRequired() || StringUtils.isNotBlank((String)this.getActorTokenType()) || StringUtils.isNotBlank((String)this.getActorTokenProcessor())) {
            validator.validateActorSettings(this.tokenProcessorMgr, this.getActorTokenType(), this.getActorTokenProcessor());
        }
        ProcessorPolicyManagementTasklet parent = this.findParent(ProcessorPolicyManagementTasklet.class);
        List<UiProcessorMappingTokenTypeValidator.TokenTypePair> tokenTypePairs = parent.getTokenTypePairs(this.getParent().getTaskletId());
        UiProcessorMappingTokenTypeValidator.TokenTypePair currentTokenTypePair = new UiProcessorMappingTokenTypeValidator.TokenTypePair(this.getSubjectTokenType(), this.getActorTokenType());
        validator.addDuplicateTokenTypeValidator(tokenTypePairs, currentTokenTypePair);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public void setSubjectTokenType(String subjectTokenType) {
        this.subjectTokenType = subjectTokenType;
    }

    public String getSubjectTokenProcessor() {
        return this.subjectTokenProcessor;
    }

    public void setSubjectTokenProcessor(String subjectTokenProcessor) {
        this.subjectTokenProcessor = subjectTokenProcessor;
    }

    public String getActorTokenType() {
        return this.actorTokenType;
    }

    public void setActorTokenType(String actorTokenType) {
        this.actorTokenType = actorTokenType;
    }

    public String getActorTokenProcessor() {
        return this.actorTokenProcessor;
    }

    public void setActorTokenProcessor(String actorTokenProcessor) {
        this.actorTokenProcessor = actorTokenProcessor;
    }

    public IPropertySelectionModel getSubjectTokenProcessorInstances() {
        return this.toSelectionModel.apply(this.tokenProcessorMgr.getNonConnectionBasedInstances());
    }

    public IPropertySelectionModel getActorTokenProcessorInstances() {
        return this.toSelectionModel.apply(this.tokenProcessorMgr.getNonConnectionBasedInstances());
    }

    public boolean isActorTokenRequired() {
        ProcessorMappingTasklet parent = (ProcessorMappingTasklet)this.getParent();
        return parent.isActorTokenRequired();
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        TokenExchangeTokenTypeLookupUtil util = new TokenExchangeTokenTypeLookupUtil();
        if (StringUtils.isNotBlank((String)this.subjectTokenProcessor) && StringUtils.isBlank((String)this.subjectTokenType)) {
            this.subjectTokenType = util.getTokenProcessorTokenExchangeTokenType(this.subjectTokenProcessor, this.tokenProcessorMgr);
        }
        if (StringUtils.isNotBlank((String)this.actorTokenProcessor) && StringUtils.isBlank((String)this.actorTokenType)) {
            this.actorTokenType = util.getTokenProcessorTokenExchangeTokenType(this.actorTokenProcessor, this.tokenProcessorMgr);
        }
    }
}

