/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.fsm.state.impl.Source2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.Source2TargetMappingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.PolicyProcessor2GeneratorMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collection;
import java.util.Map;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.oauth20.exchange.domain.ProcessorPolicy2GeneratorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.BasePluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class ProcessorPolicy2GeneratorMappingsState
extends Source2TargetMappingsState<ProcessorPolicy2GeneratorMapping> {
    private static final long serialVersionUID = 2019111201L;
    private final transient TokenGeneratorManager tokenGeneratorMgr = MgmtFactory.getTokenGeneratorManager();
    private final transient TokenExchangeProcessorPolicyManager processorPolicyMgr = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private final transient ProcessorPolicy2TokenGeneratorManager mappingMgr = MgmtFactory.getProcessorPolicy2TokenGeneratorManager();

    public ProcessorPolicy2GeneratorMappingsState(Tasklet owner) {
        super(owner);
    }

    @Override
    public Collection<ProcessorPolicy2GeneratorMapping> populateSource2TargetMappings() {
        return this.mappingMgr.getMappings();
    }

    @Override
    public Class<? extends Source2TargetMappingTasklet<ProcessorPolicy2GeneratorMapping>> getMappingTaskletClass() {
        return PolicyProcessor2GeneratorMappingTasklet.class;
    }

    @Override
    public IPropertySelectionModel getSourceInstances() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        Map policies = this.processorPolicyMgr.getTokenExchangeProcessorPolicies().getPolicies();
        for (TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy : policies.values()) {
            model.add(tokenExchangeProcessorPolicy.getName(), ProcessorPolicy2GeneratorMappingsState.createDummySource(tokenExchangeProcessorPolicy));
        }
        model.sort();
        return model;
    }

    @Override
    public IPropertySelectionModel getTargetInstances() {
        return this.toSelectionModel(this.tokenGeneratorMgr.getNonConnectionBasedInstances());
    }

    @Override
    public String getMappingsHeaderText() {
        return "Processor Policy to Token Generator mapping";
    }

    @Override
    public String getMessageKeyPrefix() {
        return "PP2TG";
    }

    @Override
    public ProcessorPolicy2GeneratorMapping makeMapping() {
        return new ProcessorPolicy2GeneratorMapping();
    }

    public static ConfigurablePluginInstance createDummySource(TokenExchangeProcessorPolicy policy) {
        BasePluginInstance dummySourcePlugin = new BasePluginInstance();
        dummySourcePlugin.setId(policy.getId());
        dummySourcePlugin.setName(policy.getName());
        dummySourcePlugin.setImmutableAttributeContract(policy.getContract().getImmutableAttributeNames());
        dummySourcePlugin.setExtendedContractAttributes(policy.getContract().getMutableAttributeNames());
        return dummySourcePlugin;
    }
}

