/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.oauth.exchange;

import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorPolicyBasicsValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorPoliciesManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ProcessorPolicyManagementState
extends TaskletState {
    private static final String MENU_NAME = "Manage Processor Policy";
    private final TokenExchangeProcessorPolicyManager processorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private String id;
    private String name;
    private boolean actorTokenRequired;

    public ProcessorPolicyManagementState(IWizard owner) {
        super(owner);
        this.setMenuName(MENU_NAME);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("ID", this.getId(), this));
        summaryList.add(new SummaryInfo("Name", this.getName(), this));
        summaryList.add(new SummaryInfo("Actor Token Required", Boolean.toString(this.isActorTokenRequired()), this));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActorTokenRequired() {
        return this.actorTokenRequired;
    }

    public void setActorTokenRequired(boolean actorTokenRequired) {
        this.actorTokenRequired = actorTokenRequired;
    }

    @Override
    public void populate(Object dataFromDisk) {
        TokenExchangeProcessorPolicy policy = (TokenExchangeProcessorPolicy)dataFromDisk;
        this.id = policy.getId();
        this.name = policy.getName();
        this.actorTokenRequired = policy.isActorTokenRequired();
    }

    @Override
    public boolean save(Object dataToDisk) {
        TokenExchangeProcessorPolicy policy = (TokenExchangeProcessorPolicy)dataToDisk;
        this.fillDomain(policy);
        this.setDefaultIfNeeded(policy.getId());
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Set existingIds = this.processorPolicyManager.getTokenExchangeProcessorPolicies().getPolicyIds();
        Set existingNames = this.processorPolicyManager.getTokenExchangeProcessorPolicies().getPolicyNames();
        String currentName = this.processorPolicyManager.getTokenExchangeProcessorPolicies().containsInstance(this.id) ? this.processorPolicyManager.getTokenExchangeProcessorPolicies().getPolicy(this.id).getName() : null;
        ProcessorPolicyBasicsValidator validator = new ProcessorPolicyBasicsValidator(this.id, this.name, this.isCreateMode(), existingIds, existingNames, currentName);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private boolean isCreateMode() {
        Tasklet t = this.getParent();
        return t.getMode() == Mode.create;
    }

    private void setDefaultIfNeeded(String id) {
        this.getParent().getParentTasklet().getStateList().stream().filter(taskletState -> taskletState instanceof ProcessorPoliciesManagementState).map(taskletState -> (ProcessorPoliciesManagementState)taskletState).findFirst().ifPresent(state -> {
            if (StringUtils.isEmpty((String)state.getDefaultId())) {
                state.setDefaultId(id);
            }
        });
    }

    private void fillDomain(TokenExchangeProcessorPolicy policy) {
        policy.setId(this.id);
        policy.setName(this.name);
        policy.setActorTokenRequired(this.actorTokenRequired);
    }
}

