/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.common.util.ldap.LDAPErrorException;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.common.util.ldap.PingSslClientTrustManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.state.impl.setup.AbstractSetupState;
import com.pingidentity.fsm.state.impl.setup.LdapsConfirmationState;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.util.StringPairPropertySelectionModel;
import com.pingidentity.validator.LdapConfigValidator;
import com.pingidentity.validator.TrustAllCertsTrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class AbstractDirectoryConfigState
extends AbstractSetupState {
    private static final String DEFAULT_AD_SEARCH_FILTER = "sAMAccountName=${username}";
    private static final String DEFAULT_PD_SEARCH_FILTER = "uid=${username}";
    private final DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
    private boolean nonSslConnectionSuccess = false;
    private boolean sslConnectionSuccess = false;
    private final LdapConfigValidator validator = new LdapConfigValidator();
    private final TrustAllCertsTrustManager manager = new TrustAllCertsTrustManager();
    private final SSLSocketFactory sslSocketFactory = this.validator.getSslSocketFactory(this.manager);
    private String hostname;
    private String prevHostname;
    private String serviceAccountDN;
    private String prevServiceAccountDN;
    private String password;
    private String prevPassword;
    private String searchBase;
    private String prevSearchBase;
    private String searchFilter;
    private String prevSearchFilter;
    private String sourceName;
    private LdapInfo.LdapType selectedDirectoryType;
    private LdapInfo.LdapType prevSelectedDirectoryType;
    private LdapDataSource dataSource = new LdapDataSource();
    private LdapsConfirmationState ldapsState;

    public AbstractDirectoryConfigState(IWizard owner) {
        super(owner);
        this.getDataSource().setId("LDAP-" + HexBin.bytesToString((byte[])IDGenerator.generateBytes((int)20)));
        this.getDataSource().setAuthenticationMethod("simple");
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.preparePluginForSave();
        this.dataSourceManager.saveDataSource((DataSource)this.getDataSource());
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedDirectoryType == null) {
            this.recordErrorMsg("You must select a directory type.");
            return;
        }
        List<ValidationError> errors = this.validator.validate(this.getDataSource(), false);
        if (!errors.isEmpty()) {
            for (ValidationError error : errors) {
                String changedMessage = this.substituteFieldNames(error.getMessage());
                error.setMessage(changedMessage);
            }
            this.recordErrors(errors, delegate);
        }
        if (StringUtils.isBlank((String)this.getSourceName())) {
            AbstractDirectoryConfigState.recordErrorMsg(this.getMessageWithFullKey("DirectorySetupState_Name_required"), delegate);
        }
        try {
            LDAPUtil.checkFilter((String)this.searchFilter);
        }
        catch (ValidationException e) {
            for (String error : e.getErrorMessages()) {
                AbstractDirectoryConfigState.recordErrorMsg(error, delegate);
            }
        }
        if (StringUtils.isEmpty((String)this.getSearchBase())) {
            AbstractDirectoryConfigState.recordErrorMsg(this.getMessageWithFullKey("DirectorySetupState_search_base_required"), delegate);
        } else {
            try {
                new LdapName(this.getSearchBase());
            }
            catch (InvalidNameException e) {
                this.log.error((Object)("Invalid Search Base due to: " + e.getMessage()));
                AbstractDirectoryConfigState.recordErrorMsg(this.getMessageWithFullKey("DirectorySetupState_Invalid_search_base"), delegate);
            }
        }
    }

    private String substituteFieldNames(String error) {
        if (error.contains("Username")) {
            error = error.replaceAll("Username", "Service Account DN");
        }
        return error;
    }

    @Override
    public boolean onStateExit() {
        boolean successTest = true;
        if (this.hasDataSourceChanged()) {
            successTest = this.testConnectionsAndSetupCertPage(this.getDataSource(), (IValidationDelegate)this.delegate);
        }
        if (successTest) {
            this.setPreviousValues();
        }
        return successTest;
    }

    private void setPreviousValues() {
        this.prevHostname = this.getHostname();
        this.prevPassword = this.getPassword();
        this.prevSearchBase = this.getSearchBase();
        this.prevSearchFilter = this.getSearchFilter();
        this.prevSelectedDirectoryType = this.getSelectedDirectoryType();
        this.prevServiceAccountDN = this.getServiceAccountDN();
    }

    private boolean hasDataSourceChanged() {
        return !this.getHostname().equals(this.prevHostname) || !this.getPassword().equals(this.prevPassword) || !this.getSearchBase().equals(this.prevSearchBase) || !this.getSearchFilter().equals(this.prevSearchFilter) || !this.getSelectedDirectoryType().equals((Object)this.prevSelectedDirectoryType) || !this.getServiceAccountDN().equals(this.prevServiceAccountDN);
    }

    public void preparePluginForSave() {
        this.getDataSource().setLdapType(this.getSelectedDirectoryType());
        this.getDataSource().setLdapTypeDesc(this.getSelectedDirectoryType().getDescription());
        this.getDataSource().setUseSSL(this.isConnectionUsingSSL());
        this.getDataSource().setVerifyHost(this.isConnectionUsingSSL());
        if (this.isActiveDirectory()) {
            this.getDataSource().setBinaryAttributes(Collections.singletonList("objectGUID"));
        }
    }

    protected boolean isConnectionUsingSSL() {
        return this.sslConnectionSuccess && !this.didUserOptOutOfSSL();
    }

    private boolean didUserOptOutOfSSL() {
        LdapsConfirmationState state;
        return this.doesLdapConfirmPageExist() && (state = (LdapsConfirmationState)this.getOutgoingTransition().getTarget()).getCertificate() == null;
    }

    protected boolean doesLdapConfirmPageExist() {
        return this.getOutgoingTransition().getTarget() instanceof LdapsConfirmationState;
    }

    private void addLdapConfirmationStep(boolean isSslCertNeeded, boolean nonSslConnectionSuccess) {
        if (!this.doesLdapConfirmPageExist()) {
            this.ldapsState = new LdapsConfirmationState((IWizard)this.getParent(), this.getDataSource());
            this.ldapsState.addOutgoingTransition(this.getOutgoingTransition());
            this.clearOutgoingTransitions();
            this.addOutgoingTransition(this.getParent(), this.ldapsState);
        } else {
            this.ldapsState = (LdapsConfirmationState)this.getOutgoingTransition().getTarget();
        }
        this.ldapsState.reset();
        this.ldapsState.setNeedToImportCertificate(isSslCertNeeded);
        this.ldapsState.setNonSSLConnectionAvailable(nonSslConnectionSuccess);
        if (isSslCertNeeded) {
            X509Certificate[] chain = this.manager.getCertChain();
            X509Certificate rootCert = chain[chain.length - 1];
            this.ldapsState.setRootIssuerDN(rootCert.getIssuerDN().toString());
        }
    }

    private boolean testConnectionsAndSetupCertPage(LdapDataSource dataSource, IValidationDelegate delegate) {
        boolean foundSuccessfulConnection = false;
        dataSource.setVerifyHost(false);
        boolean isLdapsPageNeeded = false;
        boolean isSSLCertNeeded = false;
        LDAPErrorException.InvalidCredentials invalidCredentialsException = null;
        this.sslConnectionSuccess = false;
        this.nonSslConnectionSuccess = false;
        try {
            this.testConnectionWithSSL(dataSource);
            foundSuccessfulConnection = true;
            this.sslConnectionSuccess = true;
            if (!this.isChainAlreadyTrusted(this.manager.getCertChain())) {
                isSSLCertNeeded = true;
                isLdapsPageNeeded = true;
            } else {
                this.log.debug((Object)"Skipping certificate page since we have a valid LDAPs connection.");
            }
        }
        catch (LDAPErrorException.InvalidCredentials e) {
            invalidCredentialsException = e;
        }
        catch (NamingException e) {
            this.log.debug((Object)("SSL LDAP connection test failed due to: " + e.getExplanation()));
        }
        catch (SecretManagerException e) {
            this.log.debug((Object)("SSL LDAP connection test failed due to error with secret manager: " + e.getMessage()));
        }
        try {
            this.testConnectionWithoutSSL(dataSource);
            foundSuccessfulConnection = true;
            this.nonSslConnectionSuccess = true;
            if (!this.sslConnectionSuccess) {
                isLdapsPageNeeded = true;
            }
        }
        catch (LDAPErrorException.InvalidCredentials e) {
            invalidCredentialsException = e;
        }
        catch (NamingException e) {
            this.log.debug((Object)("SSL LDAP connection test failed due to: " + e.getExplanation()));
        }
        catch (SecretManagerException e) {
            this.log.debug((Object)("SSL LDAP connection test failed due to error with secret manager: " + e.getMessage()));
        }
        if (isLdapsPageNeeded) {
            this.log.debug((Object)"Adding step for more information on the LDAP connection being used.");
            this.addLdapConfirmationStep(isSSLCertNeeded, this.nonSslConnectionSuccess);
        } else {
            this.removeLdapConfirmationPage();
        }
        if (!foundSuccessfulConnection) {
            if (invalidCredentialsException != null) {
                AbstractDirectoryConfigState.recordErrorMsg("Failed to establish a connection to the specified data store because the credentials provided are invalid.", delegate);
            } else {
                AbstractDirectoryConfigState.recordErrorMsg(this.getMessageWithFullKey("DirectorySetupState_unable_to_communicate_with_server_general"), delegate);
            }
        }
        return foundSuccessfulConnection;
    }

    private void removeLdapConfirmationPage() {
        if (this.getOutgoingTransition().getTarget() instanceof LdapsConfirmationState) {
            IWizardState removeState = this.getOutgoingTransition().getTarget();
            IWizardState newTarget = removeState.getOutgoingTransition().getTarget();
            this.clearOutgoingTransitions();
            this.addOutgoingTransition(this.getParent(), newTarget);
        }
    }

    private boolean isChainAlreadyTrusted(X509Certificate[] chain) {
        PingSslClientTrustManager trustManager = PingSslClientTrustManager.getInstance();
        try {
            trustManager.checkServerTrusted(chain, "UNKNOWN");
        }
        catch (CertificateException e) {
            this.log.debug((Object)("Certificate chain is not trusted due to: " + e.getMessage()));
            return false;
        }
        return true;
    }

    private void testConnectionWithSSL(LdapDataSource dataSource) throws NamingException, SecretManagerException {
        this.log.debug((Object)"Testing LDAP connectivity with SSL.");
        dataSource.setUseSSL(true);
        dataSource.setVerifyHost(true);
        this.validator.testConnection(dataSource, this.sslSocketFactory);
    }

    private void testConnectionWithoutSSL(LdapDataSource dataSource) throws NamingException, SecretManagerException {
        this.log.debug((Object)"Testing LDAP connectivity without SSL enabled.");
        dataSource.setUseSSL(false);
        dataSource.setVerifyHost(false);
        this.validator.testConnection(dataSource);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String server) {
        this.hostname = server;
        this.dataSource.setHost(server);
    }

    public String getServiceAccountDN() {
        return this.serviceAccountDN;
    }

    public void setServiceAccountDN(String serviceAccountDN) {
        this.serviceAccountDN = serviceAccountDN;
        this.dataSource.setPrincipal(serviceAccountDN);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.dataSource.setCredentials(password);
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getSearchFilter() {
        if (StringUtils.isBlank((String)this.searchFilter)) {
            return this.getDefaultSearchFilter(this.getSelectedDirectoryType());
        }
        return this.searchFilter;
    }

    private String getDefaultSearchFilter(LdapInfo.LdapType type) {
        if (type == null) {
            return "";
        }
        switch (type) {
            case ActiveDirectory: {
                return DEFAULT_AD_SEARCH_FILTER;
            }
            case PingDirectory: 
            case PingDS: 
            case SunDirectoryServer: 
            case OracleUnifiedDirectory: {
                return DEFAULT_PD_SEARCH_FILTER;
            }
        }
        return "";
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
        this.dataSource.setDsName(sourceName);
        this.dataSource.setDescription(sourceName);
    }

    public LdapDataSource getDataSource() {
        return this.dataSource;
    }

    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    public boolean isActiveDirectory() {
        return LdapInfo.LdapType.ActiveDirectory.equals((Object)this.getSelectedDirectoryType());
    }

    public IPropertySelectionModel getDirectoryTypeList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        model.add(LdapInfo.LdapType.ActiveDirectory.getDescription(), LdapInfo.LdapType.ActiveDirectory);
        model.add(LdapInfo.LdapType.PingDirectory.getDescription(), LdapInfo.LdapType.PingDirectory);
        model.add(LdapInfo.LdapType.PingDS.getDescription(), LdapInfo.LdapType.PingDS);
        model.add("Oracle Directory Server", LdapInfo.LdapType.SunDirectoryServer);
        model.add(LdapInfo.LdapType.OracleUnifiedDirectory.getDescription(), LdapInfo.LdapType.OracleUnifiedDirectory);
        return model;
    }

    public void setSelectedDirectoryType(LdapInfo.LdapType type) {
        if (type != null && !type.equals((Object)this.selectedDirectoryType)) {
            this.getParent().reconfigureTransitions();
        }
        this.selectedDirectoryType = type;
        this.dataSource.setLdapType(type);
    }

    public LdapInfo.LdapType getSelectedDirectoryType() {
        return this.selectedDirectoryType;
    }

    public abstract boolean isDirectoryConfigured();

    @Override
    public boolean isNextEnabled() {
        return this.getSelectedDirectoryType() != null;
    }

    public LdapsConfirmationState getLdapsState() {
        return this.ldapsState;
    }
}

