/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSetupState
extends TaskletState {
    private final Map<Field, Object> tempData = new HashMap<Field, Object>();

    public AbstractSetupState(IWizard owner) {
        super(owner);
    }

    public AbstractSetupState(IWizard owner, String cardName) {
        super(owner, cardName);
    }

    @Override
    public void reset() {
        if (!this.tempData.isEmpty()) {
            this.restoreOldState();
        }
    }

    public void saveCurrentState() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!Modifier.isPrivate(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                this.tempData.put(field, field.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreOldState() {
        for (Map.Entry<Field, Object> entry : this.tempData.entrySet()) {
            try {
                entry.getKey().setAccessible(true);
                entry.getKey().set(this, entry.getValue());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

