/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.admin.api.model.fieldpaths.ServerSettingsPaths;
import com.pingidentity.admin.api.validator.FederationInfoValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractP1EntityIDState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class BasicInfoState
extends AbstractP1EntityIDState {
    private static final String DEFAULT_RUNTIME_PORT = "9031";
    private String baseURL;
    private final LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();

    public BasicInfoState(IWizard owner) {
        super(owner);
        this.setMenuName("Basic Information");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (StringUtils.isEmpty((String)this.baseURL)) {
            this.baseURL = this.getBaseUrlFromHeader();
            String existingEntityId = this.localSettingsManager.getLocalSettings().getEntityId();
            if (!StringUtils.isBlank((String)existingEntityId)) {
                this.setEntityID(existingEntityId);
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings settings = this.localSettingsManager.getLocalSettings();
        settings.setBaseUrl(this.getBaseURL());
        settings.setEntityId(this.getEntityID());
        this.localSettingsManager.saveLocalSettings(settings);
        return super.save(dataToDisk);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        FederationInfoValidator validator = new FederationInfoValidator.Builder().setBaseFieldPath(ServerSettingsPaths.getFederationInfo()).setBaseUrl(this.getBaseURL()).setSaml2EntityId(this.getEntityID()).build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.populate(null);
    }

    private String getBaseUrlFromHeader() {
        String port;
        HttpServletRequest request = this.getRequestContext();
        String host = request.getHeader("Host");
        if (host.contains(":")) {
            host = host.substring(0, host.indexOf(":"));
        }
        if ((port = PropertyInfo.getRuntimeHttpsPort()) == null || Integer.parseInt(port) < 1) {
            port = DEFAULT_RUNTIME_PORT;
        }
        return "https://" + host + ":" + port;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }
}

