/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class CreateAdminAccountState
extends TaskletState {
    private String username;
    private String password;
    private String confirmPassword;
    private AdministrativeUser newUser;

    public CreateAdminAccountState(IWizard owner) {
        super(owner);
        this.setMenuName("Administrator Account");
        this.username = "Administrator";
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.newUser = this.getNewUser();
        AdminUserManager adminUserManager = MgmtFactory.getAdminUserManager();
        ArrayList<AdministrativeUser> users = new ArrayList<AdministrativeUser>(adminUserManager.getUsers());
        users.add(this.newUser);
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            adminUserManager.saveUsers(users);
            auditLoggerScope.log(AdminAuditLogger.Component.USER, AdminAuditLogger.Event.ACTIVATE, this.newUser.getUserName());
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.username)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("username_required"), ValidationConstraint.REQUIRED);
        }
        PasswordValidator passwordValidator = new PasswordValidator(this.password);
        if (StringUtils.isBlank((String)this.password.trim())) {
            delegate.record(this.getMessage("password_required"), ValidationConstraint.REQUIRED);
        } else if (!passwordValidator.validate()) {
            this.recordErrors(passwordValidator.getErrors(), delegate);
        } else if (!this.password.equals(this.confirmPassword)) {
            delegate.record(this.getMessage("passwords_do_not_match"), ValidationConstraint.REQUIRED);
        }
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public AdministrativeUser getNewUser() {
        if (this.newUser == null) {
            this.newUser = new AdministrativeUser();
            this.newUser.setAdmin(true);
            this.newUser.setAdminManager(true);
            this.newUser.setCryptoManager(true);
            this.newUser.setExpressionAdmin(true);
            this.newUser.setUserName(this.getUsername());
            this.newUser.setPassword(this.getPassword());
            this.newUser.setActive(true);
            this.newUser.setDescription("Initial administrator user.");
            this.newUser.setLocalAccount(true);
        }
        return this.newUser;
    }
}

