/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.DirectorySetupTasklet;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;

public class IdentityStoreConfigState
extends SingleTaskletState {
    private String directoryButtonLabel = "Active Directory";
    private String otherUserStoreLabel = "Other User Store";
    private boolean dataStoreRequired;

    public IdentityStoreConfigState(IWizard owner) {
        super(owner);
        this.setMenuName("Identity Provider Configuration");
        this.configureNote();
        DirectorySetupTasklet tasklet = this.createTasklet(DirectorySetupTasklet.class);
        this.setTasklet(tasklet);
    }

    @Override
    public void onStateActivated() {
        this.configureNote();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.getTaskletToEdit().isCompleted()) {
            return super.save(dataToDisk);
        }
        return true;
    }

    private void configureNote() {
        if (this.isAssociated()) {
            if (this.getParent().isInitialSetup()) {
                this.setNoteKey("IdentityStoreConfigState_initial_setup_note");
            } else {
                this.setNoteKey("IdentityStoreConfigState_is_associated_note");
            }
        } else {
            this.setNoteKey("IdentityStoreConfigState_not_associated_note");
        }
    }

    @Override
    public void loadTaskletToEdit() {
        Tasklet tasklet = this.getTasklet();
        if (tasklet == null || !tasklet.isCompleted()) {
            tasklet = this.createTasklet(DirectorySetupTasklet.class);
            tasklet.setMode(Mode.edit);
            this.setTasklet(tasklet);
        }
        super.loadTaskletToEdit();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet tasklet = this.getTasklet();
        if (this.dataStoreRequired && !tasklet.isCompleted()) {
            this.recordErrorMsg(this.getMessage("datastore_required"));
            return;
        }
        if (tasklet.isCompleted()) {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    public boolean isAssociated() {
        return this.getParent(AbstractPingOneSetupTasklet.class).isAssociated();
    }

    public void setDirectoryButtonLabel(String directoryButtonLabel) {
        this.directoryButtonLabel = directoryButtonLabel;
    }

    public void setOtherUserStoreLabel(String otherUserStoreLabel) {
        this.otherUserStoreLabel = otherUserStoreLabel;
    }

    public String getDirectoryButtonText() {
        return this.directoryButtonLabel;
    }

    public String getOtherUserStoreButtonText() {
        return this.otherUserStoreLabel;
    }

    public boolean isDataStoreRequired() {
        return this.dataStoreRequired;
    }

    public void setDataStoreRequired(boolean dataStoreRequired) {
        this.dataStoreRequired = dataStoreRequired;
    }

    public boolean isADConfigured() {
        return this.getTasklet() != null;
    }

    @Override
    public AbstractPingOneSetupTasklet getParent() {
        return (AbstractPingOneSetupTasklet)super.getParent();
    }
}

