/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.setup.InitialSetupTasklet;
import com.smardec.license4j.LicenseNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;

public class LicenseImportState
extends TaskletState {
    private IUploadFile license;
    private String licenseFilename = "";
    private String licenseContents;

    public LicenseImportState(IWizard owner) {
        super(owner);
        this.setMenuName("License");
        this.configureNote();
    }

    @Override
    public void onStateActivated() {
        this.setItClickable(true);
    }

    private void configureNote() {
        if (StringUtils.isBlank((String)this.licenseContents)) {
            this.setNoteKey("LicenseImportState_note_not_licensed");
        } else {
            this.setNoteKey("LicenseImportState_note_licensed");
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean isLicenseProvided;
        boolean bl = isLicenseProvided = this.license != null && !StringUtils.isBlank((String)this.licenseContents);
        if (!this.isLicensed() && !isLicenseProvided) {
            LicenseImportState.recordErrorMsg(this.getMessage("License_not_selected"), delegate);
        } else if (isLicenseProvided && !this.licenseAlreadyImported()) {
            this.getParent().importLicense(delegate);
        }
        if (delegate.getHasErrors()) {
            this.clearState();
        }
    }

    private boolean licenseAlreadyImported() {
        try {
            PingLicense license = new PingLicense(this.getLicenseContents(), false);
            if (license.getID() == null) {
                this.log.warn((Object)"The PingFederate license does not contain an ID.");
            } else if (license.getID().equals(LicenseManager.getLicense().getID())) {
                return true;
            }
        }
        catch (LicenseNotFoundException | UnsupportedEncodingException e) {
            return false;
        }
        return false;
    }

    public void parseLicense(IRequestCycle cycle) {
        ValidationDelegate delegate = this.getParent().getDelegate(cycle);
        this.licenseFilename = this.license.getFileName();
        if (this.license.getSize() == 0L) {
            LicenseImportState.recordErrorMsg(this.getMessage("License_empty"), (IValidationDelegate)delegate);
            return;
        }
        try {
            this.licenseContents = SimpleFileUtil.readIUploadFileToString((IUploadFile)this.license);
        }
        catch (IOException ioe) {
            LicenseImportState.recordErrorMsg(this.getMessage("License_import_error"), (IValidationDelegate)delegate);
            return;
        }
        ArrayList errors = new ArrayList();
        LicenseManager.testLicenseForImport((String)this.licenseContents, errors, null);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                LicenseImportState.recordErrorMsg(error, (IValidationDelegate)delegate);
            }
        }
        if (delegate.getHasErrors()) {
            this.clearState();
        } else {
            this.configureNote();
        }
    }

    void clearState() {
        this.license = null;
        this.licenseContents = null;
        this.licenseFilename = null;
    }

    public IUploadFile getLicense() {
        return this.license;
    }

    public void setLicense(IUploadFile licenseFile) {
        this.license = licenseFile;
    }

    public String getLicenseFilename() {
        return this.licenseFilename;
    }

    public boolean isLicensed() {
        return this.getParent().isLicensed();
    }

    @Override
    public InitialSetupTasklet getParent() {
        return this.getParent(InitialSetupTasklet.class);
    }

    public String getLicenseContents() {
        return this.licenseContents;
    }

    @Override
    public boolean isNextEnabled() {
        return StringUtils.isNotBlank((String)this.licenseContents) || this.isLicensed();
    }
}

