/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractConfirmationState;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.InitialSetupTasklet;
import com.pingidentity.pingone.PingOneSpConnectionBuilder;
import com.pingidentity.plugins.HtmlFormAdapterBuilder;
import com.pingidentity.plugins.KerberosAdapterBuilder;
import com.pingidentity.plugins.KerberosSelectorBuilder;
import com.pingidentity.plugins.LdapPcvBuilder;
import java.util.HashSet;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;

public class PingFedConfirmationState
extends AbstractConfirmationState {
    private static final String DEFAULT_PCV_NAME = "Password Validator";
    private static final String DEFAULT_ADAPTER_NAME = "HTML Form Adapter";
    private static final String DEFAULT_KERBEROS_ADAPTER_NAME = "Kerberos Adapter";
    private boolean failed = false;
    private AbstractPingOneSetupTasklet parentTasklet = this.getParent(AbstractPingOneSetupTasklet.class);
    private LdapPcvBuilder pcv;
    private HtmlFormAdapterBuilder htmlFormAdapter;
    private KerberosAdapterBuilder kerberosAdapter;
    private KerberosSelectorBuilder authenticationSelector;

    public PingFedConfirmationState(IWizard owner) {
        super(owner);
        this.setMenuName("Confirmation");
        this.setShowNote(false);
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        if (this.isDirectoryConfigured()) {
            HashSet<String> attributes = new HashSet<String>(PingOneSpConnectionBuilder.getP1ToPfAttributes((boolean)this.getParent().isActiveDirectory()).values());
            this.pcv = new LdapPcvBuilder(this.parentTasklet.getDirectoryDataSource().getId(), this.parentTasklet.getSearchBase(), this.parentTasklet.getSearchFilter(), attributes);
            this.pcv.setNameAndId(DEFAULT_PCV_NAME);
            this.htmlFormAdapter = new HtmlFormAdapterBuilder(((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getId(), attributes, true, false);
            this.htmlFormAdapter.setNameAndId(DEFAULT_ADAPTER_NAME);
            if (this.parentTasklet.isKerberosConfigured()) {
                this.kerberosAdapter = new KerberosAdapterBuilder(this.getKerberosRealm().getId());
                this.kerberosAdapter.setNameAndId(DEFAULT_KERBEROS_ADAPTER_NAME);
                this.authenticationSelector = new KerberosSelectorBuilder((IdpAuthnAdapterInstance)this.kerberosAdapter.getPlugin(), (IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin(), this.getParent().getKerberosIpRanges(), "Policy", "Authenticate with a directory server.");
            }
        }
    }

    private boolean isDirectoryConfigured() {
        return this.getParent().isDirectoryConfigured();
    }

    @Override
    public InitialSetupTasklet getParent() {
        return (InitialSetupTasklet)super.getParent();
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (!this.isFailed() && this.isDirectoryConfigured()) {
            this.pcv.save();
            this.htmlFormAdapter.save();
            if (this.parentTasklet.isKerberosConfigured()) {
                this.kerberosAdapter.save();
                this.authenticationSelector.save();
            }
        }
        return true;
    }

    public boolean isConfiguringDataStore() {
        return this.isDirectoryConfigured();
    }

    public String getEntityID() {
        return this.getParent().getEntityId();
    }

    public String getActiveDirectoryHostname() {
        return this.getParent().getDirectoryDataSource().getHost();
    }

    public String getActiveDirectoryID() {
        return this.getParent().getDirectoryDataSource().getId();
    }

    public String getPcvName() {
        return ((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getName();
    }

    public String getPcvID() {
        return ((PasswordCredentialValidatorInstance)this.pcv.getPlugin()).getId();
    }

    public String getHtmlFormAdapterName() {
        return ((IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin()).getName();
    }

    public String getAdapterID() {
        return ((IdpAuthnAdapterInstance)this.htmlFormAdapter.getPlugin()).getId();
    }

    public String getAdminUsername() {
        return this.getParent().getAdminUsername();
    }

    public String getBaseURL() {
        return this.getParent().getBaseURL();
    }

    private KerberosRealm getKerberosRealm() {
        return this.getParent().getKerberosRealm();
    }

    public String getKerberosAdapterName() {
        return ((IdpAuthnAdapterInstance)this.kerberosAdapter.getPlugin()).getName();
    }

    public String getCidrSelectorName() {
        return this.authenticationSelector.getCidrSelector().getName();
    }
}

