/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.PluginConfigValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractSetupState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.setup.PingIDSetupWizard;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.plugins.PingIdRadiusPCVBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PingIdRadiusState
extends AbstractSetupState {
    private String radiusClientIp;
    private String radiusClientSecret;
    private String radiusAuthnPort = "1812";
    private boolean validateUserCredentials = true;
    private String pingIdUsernameAttribute;
    private final PingOneAdminService pingOneService = MgmtFactory.getPingOneAdminService();

    public PingIdRadiusState(IWizard owner) {
        super(owner);
        this.setShowNote(false);
    }

    @Override
    public void populate(Object dataFromDisk) {
        PingIDData pingIDData = (PingIDData)((Map)dataFromDisk).get(this.getClass().getCanonicalName());
        if (pingIDData != null) {
            this.radiusClientIp = pingIDData.getRadiusClientIp();
            this.radiusClientSecret = pingIDData.getRadiusClientSecret();
            this.radiusAuthnPort = pingIDData.getRadiusAuthnPort();
            this.validateUserCredentials = pingIDData.isValidateUserCredentials();
            this.pingIdUsernameAttribute = pingIDData.getPingIdUsernameAttribute();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.radiusAuthnPort)) {
            PingIdRadiusState.recordErrorMsg(this.getMessage("required", new Object[]{"Radius Server Authentication Port"}), delegate);
        }
        try {
            PingIdRadiusPCVBuilder builder = new PingIdRadiusPCVBuilder(this.radiusClientIp, this.radiusClientSecret, this.radiusAuthnPort, this.pingOneService.downloadPingIdProperties(), this.pingIdUsernameAttribute, null, null, null, this.validateUserCredentials, null, false);
            PasswordCredentialValidatorInstance pluginConfig = (PasswordCredentialValidatorInstance)builder.getPlugin();
            PluginConfigValidator validator = new PluginConfigValidator(pluginConfig.getConfiguration(), pluginConfig.getDescriptor(), PluginInstancePaths.getConfiguration(), builder.getFieldIndices(), builder.getTableIndices());
            if (!validator.validate()) {
                this.recordErrors(validator.getErrors(), delegate);
            }
        }
        catch (IOException ex) {
            this.recordErrorMsg("Unable to obtain Ping ID properties.");
            this.log.error((Object)ex.getMessage());
            this.log.debug((Object)ex.getStackTrace());
        }
    }

    public String getRadiusClientIp() {
        return this.radiusClientIp;
    }

    public void setRadiusClientIp(String radiusClientIp) {
        this.radiusClientIp = radiusClientIp;
    }

    public String getRadiusClientSecret() {
        return this.radiusClientSecret;
    }

    public void setRadiusClientSecret(String radiusClientSecret) {
        this.radiusClientSecret = radiusClientSecret;
    }

    public String getRadiusAuthnPort() {
        return this.radiusAuthnPort;
    }

    public void setRadiusAuthnPort(String radiusAuthnPort) {
        this.radiusAuthnPort = radiusAuthnPort;
    }

    public boolean isValidateUserCredentials() {
        return this.isLDAPConfigured() && this.validateUserCredentials;
    }

    public void setValidateUserCredentials(boolean validateUserCredentials) {
        this.validateUserCredentials = validateUserCredentials;
    }

    public String getPingIdUsernameAttribute() {
        return this.pingIdUsernameAttribute;
    }

    public void setPingIdUsernameAttribute(String pingIdUsernameAttribute) {
        this.pingIdUsernameAttribute = pingIdUsernameAttribute;
    }

    @Override
    public String getMenuName() {
        return "Basic Settings";
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMenuName(), "", this, true));
        this.doSummary(summaryList);
    }

    public boolean isLDAPConfigured() {
        return this.getPingIdTasklet().isDirectoryConfigured();
    }

    public PingIDSetupWizard getPingIdTasklet() {
        return this.findParent(PingIDSetupWizard.class);
    }

    public PingIDData getCurrentData() {
        PingIDData pingIDData = new PingIDData();
        pingIDData.setRadiusClientIp(this.radiusClientIp);
        pingIDData.setRadiusClientSecret(this.radiusClientSecret);
        pingIDData.setRadiusAuthnPort(this.radiusAuthnPort);
        pingIDData.setValidateUserCredentials(this.validateUserCredentials);
        pingIDData.setPingIdUsernameAttribute(this.pingIdUsernameAttribute);
        return pingIDData;
    }

    private static class PingIDData {
        private String radiusClientIp;
        private String radiusClientSecret;
        private String radiusAuthnPort;
        private boolean validateUserCredentials;
        private String pingIdUsernameAttribute;

        private PingIDData() {
        }

        public String getRadiusClientIp() {
            return this.radiusClientIp;
        }

        public void setRadiusClientIp(String radiusClientIp) {
            this.radiusClientIp = radiusClientIp;
        }

        public String getRadiusClientSecret() {
            return this.radiusClientSecret;
        }

        public void setRadiusClientSecret(String radiusClientSecret) {
            this.radiusClientSecret = radiusClientSecret;
        }

        public String getRadiusAuthnPort() {
            return this.radiusAuthnPort;
        }

        public void setRadiusAuthnPort(String radiusAuthnPort) {
            this.radiusAuthnPort = radiusAuthnPort;
        }

        public boolean isValidateUserCredentials() {
            return this.validateUserCredentials;
        }

        public void setValidateUserCredentials(boolean validateUserCredentials) {
            this.validateUserCredentials = validateUserCredentials;
        }

        public String getPingIdUsernameAttribute() {
            return this.pingIdUsernameAttribute;
        }

        public void setPingIdUsernameAttribute(String pingIdUsernameAttribute) {
            this.pingIdUsernameAttribute = pingIdUsernameAttribute;
        }
    }
}

