/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.helper.BridgeHelper;
import com.pingidentity.fsm.state.impl.setup.AbstractNextStepsState;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractPingOneSetupTasklet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneNextStepsState
extends AbstractNextStepsState {
    private final Log log = LogFactory.getLog(this.getClass());
    private String pingOneURL;
    private final boolean initialSetup;

    public PingOneNextStepsState(IWizard owner, boolean initialSetup) {
        super(owner);
        this.initialSetup = initialSetup;
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.retrievePingOneURL();
    }

    private void retrievePingOneURL() {
        SpConnectionFactory connFactory = MgmtFactory.getPingOneAdminService().getSpConnectionFactory();
        this.pingOneURL = connFactory.getFactoryMetadata().getApplicationDockEndpoint();
    }

    public String getPingOneURL() {
        if (this.getParent() instanceof AbstractPingOneSetupTasklet && ((AbstractPingOneSetupTasklet)this.getParent()).isIdpMetadataUploaded()) {
            return this.pingOneURL;
        }
        return null;
    }

    public String getCompletionMsg() {
        StringBuilder completionMsg = new StringBuilder();
        if (this.initialSetup) {
            completionMsg.append(this.getMessage("Completion_msg_initial_setup"));
            if (this.getParent(AbstractPingOneSetupTasklet.class).isDirectoryConfigured()) {
                completionMsg.append(" ");
                completionMsg.append(this.getMessage("Completion_msg_initial_setup_p1_conn"));
            }
            completionMsg.append(".");
        } else {
            completionMsg.append(this.getMessage("Completion_msg_connect_to_pingone"));
        }
        if (!MgmtFactory.getMediator().isStandalone()) {
            completionMsg.append(" ");
            completionMsg.append(this.getMessage("Completion_msg_clustered"));
        }
        return completionMsg.toString();
    }

    public boolean isPingIDConfigured() {
        return BridgeHelper.getInstance().isPingIDConfigured();
    }

    public boolean isPingOneSSOConfigured() {
        return BridgeHelper.getInstance().isPingOneSSOConfigured();
    }
}

