/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl.setup;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.setup.AbstractP1EntityIDState;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.validation.CommonValidator;

public class SamlEntityIdState
extends AbstractP1EntityIDState {
    private boolean enableProtocol;

    public SamlEntityIdState(IWizard owner) {
        super(owner);
        this.setMenuName("SAML 2.0 Entity ID");
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        if (StringUtils.isBlank((String)this.getEntityID())) {
            this.recordErrorMsg(this.getMessage("entity_id_required"));
        } else if (!CommonValidator.isValidEntityId((String)this.getEntityID())) {
            this.recordErrorMsg(this.getMessage("invalid_entity_id"));
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings settings = settingsManager.getLocalSettings();
        if (StringUtils.isBlank((String)settings.getEntityId())) {
            settings.setEntityId(this.getEntityID());
        }
        if (this.isEnableProtocol()) {
            settingsManager.saveLocalSettings(settings);
        }
        return super.save(dataToDisk);
    }

    public boolean isEnableProtocol() {
        return this.enableProtocol;
    }

    public void setEnableProtocol(boolean enableProtocol) {
        this.enableProtocol = enableProtocol;
    }
}

