/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.impl.Wizard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuiTimingLog {
    private static final Log log = LogFactory.getLog(GuiTimingLog.class);
    private static long threshold = 20L;

    public static void log(long start, IWizardState state, Wizard wiz, String action) {
        long duration;
        if (log.isDebugEnabled() && (duration = System.currentTimeMillis() - start) >= threshold) {
            String stateName = state != null ? state.getClass().getSimpleName() : null;
            String wizName = wiz != null ? wiz.getClass().getSimpleName() : null;
            log.debug((Object)(duration + "ms for " + action + " state " + stateName + " tasklet " + wizName));
        }
    }

    static {
        String propName = "com.pingidentity.fsm.tasklet.GuiTimingLog.threshold.ms";
        String value = System.getProperty(propName, String.valueOf(threshold));
        try {
            log.debug((Object)("setting the minimum time threshold for logging the timing of various GUI actions from: " + propName + "=" + value));
            threshold = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            log.debug((Object)(e + " so using default value " + threshold));
        }
    }
}

