/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.fsm.tasklet.Tasklet;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Comparator;
import org.sourceid.saml20.domain.Affiliation;

public class AffiliationItem
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final String ACTIVE = "Active";
    private static final String INACTIVE = "Inactive";
    private Affiliation affiliation;
    private Tasklet tasklet;
    private boolean disabled;
    private int maxDisplayLength = 20;
    public static Comparator<AffiliationItem> ALPHABETICAL = new Comparator<AffiliationItem>(){

        @Override
        public int compare(AffiliationItem affiliation1, AffiliationItem affiliation2) {
            return affiliation1.getAffiliationId().compareTo(affiliation2.getAffiliationId());
        }
    };
    public static Comparator<AffiliationItem> COMPARE_BY_LAST_MODIFIED = new Comparator<AffiliationItem>(){

        @Override
        public int compare(AffiliationItem affiliation1, AffiliationItem affiliation2) {
            int retV = affiliation1.getLastModified() == null ? -1 : (affiliation2.getLastModified() == null ? 1 : affiliation1.getLastModified().compareTo(affiliation2.getLastModified()) * -1);
            return retV;
        }
    };
    public static final Comparator<AffiliationItem> COMPARE_BY_NAME_UP = new Comparator<AffiliationItem>(){

        @Override
        public int compare(AffiliationItem aff1, AffiliationItem aff2) {
            return aff1.getAffiliationId().compareToIgnoreCase(aff2.getAffiliationId()) * -1;
        }
    };
    public static final Comparator<AffiliationItem> COMPARE_BY_NAME_DOWN = new Comparator<AffiliationItem>(){

        @Override
        public int compare(AffiliationItem aff1, AffiliationItem aff2) {
            return aff1.getAffiliationId().compareToIgnoreCase(aff2.getAffiliationId());
        }
    };
    public static final Comparator<AffiliationItem> COMPARE_BY_STATUS_DOWN = new Comparator<AffiliationItem>(){

        @Override
        public int compare(AffiliationItem aff1, AffiliationItem aff2) {
            int retVal = 0;
            retVal = aff1.isActive() && aff2.isActive() ? aff1.getAffiliationId().compareTo(aff2.getAffiliationId()) : (aff1.isActive() ? -1 : 1);
            return retVal;
        }
    };
    public static final Comparator<AffiliationItem> COMPARE_BY_STATUS_UP = new Comparator<AffiliationItem>(){

        @Override
        public int compare(AffiliationItem aff1, AffiliationItem aff2) {
            int retVal = 0;
            retVal = aff1.isActive() && aff2.isActive() ? aff1.getAffiliationId().compareTo(aff2.getAffiliationId()) : (aff1.isActive() ? 1 : -1);
            return retVal;
        }
    };

    public AffiliationItem(Affiliation affiliation) {
        this.affiliation = affiliation;
    }

    public boolean getHasErrors() {
        if (this.tasklet == null) {
            return false;
        }
        return this.tasklet.getHasErrors();
    }

    public Affiliation getAffiliation() {
        return this.affiliation;
    }

    public String getAffiliationId() {
        return this.affiliation.getAffiliationId();
    }

    public void setAffiliationId(String affiliationId) {
        this.affiliation.setAffiliationId(affiliationId);
    }

    public String getDisplayAffiliationId() {
        if (this.affiliation.getAffiliationId().length() > this.maxDisplayLength) {
            return this.affiliation.getAffiliationId().substring(0, this.maxDisplayLength) + "...";
        }
        return this.affiliation.getAffiliationId();
    }

    public String getAffiliationOwnerId() {
        return this.affiliation.getAffiliationOwnerId();
    }

    public void setAffiliationOwnerId(String affiliationOwnerId) {
        this.affiliation.setAffiliationOwnerId(affiliationOwnerId);
    }

    public boolean isActive() {
        return this.affiliation.isActive();
    }

    public void setActive(boolean isActive) {
        this.affiliation.setActive(isActive);
    }

    public String getStatus() {
        return this.affiliation.isActive() ? ACTIVE : INACTIVE;
    }

    public Tasklet getTasklet() {
        return this.tasklet;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDisabled() {
        return "disabled";
    }

    public Calendar getLastModified() {
        return this.affiliation.getLastModified();
    }

    public void setLastModified(Calendar lastModified) {
        this.affiliation.setLastModified(lastModified);
    }
}

