/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.domain.LookupableLabel;
import org.sourceid.websso.Protocol;

public enum ConnectionImageType implements LookupableLabel
{
    ALL("All Protocols", null),
    WSFED("WS-Federation", Protocol.WSFED.toString()),
    SAML20("SAML 2.0", Protocol.SAML20.toString()),
    SAML11("SAML 1.1", Protocol.SAML11.toString()),
    SAML10("SAML 1.0", Protocol.SAML10.toString()),
    WSTRUST("WS-Trust", "WS-Trust"),
    INBOUNDPROVISIONING("Inbound Provisioning", "InboundProvisioning"),
    OUTBOUNDPROVISIONING("Outbound Provisioning", "OutboundProvisioning"),
    OIDC("OpenID Connect", Protocol.OIDC.toString()),
    OAUTHASSERTIONGRANT("OAuth Assertion Grant", "OAuthAssertionGrant");

    private final String id;
    private final String label;

    private ConnectionImageType(String label, String id) {
        this.id = id;
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public static ConnectionImageType getConnectionImageType(Protocol protocol) {
        ConnectionImageType connectionImageType = null;
        if (protocol != null) {
            switch (protocol) {
                case SAML10: {
                    connectionImageType = SAML10;
                    break;
                }
                case SAML11: {
                    connectionImageType = SAML11;
                    break;
                }
                case SAML20: {
                    connectionImageType = SAML20;
                    break;
                }
                case WSFED: {
                    connectionImageType = WSFED;
                    break;
                }
                case OIDC: {
                    connectionImageType = OIDC;
                }
            }
        }
        return connectionImageType;
    }

    public static List<ConnectionImageType> getConnectionImageTypes(boolean browserSsoProfileEnabled, boolean wsTrustStsEnabled, boolean inboundProvisioningEnabled, boolean outboundProvisioningEnabled, boolean oauthAssertionGrantEnabled, Protocol protocol) {
        ConnectionImageType browserSsoProfilesConnectionImageType;
        LinkedList<ConnectionImageType> connectionImageTypes = new LinkedList<ConnectionImageType>();
        if (browserSsoProfileEnabled && (browserSsoProfilesConnectionImageType = ConnectionImageType.getConnectionImageType(protocol)) != null) {
            connectionImageTypes.add(browserSsoProfilesConnectionImageType);
        }
        if (wsTrustStsEnabled) {
            connectionImageTypes.add(WSTRUST);
        }
        if (inboundProvisioningEnabled) {
            connectionImageTypes.add(INBOUNDPROVISIONING);
        }
        if (outboundProvisioningEnabled) {
            connectionImageTypes.add(OUTBOUNDPROVISIONING);
        }
        if (oauthAssertionGrantEnabled) {
            connectionImageTypes.add(OAUTHASSERTIONGRANT);
        }
        return connectionImageTypes;
    }
}

