/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.google.common.collect.ComparisonChain;
import com.pingidentity.draft.ConnectionDraft;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.util.DateUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.ItemReplicationStatus;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.Protocol;

public class ConnectionItem
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private static final int MAX_DISPLAY_LENGTH = 40;
    public static final String IDP = "IdP";
    public static final String SP = "SP";
    public static final String COMPACT_DATE_PATTERN = "MM/dd/yyyy";
    private String entityId;
    private String connectionName;
    private VirtualIdentity defaultVirtualIdentity = new VirtualIdentity();
    private boolean active;
    private Date modificationTime;
    private Date creationTime;
    private Date selectiveReplicationTime;
    private String role;
    private boolean itDeleted;
    private Tasklet tasklet;
    private final boolean samlProtocol;
    private final Protocol protocol;
    private boolean draftConnection;
    private boolean disabled;
    private final String systemId;
    private boolean hasErrorsForListDisplay;
    private String licenseAssignment;
    private final List<ConnectionImageType> connectionImageTypes;
    private boolean browserSsoProfileConfigured = false;
    private boolean inUse;
    private boolean refreshed;
    public static final Comparator<ConnectionItem> COMPARE_BY_MODIFICATION_TIME_UP = (conn1, conn2) -> ObjectUtils.compare((Comparable)DateUtil.convertDate((Date)conn1.modificationTime), (Comparable)DateUtil.convertDate((Date)conn2.modificationTime));
    public static final Comparator<ConnectionItem> COMPARE_BY_MODIFICATION_TIME_DOWN = (conn1, conn2) -> ObjectUtils.compare((Comparable)DateUtil.convertDate((Date)conn2.modificationTime), (Comparable)DateUtil.convertDate((Date)conn1.modificationTime));
    public static final Comparator<ConnectionItem> COMPARE_BY_CREATION_TIME_UP = (conn1, conn2) -> ComparisonChain.start().compare((Object)DateUtil.convertDate((Date)conn1.creationTime), (Object)DateUtil.convertDate((Date)conn2.creationTime), ObjectUtils::compare).compare((Object)conn1.getConnectionName(), (Object)conn2.getConnectionName(), String::compareToIgnoreCase).result();
    public static final Comparator<ConnectionItem> COMPARE_BY_CREATION_TIME_DOWN = (conn1, conn2) -> ComparisonChain.start().compare((Object)DateUtil.convertDate((Date)conn2.creationTime), (Object)DateUtil.convertDate((Date)conn1.creationTime), ObjectUtils::compare).compare((Object)conn1.getConnectionName(), (Object)conn2.getConnectionName(), String::compareToIgnoreCase).result();
    public static final Comparator<ConnectionItem> COMPARE_BY_NAME_UP = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            return conn1.getConnectionName().compareTo(conn2.getConnectionName()) * -1;
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_NAME_DOWN = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            return conn1.getConnectionName().compareTo(conn2.getConnectionName());
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_ID_UP = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            return conn1.getEntityId().compareTo(conn2.getEntityId()) * -1;
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_ID_DOWN = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            return conn1.getEntityId().compareTo(conn2.getEntityId());
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_VIRT_ID_UP = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            return ConnectionItem.compareTo(conn1, conn2) * -1;
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_VIRT_ID_DOWN = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            return ConnectionItem.compareTo(conn1, conn2);
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_PROTO_DOWN = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            String conn2ImageType;
            String conn1ImageType = conn1.getConnectionImageTypes().get(0).getLabel();
            int retVal = conn1ImageType.compareToIgnoreCase(conn2ImageType = conn2.getConnectionImageTypes().get(0).getLabel());
            if (retVal == 0) {
                retVal = conn1.getEntityId().compareToIgnoreCase(conn2.getEntityId());
            }
            return retVal;
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_PROTO_UP = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            String conn2ImageType;
            String conn1ImageType = conn1.getConnectionImageTypes().get(0).getLabel();
            int retVal = conn1ImageType.compareToIgnoreCase(conn2ImageType = conn2.getConnectionImageTypes().get(0).getLabel()) * -1;
            if (retVal == 0) {
                retVal = conn1.getEntityId().compareTo(conn2.getEntityId());
            }
            return retVal;
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_STATUS_DOWN = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            int retVal = 0;
            retVal = conn1.isActive() && conn2.isActive() ? conn1.getEntityId().compareTo(conn2.getEntityId()) : (conn1.isActive() ? -1 : 1);
            return retVal;
        }
    };
    public static final Comparator<ConnectionItem> COMPARE_BY_STATUS_UP = new Comparator<ConnectionItem>(){

        @Override
        public int compare(ConnectionItem conn1, ConnectionItem conn2) {
            int retVal = 0;
            retVal = conn1.isActive() && conn2.isActive() ? conn1.getEntityId().compareTo(conn2.getEntityId()) : (conn1.isActive() ? 1 : -1);
            return retVal;
        }
    };

    public ConnectionItem(LocalSettings localSettings, ConnectionBase connection) {
        this.entityId = connection.getEntityId();
        this.systemId = connection.getId();
        this.connectionName = connection.getName();
        this.defaultVirtualIdentity = connection.getDefaultVirtualIdentity();
        this.active = connection.isActive();
        this.modificationTime = connection.getLastModified().getTime();
        this.creationTime = connection.getCreationTime().getTime();
        this.selectiveReplicationTime = DateUtil.calendarToDate((Calendar)connection.getSelectiveReplicationTime());
        this.role = connection instanceof IdpConnection ? IDP : SP;
        this.protocol = connection.getProtocol();
        this.samlProtocol = Protocol.SAML20.equals((Object)this.protocol) || Protocol.SAML11.equals((Object)this.protocol) || Protocol.SAML10.equals((Object)this.protocol);
        String groupAssigned = connection.getLicenseConnectionGroupAssignment();
        if (groupAssigned != null && LicenseManager.getLicense().getLicenseConnectionGroup(groupAssigned) != null) {
            this.licenseAssignment = connection.getLicenseConnectionGroupAssignment();
        }
        boolean oauthAssertionGrantEnabled = false;
        if (connection instanceof IdpConnection) {
            oauthAssertionGrantEnabled = ((IdpConnection)connection).doesOAuthSettingsExist();
        }
        this.connectionImageTypes = ConnectionImageType.getConnectionImageTypes(connection.isBrowserSsoProfileConfigured() && (this.role.equals(SP) ? localSettings.isEnableProtocolIdP(this.protocol) : localSettings.isEnableProtocolSp(this.protocol)), connection.doesWsTrustSettingsExist() && (this.role.equals(SP) ? localSettings.isEnableWsTrustIdP() : localSettings.isEnableWsTrustSp()), connection.doesInboundProvisioningExist() && localSettings.isEnableInboundProvisioning(), connection.hasModuleConfiguration("SaasProvisioner"), oauthAssertionGrantEnabled && MgmtFactory.getAuthzServerManager().isEnableOAuth(), this.protocol);
        this.browserSsoProfileConfigured = connection.isBrowserSsoProfileConfigured();
    }

    public ConnectionItem(ConnectionDraft draft) {
        this.entityId = draft.getId();
        this.systemId = draft.getDraftId();
        this.connectionName = draft.getConnectionName();
        this.active = false;
        this.modificationTime = draft.getLastModifiedDate().getTime();
        this.role = draft.getConnType().getName();
        this.protocol = draft.getProtocol();
        this.samlProtocol = Protocol.SAML20.equals((Object)this.protocol) || Protocol.SAML11.equals((Object)this.protocol) || Protocol.SAML10.equals((Object)this.protocol);
        this.draftConnection = true;
        this.connectionImageTypes = draft.getConnectionImageTypes();
        this.defaultVirtualIdentity = draft.getDefaultVirtualIdentity();
    }

    public boolean isDraftConnection() {
        return this.draftConnection;
    }

    public String getStatus() {
        if (this.active) {
            return "Active";
        }
        if (this.draftConnection) {
            return "Draft";
        }
        return "Inactive";
    }

    public String getClassType() {
        return this.itDeleted ? "disabled" : "plain";
    }

    public boolean getHasErrors() {
        if (this.getHasErrorsForListDisplay()) {
            return true;
        }
        if (this.tasklet == null) {
            return false;
        }
        return this.tasklet.getHasErrors();
    }

    public void setHasErrors(boolean newValue) {
        if (this.tasklet != null) {
            this.tasklet.setHasErrors(newValue);
        }
    }

    public boolean displayDeleteLink() {
        return !this.isItDeleted();
    }

    public boolean displayCopyExportLinks() {
        return !this.isItDeleted() && this.isRefreshed();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean showRefreshButton() {
        return !this.refreshed && !this.isItDeleted() && !this.getHasErrors() && !this.isDraftConnection();
    }

    public boolean showRefreshSuccessful() {
        return this.refreshed && !this.isItDeleted() && !this.getHasErrors() || this.isDraftConnection();
    }

    public boolean showExportMetadataLinks() {
        return this.isSamlProtocol() && this.isBrowserSsoProfileConfigured();
    }

    public boolean showImportMetadataLinks() {
        return this.isSamlProtocol() && this.isBrowserSsoProfileConfigured();
    }

    public boolean showPipeSeparator() {
        return this.isInUse() || this.isActive() || this.displayDeleteLink();
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public void setRefreshed(boolean refreshed) {
        this.refreshed = refreshed;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getDisplayName() {
        return StringUtils.abbreviate((String)this.connectionName, (int)40);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Date getModificationTime() {
        return DateUtil.convertDate((Date)this.modificationTime);
    }

    public void setModificationTime(Date modificationTime) {
        this.modificationTime = modificationTime == null ? null : new Date(modificationTime.getTime());
    }

    public Date getCreationTime() {
        return DateUtil.convertDate((Date)this.creationTime);
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime == null ? null : new Date(creationTime.getTime());
    }

    public String getCompactCreationTime() {
        return DateUtil.formatDate((Date)DateUtil.convertDate((Date)this.creationTime), (String)COMPACT_DATE_PATTERN);
    }

    public String getCompactModificationTime() {
        return DateUtil.formatDate((Date)DateUtil.convertDate((Date)this.modificationTime), (String)COMPACT_DATE_PATTERN);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isItDeleted() {
        return this.itDeleted;
    }

    public void setItDeleted(boolean itDeleted) {
        this.itDeleted = itDeleted;
    }

    public Tasklet getTasklet() {
        return this.tasklet;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    public boolean isSamlProtocol() {
        return this.samlProtocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    private static int compareTo(ConnectionItem conn1, ConnectionItem conn2) {
        String virtualEntityId2;
        String virtualEntityId1 = StringUtils.defaultString((String)conn1.getDefaultVirtualIdentity().getVirtualEntityId(DomainMode.CONFIGTIME));
        int result = virtualEntityId1.compareTo(virtualEntityId2 = StringUtils.defaultString((String)conn2.getDefaultVirtualIdentity().getVirtualEntityId(DomainMode.CONFIGTIME)));
        if (result == 0) {
            return conn1.getEntityId().compareTo(conn2.getEntityId());
        }
        return result;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDisabled() {
        return "disabled";
    }

    public String getDefaultVirtualEntityId() {
        return this.getDefaultVirtualIdentity().getVirtualEntityId(DomainMode.CONFIGTIME);
    }

    public VirtualIdentity getDefaultVirtualIdentity() {
        return this.defaultVirtualIdentity;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public boolean getHasErrorsForListDisplay() {
        return this.hasErrorsForListDisplay;
    }

    public void setHasErrorsForListDisplay(boolean hasErrorsForListDisplay) {
        this.hasErrorsForListDisplay = hasErrorsForListDisplay;
    }

    public String getLicenseAssignment() {
        return this.licenseAssignment;
    }

    public void setLicenseAssignment(String licenseAssignment) {
        this.licenseAssignment = licenseAssignment;
    }

    public boolean isLicenseGroupExpired() {
        boolean expired = false;
        if (this.licenseAssignment != null) {
            expired = LicenseManager.isConnectionGroupExpired((String)this.licenseAssignment);
        }
        return expired;
    }

    public boolean isLicenseGroupNotInEffect() {
        boolean notInEffect = false;
        if (this.licenseAssignment != null) {
            notInEffect = !LicenseManager.isConnectionGroupInEffect((String)this.licenseAssignment);
        }
        return notInEffect;
    }

    public boolean isLicenseGroupOK() {
        return !this.isLicenseGroupExpired() && !this.isLicenseGroupNotInEffect();
    }

    public List<ConnectionImageType> getConnectionImageTypes() {
        return this.connectionImageTypes;
    }

    public boolean isSAMLConnectionType() {
        if (this.connectionImageTypes.isEmpty()) {
            return false;
        }
        return this.connectionImageTypes.get(0).equals((Object)ConnectionImageType.SAML10) || this.connectionImageTypes.get(0).equals((Object)ConnectionImageType.SAML11) || this.connectionImageTypes.get(0).equals((Object)ConnectionImageType.SAML20);
    }

    public boolean isBrowserSsoProfileConfigured() {
        return this.browserSsoProfileConfigured;
    }

    public String getReplicationStatus() {
        Date fullReplicationTime = MgmtFactory.getMediator().getConfigPublishDate();
        boolean replicated = fullReplicationTime != null && fullReplicationTime.after(this.modificationTime) || this.selectiveReplicationTime != null && this.selectiveReplicationTime.after(this.modificationTime);
        return replicated ? ItemReplicationStatus.REPLICATED.getId() : ItemReplicationStatus.NOT_REPLICATED.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionItem that = (ConnectionItem)o;
        if (this.samlProtocol != that.samlProtocol) {
            return false;
        }
        if (this.draftConnection != that.draftConnection) {
            return false;
        }
        if (this.disabled != that.disabled) {
            return false;
        }
        if (this.hasErrorsForListDisplay != that.hasErrorsForListDisplay) {
            return false;
        }
        if (this.browserSsoProfileConfigured != that.browserSsoProfileConfigured) {
            return false;
        }
        if (this.inUse != that.inUse) {
            return false;
        }
        if (!this.entityId.equals(that.entityId)) {
            return false;
        }
        if (!this.connectionName.equals(that.connectionName)) {
            return false;
        }
        if (this.defaultVirtualIdentity != null ? !this.defaultVirtualIdentity.equals((Object)that.defaultVirtualIdentity) : that.defaultVirtualIdentity != null) {
            return false;
        }
        if (this.role != null ? !this.role.equals(that.role) : that.role != null) {
            return false;
        }
        if (this.protocol != that.protocol) {
            return false;
        }
        if (this.systemId != null ? !this.systemId.equals(that.systemId) : that.systemId != null) {
            return false;
        }
        if (this.licenseAssignment != null ? !this.licenseAssignment.equals(that.licenseAssignment) : that.licenseAssignment != null) {
            return false;
        }
        return Objects.equals(this.connectionImageTypes, that.connectionImageTypes);
    }

    public int hashCode() {
        int result = this.entityId.hashCode();
        result = 31 * result + this.connectionName.hashCode();
        result = 31 * result + (this.defaultVirtualIdentity != null ? this.defaultVirtualIdentity.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        result = 31 * result + (this.samlProtocol ? 1 : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.draftConnection ? 1 : 0);
        result = 31 * result + (this.disabled ? 1 : 0);
        result = 31 * result + (this.systemId != null ? this.systemId.hashCode() : 0);
        result = 31 * result + (this.hasErrorsForListDisplay ? 1 : 0);
        result = 31 * result + (this.licenseAssignment != null ? this.licenseAssignment.hashCode() : 0);
        result = 31 * result + (this.connectionImageTypes != null ? this.connectionImageTypes.hashCode() : 0);
        result = 31 * result + (this.browserSsoProfileConfigured ? 1 : 0);
        result = 31 * result + (this.inUse ? 1 : 0);
        return result;
    }
}

