/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.fsm.tasklet.data.CertificateTypes;

public class KeyAlgorithmFilter {
    private final CertificateTypes.KeyAlgorithms keyAlg;
    private final int minPublicKeySize;
    private final String signatureName;
    private final int keySize;
    private final boolean removeRotatingCerts;

    private KeyAlgorithmFilter(KeyAlgorithmFilterBuilder builder) {
        this.keyAlg = builder.keyAlg;
        this.minPublicKeySize = builder.minPublicKeySize;
        this.signatureName = builder.signatureName;
        this.keySize = builder.keySize;
        this.removeRotatingCerts = builder.removeRotatingCerts;
    }

    public CertificateTypes.KeyAlgorithms getKeyAlg() {
        return this.keyAlg;
    }

    public int getMinPublicKeySize() {
        return this.minPublicKeySize;
    }

    public String getSignatureName() {
        return this.signatureName;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public boolean isRemoveRotatingCerts() {
        return this.removeRotatingCerts;
    }

    public static class KeyAlgorithmFilterBuilder {
        private final CertificateTypes.KeyAlgorithms keyAlg;
        private int minPublicKeySize = -1;
        private String signatureName;
        private int keySize = -1;
        private boolean removeRotatingCerts = false;

        public KeyAlgorithmFilterBuilder(CertificateTypes.KeyAlgorithms keyAlg) {
            this.keyAlg = keyAlg;
        }

        public KeyAlgorithmFilterBuilder setMinPublicKeySize(int minPublicKeySize) {
            this.keySize = -1;
            this.minPublicKeySize = minPublicKeySize;
            return this;
        }

        public KeyAlgorithmFilterBuilder setSignatureName(String signatureName) {
            this.signatureName = signatureName;
            return this;
        }

        public KeyAlgorithmFilterBuilder setKeySize(int keySize) {
            this.minPublicKeySize = -1;
            this.keySize = keySize;
            return this;
        }

        public KeyAlgorithmFilterBuilder setRemoveRotatingCerts(boolean removeRotatingCerts) {
            this.removeRotatingCerts = removeRotatingCerts;
            return this;
        }

        public KeyAlgorithmFilter build() {
            return new KeyAlgorithmFilter(this);
        }
    }
}

