/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.fsm.tasklet.data.FieldItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;

public class RowItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<FieldItem> rowFields = new ArrayList<FieldItem>();
    private List<String> backupValues;
    private boolean isNewRow;
    private boolean isDeleted = false;
    private boolean isDefault = false;

    public RowItem clone() {
        RowItem clone = new RowItem();
        clone.isNewRow = this.isNewRow;
        clone.isDeleted = this.isDeleted;
        clone.rowFields = new ArrayList<FieldItem>(this.rowFields.size());
        for (FieldItem fieldItem : this.rowFields) {
            clone.rowFields.add(fieldItem.clone());
        }
        if (this.backupValues != null) {
            clone.backupValues = new ArrayList<String>(this.backupValues.size());
            for (String backup : this.backupValues) {
                clone.backupValues.add(backup);
            }
        }
        return clone;
    }

    public List<FieldItem> getRowFields() {
        return this.rowFields;
    }

    public boolean isNewRow() {
        return this.isNewRow;
    }

    public void setNewRow(boolean newRow) {
        this.isNewRow = newRow;
    }

    public void backup() {
        this.backupValues = new ArrayList<String>(this.rowFields.size());
        for (FieldItem fieldItem : this.rowFields) {
            this.backupValues.add(fieldItem.getValue());
        }
    }

    public void revert() {
        if (this.backupValues != null) {
            for (int i = 0; i < this.backupValues.size(); ++i) {
                String oldValue = this.backupValues.get(i);
                FieldItem fieldItem = this.rowFields.get(i);
                fieldItem.setValue(oldValue);
            }
        }
        this.backupValues = null;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public void reconcile(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<FieldItem> newRowFields = new ArrayList<FieldItem>();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            String name = fieldDescriptor.getName();
            FieldItem fieldItem = this.findFieldByName(name);
            if (fieldItem == null) {
                fieldItem = new FieldItem(fieldDescriptor);
                if (fieldDescriptor.getDefaultValue() != null) {
                    fieldItem.setValue(fieldDescriptor.getDefaultValue());
                }
            }
            newRowFields.add(fieldItem);
        }
        this.rowFields = newRowFields;
    }

    FieldItem findFieldByName(String name) {
        for (FieldItem item : this.rowFields) {
            if (!name.equals(item.getFieldDescriptor().getName())) continue;
            return item;
        }
        return null;
    }
}

