/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import java.io.Serializable;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.saml20.service.TargetSessionId;

public class TargetUrlMappingItem
implements Serializable {
    private static final ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
    private static final long serialVersionUID = 20050515L;
    private String url;
    private String selectedTargetId;
    private TargetSessionId.TargetSessionType selectedType;
    private boolean mappingToEdit;
    private boolean disabled;
    private String targetName;

    public TargetUrlMappingItem(String url, String targetName, TargetSessionId.TargetSessionType targetType, String targetId) {
        this.url = url;
        this.targetName = targetName;
        this.selectedType = targetType;
        this.selectedTargetId = targetId;
    }

    public TargetSessionId.TargetSessionType getSelectedType() {
        return this.selectedType;
    }

    public void setSelectedType(TargetSessionId.TargetSessionType selectedType) {
        this.selectedType = selectedType;
    }

    public String getSelectedTypeName() {
        if (this.selectedType != null) {
            return this.selectedType.name();
        }
        return null;
    }

    public String getSelectedTarget() {
        return this.selectedTargetId;
    }

    public void setSelectedTarget(String targetId) {
        this.selectedTargetId = targetId;
    }

    public String getSelectedTargetName() {
        if (this.targetName != null && this.selectedType != null) {
            String type = "";
            switch (this.selectedType) {
                case ADAPTER: {
                    type = "SP Adapter";
                    break;
                }
                case SP_CONN: {
                    ConnectionDbEntry entry = connectionDb.getEntry(this.selectedTargetId);
                    type = entry.isActive() ? "SP Connection" : "SP Connection -- Inactive";
                    break;
                }
                case AUTHN_POLICY: {
                    type = "Authn Policy";
                    break;
                }
                default: {
                    type = "Unknown";
                }
            }
            return this.targetName + " (" + type + ")";
        }
        return null;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean getMappingToEdit() {
        return this.mappingToEdit;
    }

    public void setMappingToEdit(boolean mappingToEdit) {
        this.mappingToEdit = mappingToEdit;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

