/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AuthenticationApplicationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.AuthnApiManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationApplicationTasklet
extends Tasklet {
    private Operation operation = Operation.NONE;
    private static final long serialVersionUID = 6L;
    private AuthenticationApplicationState authenticationApplicationState;

    public AuthnApiApplication getApplication() {
        AuthnApiApplication application = MgmtFactory.getAuthnApiManager().newApiApplication();
        this.authenticationApplicationState.save(application);
        return application;
    }

    public AuthenticationApplicationTasklet(Visit visit) {
        super("AuthenticationApplicationTasklet", "Authentication Application");
        this.setSystemVisit(visit);
        this.authenticationApplicationState = new AuthenticationApplicationState(this);
        this.setInitialState(this.authenticationApplicationState);
        this.setCancelAvailable(true);
    }

    @Override
    public void setCurrentState(IWizardState currentState) {
        Visit v = this.getSystemVisit();
        v.setSkipForUIPerformanceFlag(true);
        super.setCurrentState(currentState);
        v.setSkipForUIPerformanceFlag(false);
    }

    public String getApplicationId() {
        return this.authenticationApplicationState.getId();
    }

    public String getApplicationName() {
        return this.authenticationApplicationState.getName();
    }

    @Override
    public void finish() {
        AuthnApiManager authnApiMgr = MgmtFactory.getAuthnApiManager();
        AuthnApiApplication application = authnApiMgr.newApiApplication();
        if (this.save(application)) {
            try {
                if (this.getOperation() == Operation.UPDATE) {
                    authnApiMgr.saveApiApplication(application, true);
                } else {
                    authnApiMgr.saveApiApplication(application, false);
                    this.setOperation(Operation.UPDATE);
                }
                this.setPopulateData(application);
            }
            catch (Exception e) {
                this.authenticationApplicationState.getDelegate().record("An error occurred saving authentication application '" + application.getName() + "'", ValidationConstraint.REQUIRED);
            }
        }
        super.finish();
    }

    @Override
    public String getFinishLabel() {
        return "Save";
    }

    public AuthenticationApplicationState getAuthenticationApplicationState() {
        return this.authenticationApplicationState;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
        this.setInitialState(this.authenticationApplicationState);
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        NONE;

    }
}

