/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.crypto.JCEManager;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.cert.CertificateExpiryDisplay;
import com.pingidentity.fsm.state.impl.CertManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CertManagementTasklet
extends Tasklet
implements CertificateTypes,
CertificateExpiryDisplay {
    private static final long serialVersionUID = 20050515L;
    private CertificateTypes.ValidTypes certType = CertificateTypes.ValidTypes.trustedCAs;
    private boolean globalEditing = false;
    boolean activatable = true;
    private CertManagementState certManagementState;
    private CertificateType expiryNotificationCertType;
    private final transient JCEManager jceManager;

    public CertManagementTasklet(Visit visit) {
        this(visit, MgmtFactory.getJCEManager());
    }

    public CertManagementTasklet(Visit visit, JCEManager jceManager) {
        super("CertManagementTasklet", "Certificate Management");
        this.setSystemVisit(visit);
        this.jceManager = jceManager;
        this.certManagementState = new CertManagementState(this, "certManagement");
        this.certManagementState.setCertType(this.certType);
        this.setInitialState(this.certManagementState);
        this.setCancelAvailable(true);
    }

    public void saveCerts() {
        this.certManagementState.save();
    }

    @Override
    public void finish() {
        this.save(null);
        super.finish();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.certManagementState.save();
        return true;
    }

    @Override
    public String getFinishLabel() {
        return "Done";
    }

    @Override
    public boolean showSaveAll() {
        return false;
    }

    @Override
    public boolean isCancelAvailable() {
        return !this.isSkipPopToParent() && this.getCurrentUser().isAuditor();
    }

    @Override
    public boolean isFinishAvailable() {
        if (this.isSkipPopToParent()) {
            return false;
        }
        return !this.getCurrentUser().isAuditor();
    }

    public CertificateTypes.ValidTypes getCertType() {
        return this.certType;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.certType = certType;
        this.certManagementState.setCertType(certType);
    }

    public boolean isCreateAndCertifyVisible() {
        boolean isCreateAndCertifyVisible;
        switch (this.certType) {
            case dsigSigningCert: 
            case xmlDecryptionCert: 
            case sslCertAuth: 
            case sslServerCerts: {
                isCreateAndCertifyVisible = true;
                break;
            }
            default: {
                isCreateAndCertifyVisible = false;
            }
        }
        return isCreateAndCertifyVisible;
    }

    public boolean isImportCertVisible() {
        boolean isImportCertVisible;
        switch (this.certType) {
            case dsigSigningCert: 
            case xmlDecryptionCert: 
            case sslCertAuth: 
            case sslServerCerts: {
                isImportCertVisible = this.jceManager.allowPrivateKeyImport();
                break;
            }
            default: {
                isImportCertVisible = true;
            }
        }
        return isImportCertVisible;
    }

    public boolean isLinkCertVisible() {
        boolean isLinkVisible;
        switch (this.certType) {
            case dsigSigningCert: 
            case xmlDecryptionCert: 
            case sslCertAuth: 
            case sslServerCerts: {
                isLinkVisible = this.jceManager.allowLinkAndStoreKeys();
                break;
            }
            default: {
                isLinkVisible = false;
            }
        }
        return isLinkVisible;
    }

    @Override
    public String getHelpName() {
        String helpName = super.getTaskletName() + "_";
        switch (this.certType) {
            case dsigVerificationCert: 
            case ocspDsigVerificationCert: 
            case wsTrustDsigVerificationCert: {
                helpName = helpName + "DsigVerificationCert";
                break;
            }
            case sslCertAuth: {
                helpName = helpName + "SslCertAuth";
                break;
            }
            case dsigSigningCert: 
            case xmlDecryptionCert: {
                helpName = helpName + "DsigSigningCert";
                break;
            }
            case sslCertVerification: {
                helpName = helpName + "SslCertVerification";
                break;
            }
            case trustedCAs: {
                helpName = helpName + "TrustedCAs";
                break;
            }
            case sslServerCerts: {
                helpName = helpName + "SslServerCerts";
                break;
            }
            case xmlEncryptionCert: {
                helpName = helpName + "XmlEncryptionCert";
            }
        }
        return helpName;
    }

    public Cert getSelectedCert() {
        return this.certManagementState.getSelectedCert();
    }

    public void setSelectedCert(Cert selectedCert) {
        this.certManagementState.setSelectedCert(selectedCert);
    }

    public Cert getSecondarySelectedCert() {
        return this.certManagementState.getSecondarySelectedCert();
    }

    public void setSecondarySelectedCert(Cert secondarySelectedCert) {
        this.certManagementState.setSecondarySelectedCert(secondarySelectedCert);
    }

    public LinkedHashSet<Cert> getActiveCerts() {
        return this.certManagementState.getActiveCerts();
    }

    public void setActiveCerts(LinkedHashSet<Cert> activeCerts) {
        this.certManagementState.setActiveCerts(activeCerts);
    }

    public Set<Cert> getInactiveCerts() {
        return this.certManagementState.getInactiveCerts();
    }

    public void setInactiveCerts(Set<Cert> inactiveCerts) {
        this.certManagementState.setInactiveCerts(inactiveCerts);
    }

    public boolean isGlobalEditing() {
        return this.globalEditing;
    }

    public void setGlobalEditing(boolean globalEditing) {
        this.globalEditing = globalEditing;
    }

    public boolean isActivatable() {
        if (this.globalEditing) {
            if (this.certType != CertificateTypes.ValidTypes.sslServerCerts) {
                this.activatable = false;
            }
        } else if (this.certType == CertificateTypes.ValidTypes.trustedCAs) {
            this.activatable = false;
        }
        return this.activatable;
    }

    public void setActivatable(boolean activatable) {
        this.activatable = activatable;
    }

    public CertManagementState getCertManagementState() {
        return this.certManagementState;
    }

    public ConnectionCerts getDsigVerificationCerts() {
        return this.certManagementState.getDsigVerificationCerts();
    }

    public void setDsigVerificationCerts(ConnectionCerts dsigVerificationCerts) {
        this.certManagementState.setDsigVerificationCerts(dsigVerificationCerts);
    }

    public Set<Cert> getSslVerificationCerts() {
        return this.certManagementState.getSslVerificationCerts();
    }

    public void setSslVerificationCerts(Set<Cert> sslVerificationCerts) {
        this.certManagementState.setSslVerificationCerts(sslVerificationCerts);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void setUseDefaultSelectedCertFunctionality(boolean useDefaultSelectedCertFunctionality) {
        this.certManagementState.setUseDefaultSelectedCertFunctionality(useDefaultSelectedCertFunctionality);
    }

    public boolean doesCertAlreadyExist(Cert c) {
        return this.certManagementState.doesCertAlreadyExist(c);
    }

    @Override
    public boolean isSaveAllAvailable() {
        if (this.hasCertificateRevocationChecking()) {
            return false;
        }
        return !this.hasConnectionWizard();
    }

    public boolean isSigningOrDecryptionCert() {
        return this.certType.equals((Object)CertificateTypes.ValidTypes.dsigSigningCert) || this.certType.equals((Object)CertificateTypes.ValidTypes.xmlDecryptionCert);
    }

    public boolean isHybridMode() {
        return PropertyInfo.isHSMHybrid();
    }

    @Override
    public Cert getCertForExpiryNotification() {
        return this.getSelectedCert();
    }

    @Override
    public void setCertIdForExpiryNotification(String certId) {
    }

    @Override
    public CertificateType getCertTypeForExpiryNotification() {
        return this.expiryNotificationCertType;
    }

    @Override
    public void setCertTypeForExpiryNotification(CertificateType expiryNotificationCertType) {
        this.expiryNotificationCertType = expiryNotificationCertType;
    }
}

