/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.draft.ConnectionDraft;
import com.pingidentity.draft.Draft;
import com.pingidentity.draft.mgmt.DraftManager;
import com.pingidentity.draft.mgmt.DraftManagerImpl;
import com.pingidentity.fsm.cert.CertificateExpiryDisplay;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionImageType;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.util.license.LicenseManager;

public abstract class ConnectionTasklet
extends MultiProtocolTasklet
implements CertificateExpiryDisplay {
    private static final long serialVersionUID = 2090710684986328732L;
    private boolean existingConnection = true;
    private long startTime = -1L;
    private long lastUpdated = 0L;
    private boolean warned;
    private boolean loadedFromDraft = false;
    private boolean isCopied = false;
    private String expiryNotificationCertId;
    private CertificateType expiryNotificationCertType;
    public static final Comparator<ConnectionTasklet> COMPARE_BY_LAST_MODIFIED = new Comparator<ConnectionTasklet>(){

        @Override
        public int compare(ConnectionTasklet o1, ConnectionTasklet o2) {
            return ConnectionBase.COMPARE_BY_LAST_MODIFIED.compare(o1.getBase(), o2.getBase());
        }
    };

    public abstract ConnectionType getConnectionType();

    @Override
    public abstract void gotoSummaryState(IRequestCycle var1);

    public abstract ConnectionBase getBase();

    public abstract boolean isBaseUrlConfigured();

    public abstract String getBaseUrlProtocol();

    public abstract String getBaseUrlString();

    public abstract void renameConnectionId(String var1);

    public abstract String getConnectionName();

    public abstract List<String> getVirtualEntityIds();

    public abstract boolean isBrowserSsoProfileEnabled();

    public abstract boolean isWsTrustStsEnabled();

    public abstract boolean isOAuthSamlAssertionMappingEnabled();

    public abstract boolean isInboundProvisioningEnabled();

    public abstract boolean isInboundProvisioningGroupsEnabled();

    public abstract boolean isOutboundProvisioningEnabled();

    public abstract ConnectionBase buildConnectionForSaveToDisk();

    public abstract boolean isBrowserSsoStateEnabled();

    public abstract boolean isC2cEnabled();

    public abstract String getSystemId();

    public abstract void metaDataReset();

    public ConnectionTasklet(String taskletName) {
        super(taskletName);
    }

    public ConnectionTasklet(String taskletName, String menuName) {
        super(taskletName, menuName);
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        if (this.warned || !this.isUpdated()) {
            if (this.getBase() != null && this.getBase().getId() != null) {
                this.deleteDraftByDraftId(this.getBase().getId());
            }
            this.warned = false;
            return super.onFinish(cycle);
        }
        this.getDelegate().record("This connection has been modified after rendering this page. Saving will result in overwriting those changes. Click ''Save'' again to overwrite.", ValidationConstraint.REQUIRED);
        this.warned = true;
        return false;
    }

    @Override
    public boolean isFinishAvailable() {
        super.isFinishAvailable();
        if (!LicenseManager.canAddConnection() && this.isModeCreate()) {
            this.setFinishAvailable(false);
        }
        return this.getFinishAvailable();
    }

    public String getStatus() {
        return null;
    }

    public String getConnId() {
        return null;
    }

    public String getConnIdOnDisk() {
        return null;
    }

    public boolean isExistingConnection() {
        return this.existingConnection;
    }

    public void setExistingConnection(boolean enterImportState) {
        this.existingConnection = enterImportState;
        this.reconfigureTransitions();
    }

    public boolean saveDraft(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            DraftManager draftManager = DraftManagerImpl.getInstance();
            Stack<Tasklet> stackToSerialize = this.getSystemVisit().popStackToTasklet(ConnectionTasklet.class);
            boolean wasDraftSuccessful = draftManager.saveDraft(this.createDraft(), stackToSerialize);
            ((TaskletState)this.getSystemVisit().peek().getCurrentState()).refreshState();
            return wasDraftSuccessful;
        }
        return true;
    }

    public Draft createDraft() {
        ConnectionDraft draft = new ConnectionDraft();
        draft.setId(this.getConnId());
        draft.setProtocol(this.getProtocolType());
        draft.setConnectionType(this.getConnectionType());
        draft.setLastModifiedDate((Calendar)new XmlCalendar(new Date()));
        draft.setConnectionName(!StringUtils.isBlank((String)this.getConnectionName()) ? this.getConnectionName() : this.getConnId());
        draft.setBrowserSsoConfigured(this.isBrowserSsoProfileEnabled());
        draft.setWsTrustConfigured(this.isWsTrustStsEnabled());
        draft.setInboundProvisioningConfigured(this.isInboundProvisioningEnabled());
        draft.setOutboundProvisioningConfigured(this.isOutboundProvisioningEnabled());
        draft.setOauthSamlGrantConfigured(this.isOAuthSamlAssertionMappingEnabled());
        for (String virtualEntityId : this.getVirtualEntityIds()) {
            VirtualIdentity virtualIdentity = new VirtualIdentity();
            virtualIdentity.setVirtualEntityId(virtualEntityId, DomainMode.CONFIGTIME);
        }
        String id = this.getBase() != null ? this.getBase().getId() : null;
        draft.setDraftId(id != null ? id : XmlIDUtil.createID());
        draft.setConnectionImageTypes(this.getConnectionImageTypes());
        return draft;
    }

    private ArrayList<Tasklet> flipStackToList(Stack<Tasklet> stack) {
        ArrayList<Tasklet> taskletList = new ArrayList<Tasklet>();
        while (!stack.isEmpty()) {
            taskletList.add(stack.pop());
        }
        return taskletList;
    }

    public boolean resumeDraft(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String draftId = (String)params[1];
        return this.resumeDraft(draftId, cycle);
    }

    public boolean loadDraft(String entityid, IRequestCycle cycle) {
        DraftManager draftManager = DraftManagerImpl.getInstance();
        String draftId = draftManager.getDraftId(entityid, this.getConnectionType());
        return this.resumeDraft(draftId, cycle);
    }

    private boolean resumeDraft(String draftId, IRequestCycle cycle) {
        ArrayList<Tasklet> taskletList = this.rehydrateDraft(draftId);
        if (taskletList == null) {
            return false;
        }
        this.checkForDraftErrors(taskletList, cycle);
        this.getSystemVisit().setTaskletStack(taskletList);
        return true;
    }

    public void checkForDraftErrors(ArrayList<Tasklet> taskletList, IRequestCycle cycle) {
        for (Tasklet t : taskletList) {
            t.setDraft(true);
            t.updateVisit(this.getSystemVisit());
            t.onResumeDraft();
        }
        boolean hasErrors = false;
        for (Tasklet tasklet : taskletList) {
            ValidationDelegate delegate = this.getDelegate(cycle);
            delegate.clear();
            tasklet.appendErrors((IValidationDelegate)delegate, null, false);
            hasErrors = delegate.getHasErrors();
            tasklet.setHasErrors(hasErrors);
            tasklet.setDraft(false);
        }
    }

    private ArrayList<Tasklet> rehydrateDraft(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String draftId = (String)params[1];
        return this.rehydrateDraft(draftId);
    }

    public ArrayList<Tasklet> rehydrateDraft(String draftId) {
        DraftManager draftManager = DraftManagerImpl.getInstance();
        Stack<Tasklet> stack = draftManager.getStack(draftId);
        if (stack == null) {
            return null;
        }
        ArrayList<Tasklet> taskletList = this.flipStackToList(stack);
        Draft draft = draftManager.getDraft(draftId);
        Tasklet t = taskletList.get(0);
        if (t instanceof IdpConnectionConfigTasklet) {
            IdpConnectionConfigTasklet idp = (IdpConnectionConfigTasklet)t;
            IdpConnection idpConnection = new IdpConnection();
            idpConnection.setId(draftId);
            idpConnection.setEntityId(draft.getId());
            idp.setIdpConnection(idpConnection);
            idp.setLoadedFromDraft(true);
        } else {
            SpConnectionConfigTasklet sp = (SpConnectionConfigTasklet)t;
            SpConnection spConnection = new SpConnection();
            spConnection.setId(draftId);
            spConnection.setEntityId(draft.getId());
            spConnection.setConnectionTargetType(sp.getSelectedTargetType());
            sp.setSpConnection(spConnection);
            sp.setLoadedFromDraft(true);
        }
        return taskletList;
    }

    public void setLoadedFromDraft(boolean loadedFromDraft) {
        this.loadedFromDraft = loadedFromDraft;
    }

    public boolean isLoadedFromDraft() {
        return this.loadedFromDraft;
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public void setCopied(boolean copied) {
        this.isCopied = copied;
    }

    public void deleteDraftByDraftId(String draftId) {
        DraftManager draftManager = DraftManagerImpl.getInstance();
        draftManager.deleteDraft(draftId);
    }

    public void deleteDraftByEntityId(String entityId) {
        DraftManager draftManager = DraftManagerImpl.getInstance();
        draftManager.deleteDraft(entityId, this.getConnectionType());
    }

    @Override
    public boolean isSaveDraftAvailable() {
        AdministrativeUser user = this.getSystemVisit().getCurrentUser();
        return !user.isAuditor() && ((TaskletState)this.getCurrentState()).isSaveDraftAvailable();
    }

    @Override
    public List<ConnectionImageType> getConnectionImageTypes() {
        return ConnectionImageType.getConnectionImageTypes(this.isBrowserSsoProfileEnabled(), this.isWsTrustStsEnabled(), this.isInboundProvisioningEnabled(), this.isOutboundProvisioningEnabled(), this.isOAuthSamlAssertionMappingEnabled(), this.getProtocolType());
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private boolean isUpdated() {
        ConnectionBase connection;
        if (this.getSystemId() != null && (connection = this.getManagerConnection()) != null && connection.getLastModified() != null) {
            return this.lastUpdated < connection.getLastModified().getTimeInMillis();
        }
        return false;
    }

    private ConnectionBase getManagerConnection() {
        boolean isIdpConnection = this instanceof IdpConnectionConfigTasklet;
        if (isIdpConnection) {
            return MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(this.getSystemId());
        }
        return MgmtFactory.getConnectionManager().getSpConnectionBySystemId(this.getSystemId());
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        ConnectionBase connection = this.getManagerConnection();
        if (connection != null) {
            this.lastUpdated = this.getManagerConnection().getLastModified().getTimeInMillis();
        }
    }

    protected boolean showExtendedPropertiesState() {
        ClientSettingManager clientSettingManager = MgmtFactory.getClientSettingManager();
        return clientSettingManager.getExtendedProperties() != null && !clientSettingManager.getExtendedProperties().isEmpty();
    }

    @Override
    public Cert getCertForExpiryNotification() {
        Set connectionVerificationCerts;
        ConnectionBase connectionBase = this.getBase();
        if (connectionBase == null) {
            return null;
        }
        Cert certForDisplay = null;
        if ((CertificateType.CONNECTION_ENCRYPTION == this.expiryNotificationCertType || CertificateType.CONNECTION_VERIFICATION_ENCRYPTION == this.expiryNotificationCertType) && connectionBase.getEncryptionSettings() != null && connectionBase.getEncryptionSettings().getEncryptionCert() != null && this.expiryNotificationCertId != null && this.expiryNotificationCertId.equals(this.getBase().getEncryptionSettings().getEncryptionCert().getId())) {
            certForDisplay = this.getBase().getEncryptionSettings().getEncryptionCert();
        } else if (CertificateType.CONNECTION_VERIFICATION == this.expiryNotificationCertType && (connectionVerificationCerts = connectionBase.getDsigVerificationCerts().getAllVerificationCerts()) != null) {
            for (Cert verificationCert : connectionVerificationCerts) {
                if (!verificationCert.getId().equals(this.expiryNotificationCertId)) continue;
                certForDisplay = verificationCert;
                break;
            }
        }
        return certForDisplay;
    }

    @Override
    public void setCertIdForExpiryNotification(String certId) {
        this.expiryNotificationCertId = certId;
    }

    @Override
    public CertificateType getCertTypeForExpiryNotification() {
        return this.expiryNotificationCertType;
    }

    @Override
    public void setCertTypeForExpiryNotification(CertificateType expiryNotificationCertType) {
        this.expiryNotificationCertType = expiryNotificationCertType;
    }
}

