/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CertSummaryState;
import com.pingidentity.fsm.state.impl.ExportCertState;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.ExportType;
import com.pingidentity.fsm.tasklet.data.KeyPairFileFormat;
import com.pingidentity.fsm.tasklet.impl.AbstractExportTasklet;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.pingcommons.bcfips.ImportExportException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;

public class ExportCertTasklet
extends AbstractExportTasklet
implements CertApi {
    private static final long serialVersionUID = 20050515L;
    private static final Log log = LogFactory.getLog(ExportCertTasklet.class);
    private ExportCertState exportCertState;
    private CertSummaryState certSummaryState;
    private boolean activatable;
    private boolean certificateOnly;

    public ExportCertTasklet(Visit visit) {
        super("ExportCertTasklet", "Export Certificate");
        this.setSystemVisit(visit);
        this.exportCertState = new ExportCertState(this);
        this.certSummaryState = new CertSummaryState(this);
        this.certSummaryState.setDownloadButtonVisible(true);
        this.certSummaryState.setMenuName("Export & Summary");
        this.exportCertState.addOutgoingTransition(this, this.certSummaryState);
        if (this.exportCertState.isBCFIPSMode()) {
            this.exportCertState.setFormat(KeyPairFileFormat.PEM);
        }
        this.setInitialState(this.exportCertState);
        this.setCancelAvailable(true);
    }

    public String getFilename() {
        String filename = null;
        if (this.getExportType() == ExportType.CERT_ONLY) {
            filename = this.exportCertState.getCertItem().getCert().getSerialNumberAsHex() + ".crt";
        } else if (this.getExportType() == ExportType.CERT_AND_PRIVATE_KEY) {
            if (this.getKeyPairFileFormat() == KeyPairFileFormat.PEM || this.exportCertState.isBCFIPSMode()) {
                filename = this.exportCertState.getCertItem().getCert().getSerialNumberAsHex() + ".pem";
            } else if (this.getKeyPairFileFormat() == KeyPairFileFormat.PKCS12 && !this.exportCertState.isBCFIPSMode()) {
                filename = this.exportCertState.getCertItem().getCert().getSerialNumberAsHex() + ".p12";
            }
        }
        return filename;
    }

    public byte[] getRawBytes() {
        this.setExported(true);
        byte[] rawBytes = null;
        try {
            if (this.getExportType() == ExportType.CERT_ONLY) {
                rawBytes = this.exportCertState.getCertItem().getCert().exportCert().getBytes(StandardCharsets.UTF_8);
            } else if (this.getExportType() == ExportType.CERT_AND_PRIVATE_KEY) {
                PkCert pkCert = (PkCert)this.exportCertState.getCertItem().getCert();
                if (this.getKeyPairFileFormat() == KeyPairFileFormat.PEM || this.exportCertState.isBCFIPSMode()) {
                    rawBytes = pkCert.exportPEM(this.getPassword());
                } else if (this.getKeyPairFileFormat() == KeyPairFileFormat.PKCS12) {
                    rawBytes = pkCert.exportPKCS12(this.getPassword());
                }
            }
            if (this.saveOnExport()) {
                ((CertManagementTasklet)this.getParentTasklet()).saveCerts();
            }
        }
        catch (IOException io) {
            log.error((Object)("Exporting this file caused an IOException! " + io), (Throwable)io);
        }
        catch (CertificateException certEx) {
            log.error((Object)("Exporting this file caused an CertificateException! " + certEx), (Throwable)certEx);
        }
        catch (KeyStoreException keyStoreEx) {
            log.error((Object)("Exporting this file caused an KeyStoreException! " + keyStoreEx), (Throwable)keyStoreEx);
        }
        catch (NoSuchAlgorithmException algEx) {
            log.error((Object)("Exporting this file caused an NoSuchAlgorithmException! " + algEx), (Throwable)algEx);
        }
        catch (ImportExportException ieEx) {
            log.error((Object)("Exporting this file caused an ImportExportException! " + ieEx), (Throwable)ieEx);
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            auditLoggerScope.log(AdminAuditLogger.Component.CERTIFICATE, AdminAuditLogger.Event.EXPORT, this.exportCertState.getCertItem().getCert().getX509Certificate().getSubjectDN().getName());
        }
        return rawBytes;
    }

    public void setCertToExport(CertItem cert) {
        this.exportCertState.setCertItem(cert);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isActivatable() {
        return this.activatable;
    }

    public void setActivatable(boolean activatable) {
        this.activatable = activatable;
    }

    public boolean isCertificateOnly() {
        return this.certificateOnly;
    }

    public void setCertificateOnly(boolean certificateOnly) {
        this.certificateOnly = certificateOnly;
    }

    public ExportType getExportType() {
        if (this.certificateOnly) {
            return ExportType.CERT_ONLY;
        }
        return this.exportCertState.getExportType();
    }

    public String getPassword() {
        return this.exportCertState.getPassword();
    }

    public KeyPairFileFormat getKeyPairFileFormat() {
        return this.exportCertState.getFormat();
    }

    @Override
    public CertItem getCertItem() {
        return null;
    }

    public void setLunaNote() {
        this.exportCertState.setNoteKey("ExportCertTasklet_ExportCertState_Luna");
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        boolean continueProcessing = super.onFinish(cycle);
        this.setDoneClicked(true);
        return continueProcessing;
    }

    private boolean saveOnExport() {
        CertManagementTasklet parentTasklet = this.findParent(CertManagementTasklet.class);
        CertItem certItem = this.exportCertState.getCertItem();
        boolean saveAvailable = "Save".equals(parentTasklet.getFinishLabel());
        return saveAvailable && (certItem.isNewCert() || certItem.isImported());
    }

    @Override
    public boolean isFinishAvailable() {
        return this.getCurrentState() instanceof CertSummaryState;
    }
}

