/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ExportCertDataState;
import com.pingidentity.fsm.state.impl.ExportConnectionState;
import com.pingidentity.fsm.state.impl.ExportCustomContractState;
import com.pingidentity.fsm.state.impl.ExportMetadataSummaryState;
import com.pingidentity.fsm.state.impl.ExportProtocolState;
import com.pingidentity.fsm.state.impl.ExportVirtualHostNameState;
import com.pingidentity.fsm.state.impl.ExportXmlEncryptionCertState;
import com.pingidentity.fsm.state.impl.MetadataSigningState;
import com.pingidentity.fsm.state.impl.SelectExportModeState;
import com.pingidentity.fsm.state.impl.SelectExportRoleState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.impl.AbstractExportTasklet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.MetaDataInfo;
import org.sourceid.saml20.domain.util.MetadataImportExportUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.saml20.metadata.partner.ConnectionDb;
import org.sourceid.saml20.metadata.partner.ConnectionDbEntry;
import org.sourceid.websso.Protocol;

public class ExportMetadataTasklet
extends AbstractExportTasklet {
    private static final String FILE_NAME = "metadata.xml";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExportMetadataTasklet.class);
    private final SelectExportRoleState selectExportRoleState = new SelectExportRoleState(this);
    private final SelectExportModeState selectExportModeState = new SelectExportModeState(this);
    private final ExportProtocolState exportProtocolState;
    private final ExportConnectionState exportConnectionState = new ExportConnectionState(this);
    private final ExportCustomContractState exportCustomContractState;
    private final ExportCertDataState exportCertDataState;
    private final ExportXmlEncryptionCertState exportXmlEncryptionCertState;
    private final ExportMetadataSummaryState exportMetadataSummaryState;
    private final MetadataSigningState metadataSigningState;
    private final ExportVirtualHostNameState exportVirtualHostNameState;

    public ExportMetadataTasklet(Visit visit) {
        super("ExportMetadataTasklet", "Metadata Export");
        this.exportProtocolState = new ExportProtocolState(this);
        this.exportCustomContractState = new ExportCustomContractState(this);
        this.exportCertDataState = new ExportCertDataState(this);
        this.exportXmlEncryptionCertState = new ExportXmlEncryptionCertState(this);
        this.exportXmlEncryptionCertState.setCertType(CertificateTypes.ValidTypes.dsigSigningCert);
        this.exportXmlEncryptionCertState.setMenuName("XML Encryption Certificate");
        this.exportMetadataSummaryState = new ExportMetadataSummaryState(this);
        this.metadataSigningState = new MetadataSigningState(this);
        this.exportVirtualHostNameState = new ExportVirtualHostNameState(this);
        this.setSystemVisit(visit);
        this.setInitialState(this.selectExportRoleState);
        this.setCancelAvailable(true);
        this.selectExportRoleState.addOutgoingTransition(this, this.selectExportModeState);
        this.selectExportModeState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.exportProtocolState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return ExportMetadataTasklet.this.selectExportModeState.getMode().equals(SelectExportModeState.MANUAL_MODE);
            }
        });
        this.exportProtocolState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.exportVirtualHostNameState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return !MgmtFactory.getVirtualHostNamesMgr().getHostNames().isEmpty();
            }
        });
        this.exportVirtualHostNameState.addOutgoingTransition(this, this.exportCustomContractState);
        this.exportProtocolState.addOutgoingTransition(this, this.exportCustomContractState);
        this.exportCustomContractState.addOutgoingTransition(this, this.exportCertDataState);
        this.exportCertDataState.addOutgoingTransition(this, this.metadataSigningState);
        this.metadataSigningState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.exportXmlEncryptionCertState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return ExportMetadataTasklet.this.exportProtocolState.getProtocol() == Protocol.SAML20 && ExportMetadataTasklet.this.selectExportModeState.getMode().equals(SelectExportModeState.MANUAL_MODE);
            }
        });
        this.metadataSigningState.addOutgoingTransition(this, this.exportMetadataSummaryState);
        this.exportXmlEncryptionCertState.addOutgoingTransition(this, this.exportMetadataSummaryState);
        this.selectExportModeState.addOutgoingTransition(this, this.exportConnectionState);
        this.exportConnectionState.addOutgoingTransition(this, this.metadataSigningState);
        this.metadataSigningState.addOutgoingTransition(this, this.exportMetadataSummaryState);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void setDefaultRole(DefaultRole role) {
        switch (role) {
            case IDP: {
                this.selectExportRoleState.setMetadataRole(ConnectionType.IDP);
                this.setInitialState(this.selectExportModeState);
                break;
            }
            case SP: {
                this.selectExportRoleState.setMetadataRole(ConnectionType.SP);
                this.setInitialState(this.selectExportModeState);
                break;
            }
            case None: {
                this.setInitialState(this.selectExportRoleState);
            }
        }
    }

    public void setExportMode(Integer mode) {
        this.selectExportModeState.setMode(mode);
    }

    public boolean exportIDP() {
        return this.selectExportRoleState.getMetadataRole().equals((Object)ConnectionType.IDP);
    }

    public void clearSelectedConnection() {
        this.exportConnectionState.setSelectedConnection(null);
        this.exportConnectionState.setSelectedConnectionDisplayName(null);
        this.exportConnectionState.setSelectedConnectionTypeAndId(null);
    }

    public void setSelectedConnection(String entityId) {
        ConnectionDb connectionDb = MgmtFactory.getConnectionDb();
        Role role = this.exportIDP() ? Role.SP : Role.IDP;
        ConnectionDbEntry conn = connectionDb.getEntryByEntityId(role, entityId);
        this.exportConnectionState.setSelectedConnection(entityId);
        this.exportConnectionState.setSelectedConnectionDisplayName(conn.getName());
        SelectedOption selectedOption = role.equals((Object)Role.IDP) ? new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION, entityId) : new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION, entityId);
        this.exportConnectionState.setSelectedConnectionTypeAndId(selectedOption.toString());
    }

    public String getFilename() {
        return FILE_NAME;
    }

    private byte[] getMetaDataRawBytes(MetaDataInfo mdi) {
        return MetadataImportExportUtil.getMetaDataRawBytes((MetaDataInfo)mdi, (String)this.metadataSigningState.getSelectedSigningAlgType(), (PkCert)((PkCert)this.metadataSigningState.getSelectedCert()), (boolean)this.metadataSigningState.isIncludeKeyInfo(), (PathUtil)MetaDataFactory.getLocalMetaData().getPathUtil(), (boolean)this.metadataSigningState.isIncludeKeyValue());
    }

    public byte[] getRawBytes() {
        this.setExported(true);
        MetaDataInfo mdi = new MetaDataInfo();
        mdi.setExportIDPRole(this.exportIDP());
        log.debug((Object)"Populate MetaDataInfo");
        this.save(mdi);
        return this.getMetaDataRawBytes(mdi);
    }

    public void gotoMetadataSigningState(IRequestCycle cycle) {
        this.setGotoState(this.metadataSigningState.getTaskletId());
        this.goToState(cycle);
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        boolean continueProcessing = super.onFinish(cycle);
        this.setDoneClicked(true);
        return continueProcessing;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean isFinishAvailable() {
        return this.getCurrentState() instanceof ExportMetadataSummaryState;
    }

    public static enum DefaultRole {
        IDP,
        SP,
        None;

    }
}

