/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.IdpProtocolSettingsState;
import com.pingidentity.fsm.state.impl.OAuthAttributeMappingState;
import com.pingidentity.fsm.state.impl.SelectSamlProfilesState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.UserSessionCreationState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpProtocolSettingsTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.websso.Protocol;

public class IdpBrowserSsoTasklet
extends MultiProtocolTasklet
implements NeededCredentialsApi,
WebSsoApi,
SamlProfilesApi,
AttributeNamesApi {
    final SelectSamlProfilesState selectSamlProfilesState;
    final UserSessionCreationState userSessionCreationState;
    final IdpProtocolSettingsState idpProtocolSettingsState;
    final OAuthAttributeMappingState oAuthAttributeMappingState;
    final SummaryCardState summaryCardState;
    private static final long serialVersionUID = 1L;

    public IdpBrowserSsoTasklet(Visit visit) {
        super("IdpBrowserSsoTasklet", "Browser SSO");
        this.setSystemVisit(visit);
        this.selectSamlProfilesState = new SelectSamlProfilesState(this);
        this.userSessionCreationState = new UserSessionCreationState(this);
        this.idpProtocolSettingsState = new IdpProtocolSettingsState(this);
        this.oAuthAttributeMappingState = new OAuthAttributeMappingState(this);
        this.oAuthAttributeMappingState.setMenuName("OAuth Attribute Mapping");
        this.summaryCardState = new SummaryCardState(this);
        this.setInitialState(this.selectSamlProfilesState);
        this.setCancelAvailable(true);
    }

    @Override
    public void configureTasklet() {
        if (this.isWsFedProtocol() || this.isConnectionProtocolOIDC()) {
            this.setInitialState(this.userSessionCreationState);
        } else {
            this.setInitialState(this.selectSamlProfilesState);
        }
        this.clearAllStatesOutgoingTransitions();
        this.selectSamlProfilesState.addOutgoingTransition(this, this.userSessionCreationState);
        this.userSessionCreationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpBrowserSsoTasklet.this.isOAuthAttributeMappingEnabled();
            }
        });
        this.userSessionCreationState.addOutgoingTransition(this, this.idpProtocolSettingsState);
        this.oAuthAttributeMappingState.addOutgoingTransition(this, this.idpProtocolSettingsState);
        this.idpProtocolSettingsState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public Protocol getProtocolType() {
        return this.findParent(ConnectionTasklet.class).getProtocolType();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void finish() {
        IdpConnection connection = new IdpConnection();
        this.save(connection);
        this.setPopulateData(connection);
        super.finish();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.isAnySsoSelected() && this.idpProtocolSettingsState.isBackChannelAuthenticationNeeded();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.isAnySsoSelected() && this.idpProtocolSettingsState.isDigitalSignatureVerificationNeeded();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.isAnySsoSelected() && this.idpProtocolSettingsState.isDigitalSignatureNeeded();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return this.isAnySsoSelected() && this.idpProtocolSettingsState.isEncryptionCertificateNeeded();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return (this.isAnySsoSelected() || this.isWsFedProtocol()) && this.idpProtocolSettingsState.isDecryptionKeyNeeded();
    }

    @Override
    public boolean isInboundArtifact() {
        return this.idpProtocolSettingsState.isInboundArtifact();
    }

    @Override
    public boolean isArtifactSsoSlo() {
        return this.idpProtocolSettingsState.isArtifactSsoSlo();
    }

    @Override
    public boolean isSoapSlo() {
        return this.idpProtocolSettingsState.isSoapSlo();
    }

    @Override
    public boolean isInboundSoap() {
        return this.idpProtocolSettingsState.isInboundSoap();
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        return this.idpProtocolSettingsState.isAnyOutboundSoapNotUsingHttps();
    }

    @Override
    public boolean isAnySloSelected() {
        return this.selectSamlProfilesState.isAnySloSelected();
    }

    @Override
    public boolean isAnySpSelected() {
        return this.selectSamlProfilesState.isAnySpSelected();
    }

    @Override
    public boolean isAnySsoSelected() {
        return this.selectSamlProfilesState.isAnySsoSelected();
    }

    @Override
    public boolean isAttributeQuerySelected() {
        return false;
    }

    @Override
    public boolean isIdpSLOSelected() {
        return this.selectSamlProfilesState.isIdpSLOSelected();
    }

    @Override
    public boolean isIdpSSOSelected() {
        return this.selectSamlProfilesState.isIdpSSOSelected();
    }

    @Override
    public boolean isOnlySpSSOSelected() {
        return this.selectSamlProfilesState.isOnlySpSSOSelected();
    }

    @Override
    public boolean isSomethingOtherThanIdpInitiatedSsoSelected() {
        return this.selectSamlProfilesState.isSomethingOtherThanIdpInitiatedSsoSelected();
    }

    @Override
    public boolean isSomethingOtherThanSpInitiatedSsoSelected() {
        return this.selectSamlProfilesState.isSomethingOtherThanSpInitiatedSsoSelected();
    }

    @Override
    public boolean isSpSLOSelected() {
        return this.selectSamlProfilesState.isSpSLOSelected();
    }

    @Override
    public boolean isSpSSOSelected() {
        return this.selectSamlProfilesState.isSpSSOSelected();
    }

    @Override
    public boolean onlyIdpSsoSelected() {
        return this.selectSamlProfilesState.onlyIdpSsoSelected();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.userSessionCreationState.getAllAttrNamesSorted();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.userSessionCreationState.getAllAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.userSessionCreationState.getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.userSessionCreationState.getSortedMutableAttributeNames();
    }

    public int getMappedAdapterCount() {
        return this.userSessionCreationState.getAdapterCount();
    }

    public int getMappedC2cCount() {
        return this.userSessionCreationState.getC2cCount();
    }

    public List<IdpConfigAdapterMappingTasklet> getAdapterTasklets() {
        return this.userSessionCreationState.getAdapterTasklets();
    }

    public List<IdpC2cContractMappingTasklet> getC2cTasklets() {
        return this.userSessionCreationState.getC2cTasklets();
    }

    public IdpProtocolSettingsTasklet getIdpProtocolSettingsTasklet() {
        return this.idpProtocolSettingsState.getTaskletToEdit(IdpProtocolSettingsTasklet.class);
    }

    private boolean isOAuthAttributeMappingEnabled() {
        boolean enabled = false;
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        if (tasklet != null) {
            enabled = tasklet.isOAuthAttributeMappingEnabled();
        }
        return enabled;
    }
}

