/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ActivationState;
import com.pingidentity.fsm.state.impl.AdditionalIssuersState;
import com.pingidentity.fsm.state.impl.AttributeAuthorityState;
import com.pingidentity.fsm.state.impl.ConnRoleAndProtocolState;
import com.pingidentity.fsm.state.impl.ConnectionOptionsState;
import com.pingidentity.fsm.state.impl.CredentialsState;
import com.pingidentity.fsm.state.impl.ExtendedPropertyManagementState;
import com.pingidentity.fsm.state.impl.GeneralInfoState;
import com.pingidentity.fsm.state.impl.IdpBrowserSsoState;
import com.pingidentity.fsm.state.impl.ImportMetadataCertState;
import com.pingidentity.fsm.state.impl.ImportMetadataState;
import com.pingidentity.fsm.state.impl.InboundProvisioningState;
import com.pingidentity.fsm.state.impl.MetadataSummaryState;
import com.pingidentity.fsm.state.impl.OAuthSAMLGrantAttributeMappingState;
import com.pingidentity.fsm.state.impl.UserProvisioningState;
import com.pingidentity.fsm.state.impl.WsTrustIdpState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.api.XaspApi;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.MappingNameItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.IRequestCycle;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.websso.Protocol;

public class IdpConnectionConfigTasklet
extends ConnectionTasklet
implements NeededCredentialsApi,
SamlProfilesApi,
WebSsoApi,
ImportMetadataApi,
XaspApi,
AttributeNamesApi {
    private static final long serialVersionUID = 20050515L;
    private IdpConnection idpConnection;
    final ConnRoleAndProtocolState connRoleAndProtocolState;
    final ConnectionOptionsState connectionOptionsState;
    final ImportMetadataState importMetadataState;
    final ImportMetadataCertState importMetadataCertState;
    final MetadataSummaryState metadataSummaryState;
    final GeneralInfoState generalInfoState;
    final AdditionalIssuersState additionalIssuersState;
    final IdpBrowserSsoState idpBrowserSsoState;
    final WsTrustIdpState wsTrustIdpState;
    final AttributeAuthorityState attributeAuthorityState;
    final CredentialsState credentialsState;
    final ActivationState activationState;
    final UserProvisioningState userProvisioningState;
    final InboundProvisioningState inboundProvisioningState;
    final OAuthSAMLGrantAttributeMappingState oAuthSAMLGrantAttributeMappingState;
    final ExtendedPropertyManagementState extendedPropertyManagementState;

    public IdpConnectionConfigTasklet(Visit visit) {
        super("IdpConnectionConfigTasklet", "IdP Connection");
        this.setSystemVisit(visit);
        this.connRoleAndProtocolState = new ConnRoleAndProtocolState(this);
        this.connectionOptionsState = new ConnectionOptionsState(this);
        this.importMetadataState = new ImportMetadataState(this);
        this.importMetadataCertState = new ImportMetadataCertState(this);
        this.metadataSummaryState = new MetadataSummaryState(this);
        this.generalInfoState = new GeneralInfoState(this);
        this.additionalIssuersState = new AdditionalIssuersState(this);
        this.idpBrowserSsoState = new IdpBrowserSsoState(this);
        this.wsTrustIdpState = new WsTrustIdpState(this);
        this.userProvisioningState = new UserProvisioningState(this);
        this.inboundProvisioningState = new InboundProvisioningState(this);
        this.attributeAuthorityState = new AttributeAuthorityState(this);
        this.oAuthSAMLGrantAttributeMappingState = new OAuthSAMLGrantAttributeMappingState(this);
        this.oAuthSAMLGrantAttributeMappingState.setMenuName("OAuth Assertion Grant Attribute Mapping");
        this.credentialsState = new CredentialsState(this);
        this.activationState = new ActivationState(this);
        this.activationState.setSummaryTitle("Summary");
        this.extendedPropertyManagementState = new ExtendedPropertyManagementState((IWizard)this, true);
        this.setInitialState(this.connRoleAndProtocolState);
        this.setCancelAvailable(true);
    }

    @Override
    public void reconfigureTransitions() {
        this.clearAllStatesOutgoingTransitions();
        this.importMetadataState.setExistingConnection(this.isExistingConnection());
        this.connRoleAndProtocolState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.connectionOptionsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled();
            }
        });
        this.connRoleAndProtocolState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importMetadataState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !IdpConnectionConfigTasklet.this.isWsFedProtocol() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() && !IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC();
            }
        });
        this.connRoleAndProtocolState.addOutgoingTransition(this, this.generalInfoState);
        this.connectionOptionsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importMetadataState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !IdpConnectionConfigTasklet.this.isWsFedProtocol() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() && !IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC();
            }
        });
        this.connectionOptionsState.addOutgoingTransition(this, this.generalInfoState);
        this.importMetadataState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importMetadataCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.importMetadataState.isSignatureVerificationRequired() && IdpConnectionConfigTasklet.this.importMetadataState.isSignedMetadataWoKeyInfo();
            }
        });
        this.importMetadataState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.metadataSummaryState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.importMetadataState.isUnsignedOrSignedWithKeyInfo() && IdpConnectionConfigTasklet.this.importMetadataState.isMetadataSummaryRequired() && !IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC();
            }
        });
        this.importMetadataState.addOutgoingTransition(this, this.generalInfoState);
        this.importMetadataCertState.addOutgoingTransition(this, this.metadataSummaryState);
        this.metadataSummaryState.addOutgoingTransition(this, this.generalInfoState);
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.extendedPropertyManagementState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.showExtendedPropertiesState();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.additionalIssuersState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() && IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC() && IdpConnectionConfigTasklet.this.isAdditionalIssuersEnabled();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.idpBrowserSsoState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() && (!IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC() || !IdpConnectionConfigTasklet.this.isAdditionalIssuersEnabled());
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustIdpState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustStsEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustEnabledInServerSettings();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeAuthorityState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isAttributeQuerySelected();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthSAMLGrantAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isOAuthSamlAssertionMappingEnabled();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled();
            }
        });
        this.generalInfoState.addOutgoingTransition(this, this.credentialsState);
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.additionalIssuersState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() && IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC() && IdpConnectionConfigTasklet.this.isAdditionalIssuersEnabled();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.idpBrowserSsoState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() && (!IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC() || !IdpConnectionConfigTasklet.this.isAdditionalIssuersEnabled());
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustIdpState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustStsEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustEnabledInServerSettings();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeAuthorityState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isAttributeQuerySelected();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthSAMLGrantAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isOAuthSamlAssertionMappingEnabled();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(this, this.credentialsState);
        this.additionalIssuersState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.idpBrowserSsoState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustIdpState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustStsEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustEnabledInServerSettings();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeAuthorityState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isAttributeQuerySelected();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.userProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isUserProvisioningEnabled();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthSAMLGrantAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isOAuthSamlAssertionMappingEnabled();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.activationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC();
            }
        });
        this.idpBrowserSsoState.addOutgoingTransition(this, this.credentialsState);
        this.wsTrustIdpState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeAuthorityState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isAttributeQuerySelected();
            }
        });
        this.wsTrustIdpState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.userProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && IdpConnectionConfigTasklet.this.isUserProvisioningEnabled() && !IdpConnectionConfigTasklet.this.isAttributeQuerySelected();
            }
        });
        this.wsTrustIdpState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthSAMLGrantAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isOAuthSamlAssertionMappingEnabled();
            }
        });
        this.wsTrustIdpState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled();
            }
        });
        this.wsTrustIdpState.addOutgoingTransition(this, this.credentialsState);
        this.attributeAuthorityState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.userProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isUserProvisioningEnabled();
            }
        });
        this.attributeAuthorityState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthSAMLGrantAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isOAuthSamlAssertionMappingEnabled();
            }
        });
        this.attributeAuthorityState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled();
            }
        });
        this.attributeAuthorityState.addOutgoingTransition(this, this.credentialsState);
        this.userProvisioningState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthSAMLGrantAttributeMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isOAuthSamlAssertionMappingEnabled();
            }
        });
        this.userProvisioningState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isInboundProvisioningEnabledInServerSettings();
            }
        });
        this.userProvisioningState.addOutgoingTransition(this, this.credentialsState);
        this.oAuthSAMLGrantAttributeMappingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundProvisioningState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConnectionConfigTasklet.this.isInboundProvisioningEnabled() && IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isInboundProvisioningEnabledInServerSettings();
            }
        });
        this.oAuthSAMLGrantAttributeMappingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.credentialsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() || !IdpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled() || !IdpConnectionConfigTasklet.this.isConnectionProtocolOIDC();
            }
        });
        this.oAuthSAMLGrantAttributeMappingState.addOutgoingTransition(this, this.activationState);
        this.inboundProvisioningState.addOutgoingTransition(this, this.credentialsState);
        this.credentialsState.addOutgoingTransition(this, this.activationState);
        this.connRoleAndProtocolState.setItClickable(true);
    }

    @Override
    public void finish() {
        this.saveToDisk();
        super.finish();
    }

    public IdpConnection buildConnectionForSaveToDisk() {
        IdpConnection connection = new IdpConnection();
        if (this.isUserProvisioningEnabled()) {
            connection.setUserProvisioning(new UserProvisioning());
        }
        if (this.isInboundProvisioningEnabled()) {
            connection.setInboundProvisioning(new ScimUserProvisioning());
        }
        if (!this.isBrowserSsoStateEnabled()) {
            EnabledProfiles enabledProfiles = connection.getEnabledProfiles();
            enabledProfiles.setIdpInitiatedSSOEnabled(false);
            enabledProfiles.setIdpInitiatedSLOEnabled(false);
            enabledProfiles.setSpInitiatedSSOEnabled(false);
            enabledProfiles.setSpInitiatedSLOEnabled(false);
        }
        if (this.idpConnection != null) {
            connection.setId(this.idpConnection.getId());
        }
        this.setMode(Mode.edit);
        this.save(connection);
        return connection;
    }

    public void saveToDisk() {
        IdpConnection connection = this.buildConnectionForSaveToDisk();
        if (!(this.idpConnection == null || !this.idpConnection.getEntityId().equals(connection.getEntityId()) && this.isCopied() || this.isLoadedFromDraft())) {
            connection.setCreationTime(this.idpConnection.getCreationTime());
        } else {
            connection.setCreationTime((Calendar)new XmlCalendar(new Date()));
        }
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        connectionManager.saveIdpConnection(connection);
        NotificationBanner notificationBanner = NotificationBanner.getNotificationBannerForConnection((ConnectionBase)connection);
        this.getSystemVisit().setNotificationBannerContent(notificationBanner);
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)this.idpConnection, DependencyType.AUTHN_POLICY_ATTRS);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)this.idpConnection, DependencyType.FRAGMENT_ATTRS);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)connection, DependencyType.PROTOCOL_SETTINGS);
    }

    private boolean isUserProvisioningEnabled() {
        return this.connectionOptionsState.isUserProvisioningEnabled();
    }

    @Override
    public boolean isBrowserSsoStateEnabled() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled();
    }

    @Override
    public String getFinishLabel() {
        return "Save";
    }

    @Override
    public Protocol getProtocolType() {
        return this.connRoleAndProtocolState.getProtocol();
    }

    public String getRole() {
        return "IdP";
    }

    @Override
    public String getStatus() {
        return this.activationState.isConnectionActive() ? "Active" : "Inactive";
    }

    public IdpConnection getIdpConnection() {
        return this.idpConnection;
    }

    public void setIdpConnection(IdpConnection idpConnection) {
        this.idpConnection = idpConnection;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.IDP;
    }

    @Override
    public String getClassType() {
        return this.activationState.isConnectionActive() ? "active" : "disabled";
    }

    @Override
    public String getTaskletId() {
        return this.getConnectionType() + this.getConnId();
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getConnId().toLowerCase().compareTo(((ConnectionTasklet)o).getConnId().toLowerCase());
    }

    @Override
    public String getConnId() {
        return this.generalInfoState.getConnId();
    }

    @Override
    public String getConnIdOnDisk() {
        return this.generalInfoState.getConnIdOnDisk();
    }

    @Override
    public List<String> getVirtualEntityIds() {
        return this.generalInfoState.getVirtualServerIdNames();
    }

    @Override
    public String getConnectionName() {
        return this.generalInfoState.getConnectionName();
    }

    public void setConnectionName(String connectionName) {
        this.generalInfoState.setConnectionName(connectionName);
    }

    public void gotoGeneralInfoState(IRequestCycle cycle) {
        this.setGotoState(this.generalInfoState.toString());
        this.goToState(cycle);
    }

    @Override
    public void gotoSummaryState(IRequestCycle cycle) {
        this.setGotoState(this.activationState.getTaskletStateId());
        this.goToState(cycle);
    }

    @Override
    public ConnectionBase getBase() {
        return this.getIdpConnection();
    }

    @Override
    public boolean isBaseUrlConfigured() {
        return this.generalInfoState.isBaseUrlConfigured();
    }

    @Override
    public String getBaseUrlString() {
        return this.generalInfoState.getBaseUrlString();
    }

    @Override
    public String getBaseUrlProtocol() {
        if (this.isBaseUrlConfigured()) {
            try {
                URL url = new URL(this.generalInfoState.getBaseUrlString());
                return url.getProtocol();
            }
            catch (MalformedURLException u) {
                return "";
            }
        }
        return "";
    }

    @Override
    public void renameConnectionId(String newConnId) {
        this.generalInfoState.setConnId(newConnId);
    }

    @Override
    public boolean isAnySsoSelected() {
        return this.idpBrowserSsoState.isAnySsoSelected();
    }

    @Override
    public boolean isAttributeQuerySelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isAttributeQueryEnabled();
    }

    public boolean isAttributeQueryEnabledInUserProvisioning() {
        return this.isUserProvisioningEnabled() && this.userProvisioningState.isAttrQueryEnabled();
    }

    @Override
    public boolean isAnySloSelected() {
        return this.idpBrowserSsoState.isAnySloSelected();
    }

    @Override
    public boolean isIdpSSOSelected() {
        return this.idpBrowserSsoState.isIdpSSOSelected();
    }

    @Override
    public boolean isIdpSLOSelected() {
        return this.idpBrowserSsoState.isIdpSLOSelected();
    }

    @Override
    public boolean isSomethingOtherThanIdpInitiatedSsoSelected() {
        return this.idpBrowserSsoState.isSomethingOtherThanIdpInitiatedSsoSelected();
    }

    @Override
    public boolean isSpSSOSelected() {
        return this.idpBrowserSsoState.isSpSSOSelected();
    }

    @Override
    public boolean isSpSLOSelected() {
        return this.idpBrowserSsoState.isSpSLOSelected();
    }

    @Override
    public boolean isOnlySpSSOSelected() {
        return this.idpBrowserSsoState.isOnlySpSSOSelected();
    }

    @Override
    public boolean onlyIdpSsoSelected() {
        return this.idpBrowserSsoState.onlyIdpSsoSelected();
    }

    @Override
    public boolean isAnySpSelected() {
        return this.idpBrowserSsoState.isAnySpSelected();
    }

    @Override
    public boolean isSomethingOtherThanSpInitiatedSsoSelected() {
        return this.idpBrowserSsoState.isSomethingOtherThanSpInitiatedSsoSelected();
    }

    public void setAttributeQueryValue(boolean attributeQueryEnabled) {
        this.connectionOptionsState.setAttributeQueryEnabled(attributeQueryEnabled);
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.isAnySsoSelected() && this.idpBrowserSsoState.isBackChannelAuthenticationNeeded() || this.attributeAuthorityState.isBackChannelAuthenticationNeeded() || this.connRoleAndProtocolState.isInboundProvisioningEnabled();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.isAnySsoSelected() && this.idpBrowserSsoState.isDigitalSignatureVerificationNeeded() || this.attributeAuthorityState.isDigitalSignatureVerificationNeeded() || this.isWsFedProtocol() || this.connRoleAndProtocolState.isWsTrustStsEnabled() || this.connRoleAndProtocolState.isOAuthEnabled();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.isAnySsoSelected() && this.idpBrowserSsoState.isDigitalSignatureNeeded() || this.attributeAuthorityState.isDigitalSignatureNeeded();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return this.isAnySsoSelected() && this.idpBrowserSsoState.isEncryptionCertificateNeeded() || this.attributeAuthorityState.isEncryptionCertificateNeeded();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return (this.isAnySsoSelected() || this.isWsFedProtocol()) && this.idpBrowserSsoState.isDecryptionKeyNeeded() || this.attributeAuthorityState.isDecryptionKeyNeeded() || this.connRoleAndProtocolState.isWsTrustStsEnabled() && this.wsTrustIdpState.isDecryptionKeyNeeded();
    }

    @Override
    public boolean isInboundArtifact() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.isInboundArtifact() : false;
    }

    @Override
    public boolean isSoapSlo() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.isSoapSlo() : false;
    }

    @Override
    public boolean isArtifactSsoSlo() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.isArtifactSsoSlo() : false;
    }

    @Override
    public boolean isInboundSoap() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.isInboundSoap() : false;
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.isAnyOutboundSoapNotUsingHttps() : false;
    }

    @Override
    public boolean isXaspEndpointHttps() {
        return this.attributeAuthorityState.isXaspEndpointHttps();
    }

    @Override
    public ArrayList<SummaryInfo> getMetadataSummary() {
        ArrayList<SummaryInfo> summaryList = this.importMetadataState.getMetadataSummary();
        if (this.importMetadataState.isSignedMetadataWoKeyInfo()) {
            this.importMetadataCertState.getSummary(summaryList);
        }
        return summaryList;
    }

    @Override
    public void importConnection() {
        this.importMetadataState.importConnection();
    }

    @Override
    public XmlObject getMetadataXml() {
        return this.importMetadataState.getMetadataXml();
    }

    @Override
    public String getMetadataUrlId() {
        return this.importMetadataState.getMetadataUrlId();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.getAllAttributeNames() : new HashSet();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.getAllAttrNamesSorted() : new ArrayList();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.getSortedImmutableAttributeNames() : new ArrayList();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.findState(this.idpBrowserSsoState.getStateName()) != null ? this.idpBrowserSsoState.getSortedMutableAttributeNames() : new ArrayList();
    }

    public int getMappedToAdapterCount() {
        return this.idpBrowserSsoState.getMappedToAdapterCount();
    }

    public int getMappedToC2cCount() {
        return this.idpBrowserSsoState.getMappedToC2cCount();
    }

    public List<IdpConfigAdapterMappingTasklet> getAdapterTasklets() {
        return this.idpBrowserSsoState.getAdapterTasklets();
    }

    public void setSummaryStateClickable(boolean itClickable) {
        this.activationState.setItClickable(itClickable);
    }

    @Override
    public boolean isBrowserSsoProfileEnabled() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled();
    }

    @Override
    public boolean isWsTrustStsEnabled() {
        return this.connRoleAndProtocolState.isWsTrustStsEnabled();
    }

    public boolean isOAuthAttributeMappingEnabled() {
        return this.connectionOptionsState.isOAuthAttributeMappingEnabled();
    }

    @Override
    public boolean isOAuthSamlAssertionMappingEnabled() {
        return this.connRoleAndProtocolState.isOAuthEnabled();
    }

    public List<MappingNameItem> getAttrQueryAttrList() {
        return this.attributeAuthorityState != null ? this.attributeAuthorityState.getAttrQueryAttrList() : null;
    }

    @Override
    public boolean isInboundProvisioningEnabled() {
        return this.connRoleAndProtocolState.isInboundProvisioningEnabled();
    }

    @Override
    public boolean isInboundProvisioningGroupsEnabled() {
        return this.connRoleAndProtocolState.isGroupInboundProvisioningEnabled();
    }

    public ScimVersion getInboundProvisioningScimVersion() {
        return this.connRoleAndProtocolState.getInboundProvisioningScimVersion();
    }

    @Override
    public boolean isOutboundProvisioningEnabled() {
        return false;
    }

    @Override
    public boolean isC2cEnabled() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableFederationHub() || this.connectionOptionsState.isOAuthAttributeMappingEnabled();
    }

    @Override
    public Integer getMetadataType() {
        return this.importMetadataState.getMetadataType();
    }

    @Override
    public boolean save(Object dataToDisk) {
        boolean saveSuccesful = super.save(dataToDisk);
        this.importMetadataState.reset();
        return saveSuccesful;
    }

    public String getClientSecret() {
        return this.generalInfoState.getClientSecret();
    }

    public boolean isAdditionalIssuersEnabled() {
        return this.generalInfoState.isAdditionalIssuersEnabled();
    }

    @Override
    public String getSystemId() {
        return this.idpConnection == null ? null : this.idpConnection.getId();
    }

    @Override
    public void metaDataReset() {
        this.credentialsState.metaDataReset();
    }

    public IdpBrowserSsoTasklet getIdpBrowserSsoTasklet() {
        return this.idpBrowserSsoState.getTaskletToEdit(IdpBrowserSsoTasklet.class);
    }
}

