/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigCommonDomainServiceState;
import com.pingidentity.fsm.state.impl.ConfigDomainCookieSettingsState;
import com.pingidentity.fsm.state.impl.ConfigLocalCommonDomainServerState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpDiscoveryTasklet
extends Tasklet {
    private static final long serialVersionUID = 20050515L;
    final ConfigDomainCookieSettingsState configDomainCookieSettingsState;
    final ConfigCommonDomainServiceState configCommonDomainServiceState;
    final ConfigLocalCommonDomainServerState configLocalCommonDomainServerState;
    final SummaryCardState summaryCardState;

    public IdpDiscoveryTasklet(Visit visit) {
        super("IdpDiscoveryTasklet", "Configure IdP Discovery");
        this.setSystemVisit(visit);
        this.setFinishLabel("Save");
        this.configDomainCookieSettingsState = new ConfigDomainCookieSettingsState(this);
        this.configCommonDomainServiceState = new ConfigCommonDomainServiceState(this);
        this.configLocalCommonDomainServerState = new ConfigLocalCommonDomainServerState(this);
        this.summaryCardState = new SummaryCardState(this, "summaryCard");
        this.setInitialState(this.configDomainCookieSettingsState);
        this.setCancelAvailable(true);
        this.configDomainCookieSettingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configCommonDomainServiceState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return IdpDiscoveryTasklet.this.configDomainCookieSettingsState.spOrIdpClientSelected();
            }
        });
        this.configDomainCookieSettingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configLocalCommonDomainServerState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return IdpDiscoveryTasklet.this.configDomainCookieSettingsState.isEnableCommonDomainServer();
            }
        });
        this.configDomainCookieSettingsState.addOutgoingTransition(this, this.summaryCardState);
        this.configCommonDomainServiceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configLocalCommonDomainServerState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return IdpDiscoveryTasklet.this.configDomainCookieSettingsState.isEnableCommonDomainServer();
            }
        });
        this.configCommonDomainServiceState.addOutgoingTransition(this, this.summaryCardState);
        this.configLocalCommonDomainServerState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public void finish() {
        LocalSettingsManager localSettingsManager = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsManager.getLocalSettings();
        this.setMode(Mode.edit);
        this.save(localSettings);
        localSettingsManager.saveLocalSettings(localSettings, AdminAuditLogger.Component.SYSTEM, this.getMessage("Idp_discovery_management"));
        super.finish();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public String getCommonDomainServiceBaseUrl() {
        return this.configCommonDomainServiceState.getBaseUrl();
    }

    public String getCommonDomainPassphrase() {
        return this.configCommonDomainServiceState.getPassPhrase();
    }
}

