/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AllowableSamlBindingsState;
import com.pingidentity.fsm.state.impl.ArtifactConfigState;
import com.pingidentity.fsm.state.impl.ArtifactResolverLocationState;
import com.pingidentity.fsm.state.impl.ConfigArtifactLifetimeState;
import com.pingidentity.fsm.state.impl.DefaultTargetUrlState;
import com.pingidentity.fsm.state.impl.IdpSignaturePolicyState;
import com.pingidentity.fsm.state.impl.OpenIdProviderMetadataState;
import com.pingidentity.fsm.state.impl.SelectIdpXmlAssertionEncryptionState;
import com.pingidentity.fsm.state.impl.ServiceUrlConfigState;
import com.pingidentity.fsm.state.impl.SloServiceUrlConfigState;
import com.pingidentity.fsm.state.impl.SsoServiceUrlState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsFedServiceUrlState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.impl.IdpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class IdpProtocolSettingsTasklet
extends MultiProtocolTasklet
implements NeededCredentialsApi,
WebSsoApi {
    private static final long serialVersionUID = 20050515L;
    final WsFedServiceUrlState wsFedServiceUrlState;
    final ServiceUrlConfigState ssoServiceUrlConfigState;
    final SsoServiceUrlState ssoServiceUrlState;
    final SloServiceUrlConfigState sloServiceUrlConfigState;
    final AllowableSamlBindingsState allowableSamlBindingsState;
    final ArtifactResolverLocationState artifactResolverLocationState;
    final ArtifactConfigState artifactConfigState;
    final OpenIdProviderMetadataState openIdProviderMetadataState;
    final DefaultTargetUrlState defaultTargetUrlState;
    final ConfigArtifactLifetimeState configArtifactLifetimeState;
    final IdpSignaturePolicyState idpSignaturePolicyState;
    final SelectIdpXmlAssertionEncryptionState selectIdpXmlAssertionEncryptionState;
    final SummaryCardState summaryCardState;

    public IdpProtocolSettingsTasklet(Visit visit) {
        super("IdpProtocolSettingsTasklet", "Protocol Settings");
        this.setSystemVisit(visit);
        this.wsFedServiceUrlState = new WsFedServiceUrlState(this, false);
        this.ssoServiceUrlConfigState = new ServiceUrlConfigState(this);
        this.ssoServiceUrlState = new SsoServiceUrlState(this);
        this.sloServiceUrlConfigState = new SloServiceUrlConfigState(this);
        this.allowableSamlBindingsState = new AllowableSamlBindingsState(this);
        this.artifactResolverLocationState = new ArtifactResolverLocationState(this);
        this.artifactConfigState = new ArtifactConfigState(this);
        this.openIdProviderMetadataState = new OpenIdProviderMetadataState(this);
        this.defaultTargetUrlState = new DefaultTargetUrlState(this);
        this.configArtifactLifetimeState = new ConfigArtifactLifetimeState(this);
        this.idpSignaturePolicyState = new IdpSignaturePolicyState(this);
        this.selectIdpXmlAssertionEncryptionState = new SelectIdpXmlAssertionEncryptionState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setCurrentState(this.allowableSamlBindingsState);
        this.setSourceState(this.allowableSamlBindingsState);
        if (!MgmtFactory.getJCEManager().allowXmlEncryption()) {
            this.selectIdpXmlAssertionEncryptionState.setNoteKey("IdpWebSsoTasklet_SelectIdpXmlAssertionEncryptionState_Luna");
            this.selectIdpXmlAssertionEncryptionState.setAllowXmlEncryption(false);
        }
        this.setCancelAvailable(true);
    }

    @Override
    public void configureTasklet() {
        if (this.getInitialState() != null) {
            this.clearAllStatesOutgoingTransitions();
        }
        this.ssoServiceUrlConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.sloServiceUrlConfigState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpProtocolSettingsTasklet.this.isAnySloSelected();
            }
        });
        this.ssoServiceUrlConfigState.addOutgoingTransition(this, this.allowableSamlBindingsState);
        this.ssoServiceUrlState.addOutgoingTransition(this, this.allowableSamlBindingsState);
        this.sloServiceUrlConfigState.addOutgoingTransition(this, this.allowableSamlBindingsState);
        this.allowableSamlBindingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.artifactResolverLocationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpProtocolSettingsTasklet.this.isConnectionProtocol1x() && IdpProtocolSettingsTasklet.this.isInboundArtifact();
            }
        });
        this.allowableSamlBindingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configArtifactLifetimeState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpProtocolSettingsTasklet.this.isArtifactSsoSlo();
            }
        });
        this.allowableSamlBindingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.artifactConfigState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpProtocolSettingsTasklet.this.isInboundArtifact();
            }
        });
        this.allowableSamlBindingsState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.configArtifactLifetimeState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.artifactConfigState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpProtocolSettingsTasklet.this.isInboundArtifact();
            }
        });
        this.configArtifactLifetimeState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.artifactResolverLocationState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.artifactConfigState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.openIdProviderMetadataState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.defaultTargetUrlState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.idpSignaturePolicyState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !IdpProtocolSettingsTasklet.this.isConnectionProtocolOIDC();
            }
        });
        this.idpSignaturePolicyState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectIdpXmlAssertionEncryptionState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpProtocolSettingsTasklet.this.isConnectionProtocol20() || IdpProtocolSettingsTasklet.this.isWsFedProtocol();
            }
        });
        this.idpSignaturePolicyState.addOutgoingTransition(this, this.summaryCardState);
        this.selectIdpXmlAssertionEncryptionState.addOutgoingTransition(this, this.summaryCardState);
        this.wsFedServiceUrlState.addOutgoingTransition(this, this.defaultTargetUrlState);
        this.defaultTargetUrlState.addOutgoingTransition(this, this.summaryCardState);
        this.ssoServiceUrlConfigState.setDomainTranslator(this.getProtocolType());
        this.sloServiceUrlConfigState.setDomainTranslator(this.getProtocolType());
        if (this.isWsFedProtocol()) {
            this.setInitialState(this.wsFedServiceUrlState);
        } else if (this.isConnectionProtocol1x() && this.isSpSSOSelected()) {
            this.setInitialState(this.ssoServiceUrlState);
        } else if (this.isConnectionProtocol20() && this.isSpSSOSelected()) {
            this.setInitialState(this.ssoServiceUrlConfigState);
        } else if (this.isConnectionProtocol20() && this.isAnySloSelected()) {
            this.setInitialState(this.sloServiceUrlConfigState);
        } else if (this.isConnectionProtocolOIDC()) {
            this.setInitialState(this.openIdProviderMetadataState);
        } else {
            this.setInitialState(this.allowableSamlBindingsState);
        }
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public Protocol getProtocolType() {
        return ((IdpBrowserSsoTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.isArtifactSsoSlo() || this.isSoapSlo() || this.isInboundArtifact() || this.isInboundSoap();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.isInboundPostOrRedirect() || this.idpSignaturePolicyState.isAssertionSigned() || this.isWsFedProtocol();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.isAnySloPostOrRedirect() || this.idpSignaturePolicyState.isWantAuthnRequestsSigned();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return this.selectIdpXmlAssertionEncryptionState.isSloEncryptSubjectNameID();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return this.selectIdpXmlAssertionEncryptionState.getSectionsEncryptedXml() == SelectIdpXmlAssertionEncryptionState.enable;
    }

    @Override
    public boolean isInboundArtifact() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isArtifactBinding() : false;
    }

    @Override
    public boolean isInboundSoap() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isSoapBinding() : false;
    }

    @Override
    public boolean isArtifactSsoSlo() {
        boolean artifactSsoSlo = false;
        if (this.isSamlProtocol() && this.isSpSSOSelected()) {
            artifactSsoSlo |= this.ssoServiceUrlConfigState.isArtifactBindingUsed();
        }
        if (this.isAnySloSelected()) {
            artifactSsoSlo |= this.sloServiceUrlConfigState.isArtifactBindingUsed();
        }
        return artifactSsoSlo;
    }

    @Override
    public boolean isSoapSlo() {
        boolean soapSlo = false;
        if (this.isAnySloSelected()) {
            soapSlo = this.sloServiceUrlConfigState.isSoapBindingUsed();
        }
        return soapSlo;
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        return this.isAnyArsNotUsingHttps() || this.isAnySoapSloNotUsingHttps();
    }

    public List<String> getOutboundSsoBindingList() {
        ArrayList<String> bindings = new ArrayList<String>();
        if (this.ssoServiceUrlConfigState.isAnyBindingUsed()) {
            if (this.ssoServiceUrlConfigState.isPostBindingUsed()) {
                bindings.add("POST");
            }
            if (this.ssoServiceUrlConfigState.isRedirectBindingUsed()) {
                bindings.add("Redirect");
            }
            if (this.ssoServiceUrlConfigState.isArtifactBindingUsed()) {
                bindings.add("Artifact");
            }
            if (this.ssoServiceUrlConfigState.isSoapBindingUsed()) {
                bindings.add("SOAP");
            }
        }
        return bindings;
    }

    public String getScopesList() {
        return this.openIdProviderMetadataState.getScopes();
    }

    public String getOidcProfile() {
        return this.openIdProviderMetadataState.getProfile().getName();
    }

    public List<String> getOutboundSloBindingList() {
        ArrayList<String> bindings = new ArrayList<String>();
        if (this.sloServiceUrlConfigState.isAnyBindingUsed()) {
            if (this.sloServiceUrlConfigState.isPostBindingUsed()) {
                bindings.add("POST");
            }
            if (this.sloServiceUrlConfigState.isRedirectBindingUsed()) {
                bindings.add("Redirect");
            }
            if (this.sloServiceUrlConfigState.isArtifactBindingUsed()) {
                bindings.add("Artifact");
            }
            if (this.sloServiceUrlConfigState.isSoapBindingUsed()) {
                bindings.add("SOAP");
            }
        }
        return bindings;
    }

    public List<String> getInboundBindingList() {
        ArrayList<String> bindings = new ArrayList<String>();
        if (this.allowableSamlBindingsState.isAnyBindingSelected()) {
            if (this.isInboundPost()) {
                bindings.add("POST");
            }
            if (this.isInboundRedirect()) {
                bindings.add("Redirect");
            }
            if (this.isInboundArtifact()) {
                bindings.add("Artifact");
            }
            if (this.isInboundSoap()) {
                bindings.add("SOAP");
            }
        }
        return bindings;
    }

    public String getArtifactLifetime() {
        return this.configArtifactLifetimeState.getArtifactLifetime();
    }

    public List<String> getSignaturePolicyList() {
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("SAML-standard");
        if ("CUSTOM".equals(this.idpSignaturePolicyState.getSignatureMode())) {
            if (this.idpSignaturePolicyState.isAssertionSigned()) {
                policies.add("SAML Assertion");
            }
            if (this.idpSignaturePolicyState.isWantAuthnRequestsSigned()) {
                policies.add("Authn requests over POST & Redirect");
            }
        }
        return policies;
    }

    public List<String> getEncryptionPolicyList() {
        ArrayList<String> policies = new ArrayList<String>();
        if (this.selectIdpXmlAssertionEncryptionState.isNoneSelected()) {
            policies.add("No Encryption");
        } else {
            if (this.selectIdpXmlAssertionEncryptionState.getEncryptEntireAssertion()) {
                policies.add("SAML Assertion");
            }
            if (this.selectIdpXmlAssertionEncryptionState.getEncryptSamlSubject()) {
                policies.add("SAML_Subject");
            }
            if (this.selectIdpXmlAssertionEncryptionState.getEncryptAttributes()) {
                policies.add("One or more attributes");
            }
        }
        return policies;
    }

    public OpenIdProviderMetadataState getOpenIdProviderMetadataState() {
        return this.openIdProviderMetadataState;
    }

    private boolean isInboundPostOrRedirect() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isPostOrRedirectSelected() : false;
    }

    private boolean isInboundPost() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isPostBinding() : false;
    }

    private boolean isInboundRedirect() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isRedirectBinding() : false;
    }

    private boolean isAnyArsNotUsingHttps() {
        boolean anyArsNotUsingHttps = false;
        if (this.findState(this.artifactConfigState.getStateName()) != null) {
            anyArsNotUsingHttps |= this.artifactConfigState.anyEndpointNotUsingHttps();
        } else if (this.findState(this.artifactResolverLocationState.getStateName()) != null) {
            anyArsNotUsingHttps |= this.artifactResolverLocationState.anyEndpointNotUsingHttps();
        }
        return anyArsNotUsingHttps;
    }

    private boolean isAnySoapSloNotUsingHttps() {
        boolean anySoapSloNotUsingHttps = false;
        if (this.isSoapSlo()) {
            anySoapSloNotUsingHttps |= this.sloServiceUrlConfigState.isAnySoapNotUsingHttps(true);
        }
        return anySoapSloNotUsingHttps;
    }

    private boolean isAnySloPostOrRedirect() {
        boolean soapSlo = false;
        if (this.isAnySloSelected()) {
            soapSlo |= this.sloServiceUrlConfigState.isPostOrRedirectBindingUsed();
        }
        return soapSlo;
    }

    private boolean isAnySloSelected() {
        return this.findParent(SamlProfilesApi.class).isAnySloSelected();
    }

    private boolean isSpSSOSelected() {
        return this.findParent(SamlProfilesApi.class).isSpSSOSelected();
    }
}

