/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.JCEManager;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AttrAuthSecurityPolicyState;
import com.pingidentity.fsm.state.impl.AttributeNameMappingState;
import com.pingidentity.fsm.state.impl.AttributeRequestServiceUrlState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.XaspApi;
import com.pingidentity.fsm.tasklet.data.MappingNameItem;
import java.util.List;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpXaspTasklet
extends Tasklet
implements NeededCredentialsApi,
XaspApi {
    private static final long serialVersionUID = 20050515L;
    final AttributeRequestServiceUrlState attributeRequestServiceUrlState;
    final AttributeNameMappingState attributeNameMappingState;
    final AttrAuthSecurityPolicyState attrAuthSecurityPolicyState;
    final SummaryCardState summaryCardState;

    public IdpXaspTasklet(Visit visit) {
        super("IdpXaspTasklet", "Attribute Query");
        this.setSystemVisit(visit);
        this.attributeRequestServiceUrlState = new AttributeRequestServiceUrlState(this);
        this.attributeNameMappingState = new AttributeNameMappingState(this);
        this.attrAuthSecurityPolicyState = new AttrAuthSecurityPolicyState(this);
        this.summaryCardState = new SummaryCardState(this);
        JCEManager jceManager = MgmtFactory.getJCEManager();
        if (!jceManager.allowXmlEncryption()) {
            this.attrAuthSecurityPolicyState.setDisableXmlEncryption(true);
            this.attrAuthSecurityPolicyState.setNoteKey("IdpXaspTasklet_AttrAuthSecurityPolicyState_Luna");
        }
        this.attributeRequestServiceUrlState.addOutgoingTransition(this, this.attributeNameMappingState);
        this.attributeNameMappingState.addOutgoingTransition(this, this.attrAuthSecurityPolicyState);
        this.attrAuthSecurityPolicyState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.attributeRequestServiceUrlState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return true;
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.attrAuthSecurityPolicyState.isRequireSignedResponse() || this.attrAuthSecurityPolicyState.isRequireSignedAssertion();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.attrAuthSecurityPolicyState.isSignAttributeQuery();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return this.attrAuthSecurityPolicyState.isEncryptNameId();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return this.attrAuthSecurityPolicyState.isRequireEncryptedAssertion();
    }

    @Override
    public boolean isXaspEndpointHttps() {
        return this.attributeRequestServiceUrlState.isXaspEndpointHttps();
    }

    public List<MappingNameItem> getAttrQueryAttrList() {
        return this.attributeNameMappingState != null ? this.attributeNameMappingState.getValues() : null;
    }
}

