/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CertSummaryState;
import com.pingidentity.fsm.state.impl.ImportCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.impl.WsTrustStsSslAuthTasklet;

public class ImportCertTasklet
extends Tasklet
implements CertApi {
    private static final long serialVersionUID = 20050515L;
    private ImportCertState importCertState;
    private CertSummaryState certSummaryState;
    private CertificateTypes.ValidTypes certType;
    private boolean globalEditing = false;
    boolean activatable = true;

    public ImportCertTasklet(Visit visit) {
        super("ImportCertTasklet", "Import Certificate");
        this.setSystemVisit(visit);
        this.importCertState = new ImportCertState(this);
        this.certSummaryState = new CertSummaryState(this);
        this.certSummaryState.setSummaryTitle("Imported Certificate Details");
        this.importCertState.addOutgoingTransition(this, this.certSummaryState);
        this.setInitialState(this.importCertState);
        this.setCancelAvailable(true);
    }

    @Override
    public CertItem getCertItem() {
        CertItem certItem = this.importCertState.getCertItem();
        if (this.importCertState.getCertItem() != null) {
            certItem.setActive(this.certSummaryState.isActive());
            certItem.setActiveAdminSslCert(this.certSummaryState.isActiveAdminSslCert());
            certItem.setNewCert(true);
        }
        return certItem;
    }

    public CertificateTypes.ValidTypes getCertType() {
        return this.certType;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.importCertState.setCertType(certType);
        this.certType = certType;
    }

    public boolean isGlobalEditing() {
        return this.globalEditing;
    }

    public void setGlobalEditing(boolean globalEditing) {
        this.globalEditing = globalEditing;
    }

    @Override
    public boolean isActivatable() {
        return this.activatable;
    }

    public boolean isSslCert() {
        return this.certType == CertificateTypes.ValidTypes.sslServerCerts;
    }

    public boolean isVerificationCertImport() {
        return this.certType == CertificateTypes.ValidTypes.dsigVerificationCert || this.certType == CertificateTypes.ValidTypes.ocspDsigVerificationCert || this.certType == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert;
    }

    public void setActivatable() {
        Tasklet parent;
        if (this.globalEditing) {
            if (this.certType != CertificateTypes.ValidTypes.sslServerCerts) {
                this.activatable = false;
            }
        } else if (this.certType == CertificateTypes.ValidTypes.trustedCAs) {
            this.activatable = false;
        }
        if (!this.activatable) {
            this.certSummaryState.setActive(false);
            this.certSummaryState.setActiveAdminSslCert(false);
        }
        if ((parent = (Tasklet)this.findParent(WsTrustStsSslAuthTasklet.class)) != null) {
            this.activatable = false;
        }
    }

    @Override
    public void finish() {
        super.finish();
        this.getParentTasklet().save(null);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isSaveAllAvailable() {
        if (this.hasCertificateRevocationChecking()) {
            return false;
        }
        return !this.hasConnectionWizard();
    }
}

