/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BasicSoapAuthOutboundState;
import com.pingidentity.fsm.state.impl.OutboundConfigSoapAuthState;
import com.pingidentity.fsm.state.impl.SslCertAuthState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;

public class InboundArtifactBindingConfigTasklet
extends Tasklet {
    private static final long serialVersionUID = 20050515L;
    final OutboundConfigSoapAuthState outboundSoapAuthConfigState;
    final BasicSoapAuthOutboundState basicSoapAuthOutboundState;
    final SslCertAuthState sslCertAuthState;
    final SummaryCardState summaryState;

    public InboundArtifactBindingConfigTasklet(Visit visit) {
        super("InboundArtifactBindingConfigTasklet", "Back-Channel Authentication");
        this.setSystemVisit(visit);
        this.outboundSoapAuthConfigState = new OutboundConfigSoapAuthState(this);
        this.basicSoapAuthOutboundState = new BasicSoapAuthOutboundState(this, "basicAuth");
        this.basicSoapAuthOutboundState.setMenuName("Basic SOAP Authentication (Outbound)");
        this.sslCertAuthState = new SslCertAuthState(this);
        this.sslCertAuthState.setCertType(CertificateTypes.ValidTypes.sslCertAuth);
        this.sslCertAuthState.setMenuName("SSL Authentication Certificate");
        this.summaryState = new SummaryCardState(this);
        this.outboundSoapAuthConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.basicSoapAuthOutboundState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return InboundArtifactBindingConfigTasklet.this.outboundSoapAuthConfigState.isBasic();
            }
        });
        this.basicSoapAuthOutboundState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.sslCertAuthState){
            private static final long serialVersionUID = 12345L;

            @Override
            public boolean validate() {
                return InboundArtifactBindingConfigTasklet.this.outboundSoapAuthConfigState.isCert();
            }
        });
        this.outboundSoapAuthConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.sslCertAuthState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return InboundArtifactBindingConfigTasklet.this.outboundSoapAuthConfigState.isCert() && !InboundArtifactBindingConfigTasklet.this.outboundSoapAuthConfigState.isBasic();
            }
        });
        this.outboundSoapAuthConfigState.addOutgoingTransition(this, this.summaryState);
        this.sslCertAuthState.addOutgoingTransition(this, this.summaryState);
        this.basicSoapAuthOutboundState.addOutgoingTransition(this, this.summaryState);
        this.setInitialState(this.outboundSoapAuthConfigState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        IdpConnection connectionBase = null;
        switch (this.findParent(ConnectionTasklet.class).getConnectionType()) {
            case IDP: {
                connectionBase = new IdpConnection();
                break;
            }
            case SP: {
                connectionBase = new SpConnection();
            }
        }
        this.save(connectionBase);
        this.setPopulateData(connectionBase);
        super.finish();
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletState state = (TaskletState)this.getSourceState();
        TaskletTransition tt = null;
        do {
            state.getSummary(summaryList);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    public boolean usesDsigAuth() {
        return this.outboundSoapAuthConfigState.usesDsigAuth();
    }

    public boolean isBasic() {
        return this.outboundSoapAuthConfigState.isBasic();
    }

    public boolean usesSSLCert() {
        return this.outboundSoapAuthConfigState.isCert();
    }

    public boolean usesNone() {
        return this.outboundSoapAuthConfigState.isNone();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }
}

