/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigUserProvisioningLdapDirSearchState;
import com.pingidentity.fsm.state.impl.InboundGroupProvisioningConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.InboundProvisioningConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.InboundProvisioningCustomScim2AttributeState;
import com.pingidentity.fsm.state.impl.InboundProvisioningCustomScim2AttributesState;
import com.pingidentity.fsm.state.impl.InboundProvisioningCustomScim2ServiceProviderConfigState;
import com.pingidentity.fsm.state.impl.InboundProvisioningCustomScimAttributeState;
import com.pingidentity.fsm.state.impl.InboundProvisioningCustomScimAttributesState;
import com.pingidentity.fsm.state.impl.InboundProvisioningDeleteUsersOptionsState;
import com.pingidentity.fsm.state.impl.InboundProvisioningOperationState;
import com.pingidentity.fsm.state.impl.InboundProvisioningUserRepositoryState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.api.IdentityStoreProvisionerApi;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningCustomScim2AttributeTasklet;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningCustomScimAttributeTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractViewOnlyTasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.saml20.domain.scim.util.CustomAttributesUtil;

public class InboundProvisioningTasklet
extends AbstractViewOnlyTasklet
implements AttributeSourceApi,
IdentityStoreProvisionerApi {
    private static final long serialVersionUID = 1L;
    private static final String NONE = "None";
    final InboundProvisioningUserRepositoryState userRepositoryState;
    final InboundProvisioningCustomScimAttributesState customSCIMAttributesState;
    final InboundProvisioningCustomScim2AttributesState scim2CustomAttributesState;
    final InboundProvisioningCustomScim2ServiceProviderConfigState serviceProviderConfigState;
    final InboundProvisioningConfigLdapFilterState inboundProvisioningConfigLdapFilterState;
    final InboundGroupProvisioningConfigLdapFilterState inboundGroupProvisioningConfigLdapFilterState;
    final ConfigUserProvisioningLdapDirSearchState configLdapDirSearchState;
    final InboundProvisioningOperationState adWriteUsersState;
    final InboundProvisioningOperationState adReadUsersState;
    final InboundProvisioningOperationState adWriteGroupsState;
    final InboundProvisioningOperationState adReadGroupsState;
    final InboundProvisioningOperationState idStoreWriteUsersState;
    final InboundProvisioningOperationState idStoreReadUsersState;
    final InboundProvisioningOperationState idStoreWriteGroupsState;
    final InboundProvisioningOperationState idStoreReadGroupsState;
    final InboundProvisioningDeleteUsersOptionsState inboundProvisioningDeleteUsersOptionsState;
    final SummaryCardState adSummaryCardState;
    final SummaryCardState idStoreSummaryCardState;

    public InboundProvisioningTasklet(Visit visit) {
        super("InboundProvisioningTasklet", "Inbound Provisioning");
        this.setSystemVisit(visit);
        this.userRepositoryState = new InboundProvisioningUserRepositoryState(this, "inboundProvisioningUserRepository");
        this.userRepositoryState.setMenuName("Repository");
        this.serviceProviderConfigState = new InboundProvisioningCustomScim2ServiceProviderConfigState(this, "inboundProvisioningCustomScim2ServiceProviderConfig");
        this.scim2CustomAttributesState = new InboundProvisioningCustomScim2AttributesState(this, "inboundProvisioningCustomScim2Attributes");
        this.customSCIMAttributesState = new InboundProvisioningCustomScimAttributesState(this, "inboundProvisioningCustomScimAttributes");
        this.configLdapDirSearchState = new ConfigUserProvisioningLdapDirSearchState(this);
        this.inboundProvisioningConfigLdapFilterState = new InboundProvisioningConfigLdapFilterState(this, "userProvisioningConfigLdapFilter");
        this.adWriteUsersState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.WRITE_USERS);
        this.adReadUsersState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.READ_USERS);
        this.idStoreWriteUsersState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.WRITE_USERS);
        this.idStoreReadUsersState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.READ_USERS);
        this.inboundProvisioningDeleteUsersOptionsState = new InboundProvisioningDeleteUsersOptionsState(this);
        this.inboundGroupProvisioningConfigLdapFilterState = new InboundGroupProvisioningConfigLdapFilterState(this, "groupProvisioningConfigLdapFilter");
        this.adWriteGroupsState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.WRITE_GROUPS);
        this.adReadGroupsState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.READ_GROUPS);
        this.idStoreWriteGroupsState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.WRITE_GROUPS);
        this.idStoreReadGroupsState = new InboundProvisioningOperationState(this, InboundProvisioningOperationState.OperationType.READ_GROUPS);
        this.adSummaryCardState = new SummaryCardState(this);
        this.idStoreSummaryCardState = new SummaryCardState(this);
        this.setCancelAvailable(true);
    }

    public void configureTasklet() {
        this.setInitialState(this.userRepositoryState);
        this.reconfigureTransitions(this.getInitialState());
    }

    protected void createLdapTransitions() {
        this.userRepositoryState.addOutgoingTransition(this, this.configLdapDirSearchState);
        this.configLdapDirSearchState.addOutgoingTransition(this, this.inboundProvisioningConfigLdapFilterState);
        this.inboundProvisioningConfigLdapFilterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.inboundGroupProvisioningConfigLdapFilterState){

            @Override
            public boolean validate() {
                return InboundProvisioningTasklet.this.isGroupInboundProvisioningEnabled();
            }
        });
        if (ScimVersion.SCIM20.equals((Object)this.getInboundProvisioningScimVersion())) {
            this.inboundGroupProvisioningConfigLdapFilterState.addOutgoingTransition(this, this.serviceProviderConfigState);
            this.inboundProvisioningConfigLdapFilterState.addOutgoingTransition(this, this.serviceProviderConfigState);
            this.serviceProviderConfigState.addOutgoingTransition(this, this.scim2CustomAttributesState);
            this.scim2CustomAttributesState.addOutgoingTransition(this, this.adWriteUsersState);
        } else {
            this.inboundGroupProvisioningConfigLdapFilterState.addOutgoingTransition(this, this.customSCIMAttributesState);
            this.inboundProvisioningConfigLdapFilterState.addOutgoingTransition(this, this.customSCIMAttributesState);
            this.customSCIMAttributesState.addOutgoingTransition(this, this.adWriteUsersState);
        }
        this.adWriteUsersState.addOutgoingTransition(this, this.adReadUsersState);
        this.adReadUsersState.addOutgoingTransition(this, this.inboundProvisioningDeleteUsersOptionsState);
        this.inboundProvisioningDeleteUsersOptionsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.adWriteGroupsState){

            @Override
            public boolean validate() {
                return InboundProvisioningTasklet.this.isGroupInboundProvisioningEnabled();
            }
        });
        this.adWriteGroupsState.addOutgoingTransition(this, this.adReadGroupsState);
        this.adReadGroupsState.addOutgoingTransition(this, this.adSummaryCardState);
        this.inboundProvisioningDeleteUsersOptionsState.addOutgoingTransition(this, this.adSummaryCardState);
    }

    private boolean isGroupInboundProvisioningEnabled() {
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return tasklet != null && tasklet.isInboundProvisioningGroupsEnabled();
    }

    public ScimVersion getInboundProvisioningScimVersion() {
        IdpConnectionConfigTasklet tasklet = this.findParent(IdpConnectionConfigTasklet.class);
        return tasklet != null ? tasklet.getInboundProvisioningScimVersion() : ScimVersion.SCIM11;
    }

    protected void createIdentityStoreProvisionerTransitions() {
        if (ScimVersion.SCIM20.equals((Object)this.getInboundProvisioningScimVersion())) {
            this.userRepositoryState.addOutgoingTransition(this, this.serviceProviderConfigState);
            this.serviceProviderConfigState.addOutgoingTransition(this, this.scim2CustomAttributesState);
            this.scim2CustomAttributesState.addOutgoingTransition(this, this.idStoreWriteUsersState);
        } else {
            this.userRepositoryState.addOutgoingTransition(this, this.customSCIMAttributesState);
            this.customSCIMAttributesState.addOutgoingTransition(this, this.idStoreWriteUsersState);
        }
        this.idStoreWriteUsersState.addOutgoingTransition(this, this.idStoreReadUsersState);
        this.idStoreReadUsersState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.idStoreWriteGroupsState){

            @Override
            public boolean validate() {
                return InboundProvisioningTasklet.this.isGroupInboundProvisioningEnabled();
            }
        });
        this.idStoreReadUsersState.addOutgoingTransition(this, this.idStoreSummaryCardState);
        this.idStoreWriteGroupsState.addOutgoingTransition(this, this.idStoreReadGroupsState);
        this.idStoreReadGroupsState.addOutgoingTransition(this, this.idStoreSummaryCardState);
    }

    @Override
    public boolean setStatesToVOMode(DataSource dataSource) {
        this.userRepositoryState.setViewOnly(true, this.getTaskletName() + "_InboundProvisioningUserRepositoryStateVo");
        if (dataSource instanceof LdapDataSource) {
            this.inboundProvisioningConfigLdapFilterState.setViewOnly(true, this.getTaskletName() + "_InboundProvisioningConfigLdapFilterStateVo");
            this.inboundGroupProvisioningConfigLdapFilterState.setViewOnly(true, this.getTaskletName() + "_InboundGroupProvisioningConfigLdapFilterStateVo");
            this.configLdapDirSearchState.setViewOnly(true, this.getTaskletName() + "_ConfigUserProvisioningLdapDirSearchStateVo");
        }
        return false;
    }

    @Override
    public boolean setStatesToEditMode(DataSource dataSource) {
        this.userRepositoryState.setViewOnly(false, this.getTaskletName() + "_InboundProvisioningUserRepositoryState");
        if (dataSource instanceof LdapDataSource) {
            this.inboundProvisioningConfigLdapFilterState.setViewOnly(false, this.getTaskletName() + "_InboundProvisioningConfigLdapFilterState");
            this.inboundGroupProvisioningConfigLdapFilterState.setViewOnly(false, this.getTaskletName() + "_InboundGroupProvisioningConfigLdapFilterState");
            this.configLdapDirSearchState.setViewOnly(false, this.getTaskletName() + "_ConfigUserProvisioningLdapDirSearchState");
        }
        return false;
    }

    public DataSource.DSType getUserRepoDataSourceType() {
        return this.userRepositoryState.getDataSourceType();
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
        switch (this.getUserRepositoryType()) {
            case IDENTITY_STORE: {
                this.createIdentityStoreProvisionerTransitions();
                break;
            }
            case ACTIVE_DIRECTORY: {
                this.createLdapTransitions();
                break;
            }
            default: {
                this.createDefaultTransitions();
            }
        }
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        idpConnection.setInboundProvisioning(new ScimUserProvisioning());
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    protected void createDefaultTransitions() {
        this.userRepositoryState.addOutgoingTransition(this, this.adSummaryCardState);
    }

    public String getUserRepository() {
        String userRepository = null;
        switch (this.getUserRepositoryType()) {
            case ACTIVE_DIRECTORY: {
                userRepository = this.userRepositoryState.getDataSourceDesc();
                break;
            }
            case IDENTITY_STORE: {
                userRepository = this.userRepositoryState.getSelectedIdentityStoreProvisioner().getName();
                break;
            }
            default: {
                userRepository = NONE;
            }
        }
        return userRepository;
    }

    public InboundProvisioningUserRepositoryType getUserRepositoryType() {
        return this.userRepositoryState.getUserRepositoryType();
    }

    public String getBaseDN() {
        return !StringUtils.isEmpty((String)this.configLdapDirSearchState.getBaseDN()) ? this.configLdapDirSearchState.getBaseDN() : NONE;
    }

    public String getFilter() {
        return !StringUtils.isEmpty((String)this.inboundProvisioningConfigLdapFilterState.getFilter()) ? this.inboundProvisioningConfigLdapFilterState.getFilter() : NONE;
    }

    public String getGroupFilter() {
        return !StringUtils.isEmpty((String)this.inboundGroupProvisioningConfigLdapFilterState.getFilter()) ? this.inboundGroupProvisioningConfigLdapFilterState.getFilter() : NONE;
    }

    public String getScimDeleteBehavior() {
        return this.inboundProvisioningDeleteUsersOptionsState.isPermanentlyDeleteUsersOnDelete() ? "Permanently Delete User" : "Disable User";
    }

    @Override
    public TaskletState getSummaryState() {
        switch (this.getUserRepositoryType()) {
            case IDENTITY_STORE: {
                return this.idStoreSummaryCardState;
            }
        }
        return this.adSummaryCardState;
    }

    public Set<String> getUserWriteContractAttributeFulfillmentValues() {
        switch (this.getUserRepositoryType()) {
            case IDENTITY_STORE: {
                return this.idStoreWriteUsersState.getWriteContractAttributeFulfillmentValues();
            }
        }
        return this.adWriteUsersState.getWriteContractAttributeFulfillmentValues();
    }

    public Set<String> getGroupWriteContractAttributeFulfillmentValues() {
        switch (this.getUserRepositoryType()) {
            case IDENTITY_STORE: {
                return this.idStoreWriteGroupsState.getWriteContractAttributeFulfillmentValues();
            }
        }
        return this.adWriteGroupsState.getWriteContractAttributeFulfillmentValues();
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return null;
    }

    @Override
    public boolean includeAdditionalValues() {
        return false;
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return null;
    }

    @Override
    public List<String> getSelectedColumns() {
        return null;
    }

    @Override
    public List<String> getSelectedAttributes() {
        return null;
    }

    @Override
    public List<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<String> getAllColumns() {
        return null;
    }

    @Override
    public List<String> getAllAttributes() {
        return this.userRepositoryState.getAllAttributes();
    }

    @Override
    public List<String> getAllFields() {
        return null;
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.userRepositoryState.getSelectedDataSource();
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return null;
    }

    @Override
    public List<String> getContractToFulfill() {
        return null;
    }

    @Override
    public List<String> getContractAttributes() {
        return this.userRepositoryState.getContractAttributes();
    }

    @Override
    public List<String> getGroupContractAttributes() {
        return this.userRepositoryState.getGroupContractAttributes();
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return null;
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return null;
    }

    public List<String> getCustomAttributeNamesNotIncludingTasklet(String excludedTaskletId) {
        if (ScimVersion.SCIM20.equals((Object)this.getInboundProvisioningScimVersion())) {
            return this.scim2CustomAttributesState.getAttributeNamesNotIncludingTasklet(excludedTaskletId);
        }
        return this.customSCIMAttributesState.getAttributeNamesNotIncludingTasklet(excludedTaskletId);
    }

    public String getCustomAttributeSchema() {
        if (ScimVersion.SCIM20.equals((Object)this.getInboundProvisioningScimVersion())) {
            return this.scim2CustomAttributesState.getNamespace();
        }
        return this.customSCIMAttributesState.getNamespace();
    }

    public List<String> getCustomAttributeIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (ScimVersion.SCIM20.equals((Object)this.getInboundProvisioningScimVersion())) {
            List<Tasklet> tasklets = this.scim2CustomAttributesState.getUndeletedTasklets();
            for (Tasklet tasklet : tasklets) {
                InboundProvisioningCustomScim2AttributeTasklet customScimAttributeTasklet = (InboundProvisioningCustomScim2AttributeTasklet)tasklet;
                InboundProvisioningCustomScim2AttributeState customScimAttributeState = (InboundProvisioningCustomScim2AttributeState)customScimAttributeTasklet.getCurrentState();
                ids.addAll(CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((String)customScimAttributeState.getAttributeName(), customScimAttributeState.getCanonicalValues(), customScimAttributeState.getSubAttributesNamesList(), (boolean)customScimAttributeState.isMultiValued()));
            }
        } else {
            List<Tasklet> tasklets = this.customSCIMAttributesState.getUndeletedTasklets();
            for (Tasklet tasklet : tasklets) {
                InboundProvisioningCustomScimAttributeTasklet customScimAttributeTasklet = (InboundProvisioningCustomScimAttributeTasklet)tasklet;
                InboundProvisioningCustomScimAttributeState customScimAttributeState = (InboundProvisioningCustomScimAttributeState)customScimAttributeTasklet.getCurrentState();
                ids.addAll(CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((String)customScimAttributeState.getAttributeName(), customScimAttributeState.getTypes(), customScimAttributeState.getSubAttributesNamesList(), (boolean)customScimAttributeState.isMultiValued()));
            }
        }
        Collections.sort(ids);
        return ids;
    }
}

