/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.CertificateService;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CertSummaryState;
import com.pingidentity.fsm.state.impl.LinkCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.impl.WsTrustStsSslAuthTasklet;
import java.util.List;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class LinkCertTasklet
extends Tasklet
implements CertApi {
    private boolean globalEditing = false;
    private boolean activatable = true;
    private CertificateTypes.ValidTypes certType;
    private final LinkCertState linkCertState;
    private final CertSummaryState certSummaryState;

    public LinkCertTasklet(Visit visit) {
        super("LinkCertTasklet", "Link Certificate");
        this.setSystemVisit(visit);
        this.linkCertState = new LinkCertState(this);
        this.certSummaryState = new CertSummaryState(this);
        this.certSummaryState.setSummaryTitle("Linked Certificate Details");
        this.linkCertState.addOutgoingTransition(this, this.certSummaryState);
        this.setInitialState(this.linkCertState);
        this.setCancelAvailable(true);
    }

    public void setErrorFactory(ValidationErrorFactory errorFactory) {
        this.linkCertState.setErrorFactory(errorFactory);
    }

    public void setCertificateService(CertificateService certificateService) {
        this.linkCertState.setCertificateService(certificateService);
    }

    public void setPkCertManager(PkCertManager pkCertManager) {
        this.linkCertState.setPkCertManager(pkCertManager);
    }

    @Override
    public CertItem getCertItem() {
        CertItem certItem = this.linkCertState.getCertItem();
        if (certItem != null) {
            certItem.setNewCert(true);
            certItem.setActive(this.certSummaryState.isActive());
            certItem.setActiveAdminSslCert(this.certSummaryState.isActiveAdminSslCert());
        }
        return certItem;
    }

    @Override
    public boolean isActivatable() {
        return this.activatable;
    }

    @Override
    public void finish() {
        List<String> errors = this.linkCertState.createCertItem();
        if (!errors.isEmpty()) {
            this.setHasErrors(true);
            ValidationDelegate delegate = this.getDelegate();
            if (delegate != null) {
                TaskletState.recordErrorMsgs(errors, (IValidationDelegate)delegate);
            }
            return;
        }
        if (this.linkCertState.getCertItem() != null) {
            this.linkCertState.getCertItem().setActive(this.certSummaryState.isActive());
            this.linkCertState.getCertItem().setActiveAdminSslCert(this.certSummaryState.isActiveAdminSslCert());
        }
        super.finish();
        this.getParentTasklet().save(null);
    }

    public boolean isSslCert() {
        return this.certType == CertificateTypes.ValidTypes.sslServerCerts;
    }

    public void setGlobalEditing(boolean globalEditing) {
        this.globalEditing = globalEditing;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.certType = certType;
    }

    public void setActivatable() {
        Tasklet parent;
        if (this.globalEditing) {
            if (this.certType != CertificateTypes.ValidTypes.sslServerCerts) {
                this.activatable = false;
            }
        } else if (this.certType == CertificateTypes.ValidTypes.trustedCAs) {
            this.activatable = false;
        }
        if (!this.activatable) {
            this.certSummaryState.setActive(false);
            this.certSummaryState.setActiveAdminSslCert(false);
        }
        if ((parent = (Tasklet)this.findParent(WsTrustStsSslAuthTasklet.class)) != null) {
            this.activatable = false;
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return !this.hasConnectionWizard() && !this.hasServerSettingWizard();
    }
}

