/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.DynamicConnectionSigningCertState;
import com.pingidentity.fsm.state.impl.MetadataLifetimeState;
import com.pingidentity.fsm.state.impl.SystemInfoState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.page.Login;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class MetadataSettingsTasklet
extends Tasklet {
    private final SystemInfoState systemInfoState;
    private final DynamicConnectionSigningCertState dynamicConnectionSigningCertState;
    private final MetadataLifetimeState metadataLifetimeState;

    public MetadataSettingsTasklet(Visit visit) {
        super("MetadataSettingsTasklet", "Roles & Protocols");
        this.setSystemVisit(visit);
        this.systemInfoState = new SystemInfoState(this, "systemInfo");
        this.dynamicConnectionSigningCertState = new DynamicConnectionSigningCertState(this);
        this.metadataLifetimeState = new MetadataLifetimeState(this);
        this.systemInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.dynamicConnectionSigningCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
                return localSettings.isEnableSP() || localSettings.isEnableIdP();
            }
        });
        this.dynamicConnectionSigningCertState.addOutgoingTransition(this, this.metadataLifetimeState);
        this.setInitialState(this.systemInfoState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        if (this.isAuthorizedForAction()) {
            LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
            LocalSettings localSettings = localSettingsMgr.getLocalSettings();
            this.setMode(Mode.edit);
            this.saveAllStates(localSettings);
            localSettingsMgr.saveLocalSettings(localSettings);
        }
        super.finish();
    }

    @Override
    public String getFinishLabel() {
        return this.isAuthorizedForAction() ? "Save" : "Next";
    }

    @Override
    public void onCancel(IRequestCycle cycle) {
        if (this.isPostInstallWizard()) {
            Visit visit = this.getSystemVisit();
            visit.logout(cycle.getRequestContext().getSession());
            Login login = (Login)cycle.getPage("login");
            throw new PageRedirectException((IPage)login);
        }
        super.onCancel(cycle);
    }

    @Override
    public boolean isFinishAvailable() {
        if (this.hideFinishButtonIfAuditor()) {
            return false;
        }
        TaskletState currentState = (TaskletState)this.getCurrentState();
        return (!this.isPostInstallWizard() || currentState.getOutgoingTransition() == null) && super.isFinishAvailable();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isAuthorizedForAction() {
        return this.getCurrentUser().isAdmin();
    }
}

