/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BasicSoapAuthInboundState;
import com.pingidentity.fsm.state.impl.InboundConfigSoapAuthState;
import com.pingidentity.fsm.state.impl.SelectCertVerificationMethodState;
import com.pingidentity.fsm.state.impl.SslCertVerificationState;
import com.pingidentity.fsm.state.impl.SubjectDnState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;

public class OutboundArtifactBindingConfigTasklet
extends Tasklet {
    private static final long serialVersionUID = 20050515L;
    final InboundConfigSoapAuthState inboundConfigSoapAuthState;
    final BasicSoapAuthInboundState basicSoapAuthInboundState;
    final SelectCertVerificationMethodState selectCertVerificationMethodState;
    final SubjectDnState subjectDnState;
    final SslCertVerificationState sslCertVerificationState;
    final SummaryCardState summaryState;

    public OutboundArtifactBindingConfigTasklet(Visit visit) {
        super("OutboundArtifactBindingConfigTasklet", "Back-Channel Authentication");
        this.setSystemVisit(visit);
        this.inboundConfigSoapAuthState = new InboundConfigSoapAuthState(this);
        this.basicSoapAuthInboundState = new BasicSoapAuthInboundState(this, "basicAuth");
        this.basicSoapAuthInboundState.setMenuName("Basic Authentication (Inbound)");
        this.selectCertVerificationMethodState = new SelectCertVerificationMethodState(this, "selectCertVerificationMethod");
        this.subjectDnState = new SubjectDnState(this);
        this.sslCertVerificationState = new SslCertVerificationState(this);
        this.sslCertVerificationState.setCertType(CertificateTypes.ValidTypes.sslCertVerification);
        this.sslCertVerificationState.setMenuName("SSL Verification Certificate");
        this.summaryState = new SummaryCardState(this, "summaryCard");
        this.inboundConfigSoapAuthState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.basicSoapAuthInboundState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return OutboundArtifactBindingConfigTasklet.this.inboundConfigSoapAuthState.isBasic();
            }
        });
        this.basicSoapAuthInboundState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectCertVerificationMethodState){
            private static final long serialVersionUID = 1234L;

            @Override
            public boolean validate() {
                return OutboundArtifactBindingConfigTasklet.this.inboundConfigSoapAuthState.isCert();
            }
        });
        this.inboundConfigSoapAuthState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectCertVerificationMethodState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return OutboundArtifactBindingConfigTasklet.this.inboundConfigSoapAuthState.isCert() && !OutboundArtifactBindingConfigTasklet.this.inboundConfigSoapAuthState.isBasic();
            }
        });
        this.inboundConfigSoapAuthState.addOutgoingTransition(new TaskletTransition(this, this.summaryState));
        this.selectCertVerificationMethodState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.sslCertVerificationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !OutboundArtifactBindingConfigTasklet.this.selectCertVerificationMethodState.isAnchored();
            }
        });
        this.selectCertVerificationMethodState.addOutgoingTransition(new TaskletTransition(this, this.subjectDnState));
        this.subjectDnState.addOutgoingTransition(new TaskletTransition(this, this.summaryState));
        this.basicSoapAuthInboundState.addOutgoingTransition(this, this.summaryState);
        this.sslCertVerificationState.addOutgoingTransition(this, this.summaryState);
        this.setInitialState(this.inboundConfigSoapAuthState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        IdpConnection connectionBase = null;
        switch (this.findParent(ConnectionTasklet.class).getConnectionType()) {
            case IDP: {
                connectionBase = new IdpConnection();
                break;
            }
            case SP: {
                connectionBase = new SpConnection();
            }
        }
        this.save(connectionBase);
        this.setPopulateData(connectionBase);
        super.finish();
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletState state = (TaskletState)this.getSourceState();
        TaskletTransition tt = null;
        do {
            state.getSummary(summaryList);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    public boolean usesNone() {
        return this.inboundConfigSoapAuthState.isNone();
    }

    public boolean usesSSLCert() {
        return this.inboundConfigSoapAuthState.isCert();
    }

    public boolean isBasic() {
        return this.inboundConfigSoapAuthState.isBasic();
    }

    public boolean usesDsigAuth() {
        return this.inboundConfigSoapAuthState.usesDsigAuth();
    }

    @Override
    public String getHelpName() {
        Tasklet spConnectionConfigTasklet = this.findParent(SpConnectionConfigTasklet.class);
        if (spConnectionConfigTasklet != null) {
            return "Sp" + super.getHelpName();
        }
        return super.getHelpName();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }
}

