/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.state.impl.DynamicDsigSubjectDnState;
import com.pingidentity.fsm.state.impl.SelectVerificationTrustModelState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.VerificationCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;

public class SignatureVerificationTasklet
extends Tasklet {
    private static final long serialVersionUID = 2L;
    final SelectVerificationTrustModelState selectVerificationTrustModelState;
    final DynamicDsigSubjectDnState dynamicDsigSubjectDnState;
    final VerificationCertState verificationCertState;
    final SummaryCardState summaryCardState;

    public SignatureVerificationTasklet(Visit visit) {
        super("SignatureVerificationTasklet", "Signature Verification");
        this.setSystemVisit(visit);
        this.selectVerificationTrustModelState = new SelectVerificationTrustModelState(this);
        this.verificationCertState = new VerificationCertState(this);
        this.dynamicDsigSubjectDnState = new DynamicDsigSubjectDnState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.selectVerificationTrustModelState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.dynamicDsigSubjectDnState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SignatureVerificationTasklet.this.isAnchored();
            }
        });
        this.selectVerificationTrustModelState.addOutgoingTransition(this, this.verificationCertState);
        this.dynamicDsigSubjectDnState.addOutgoingTransition(this, this.summaryCardState);
        this.verificationCertState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.selectVerificationTrustModelState);
        this.setCancelAvailable(true);
    }

    public List<String> getActiveSignatureVerificationCertStrings() {
        CertificateState state = (CertificateState)this.findState(this.verificationCertState.getStateName());
        if (state != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            this.verificationCertState.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (!tempDelegate.getHasErrors()) {
                LinkedHashSet<Cert> inUserVerificationCerts = this.getInUseVerificationCerts();
                return inUserVerificationCerts.stream().map(Cert::getDescriptionForDisplay).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public LinkedHashSet<Cert> getInUseVerificationCerts() {
        return this.findState(this.verificationCertState.getStateName()) != null ? this.verificationCertState.getActiveCerts() : new LinkedHashSet<Cert>();
    }

    public boolean isAnchored() {
        return this.selectVerificationTrustModelState.isAnchored();
    }

    public String getSubjectDn() {
        return this.dynamicDsigSubjectDnState.getSubjectDn();
    }

    @Override
    public void finish() {
        ConnectionType type = this.findParent(ConnectionTasklet.class).getConnectionType();
        if (type == ConnectionType.IDP) {
            IdpConnection idpConnection = new IdpConnection();
            this.save(idpConnection);
            this.setPopulateData(idpConnection);
        } else {
            SpConnection spConnection = new SpConnection();
            this.save(spConnection);
            this.setPopulateData(spConnection);
        }
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public String getHelpName() {
        return this.findParent(ConnectionTasklet.class).getConnectionType() + "_" + super.getHelpName();
    }

    public void metaDataReset() {
        this.verificationCertState.metaDataReset();
    }
}

