/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.ConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.ConfigLdapDirAttrTypeState;
import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.ConfigureCustomSourceFiltersState;
import com.pingidentity.fsm.state.impl.OAuthIdpAdapter2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.RequestHintContractMappingTasklet;
import com.pingidentity.fsm.state.impl.SPAttributeSourceMappingState;
import com.pingidentity.fsm.state.impl.SelectCustomSourceFieldsState;
import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.state.impl.SpConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.SpConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractViewOnlyTasklet;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.util.ExtStringPropertySelectionModel;
import com.pingidentity.util.SAML2MappingModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class SpAttributeSourceTasklet
extends AbstractViewOnlyTasklet
implements AttributeSourceApi {
    private static final long serialVersionUID = 20050515L;
    private boolean viewOnly;
    private Boolean showSaveAll;
    private SelectDataSourceState selectDataSourceState;
    private ConfigureCustomSourceFiltersState configCustomFiltersState;
    private SelectCustomSourceFieldsState selectCustomFieldsState;
    private SelectDatabaseTableAndColumnsState selectDatabaseTableAndColumnsState;
    ConfigDatabaseFilterState configDatabaseFilterState;
    private SPAttributeSourceMappingState databaseConfigAttributeMappingState;
    private ConfigLdapDirSearchState configLdapDirSearchState;
    private ConfigLdapDirAttrTypeState configLdapDirAttrTypeState;
    SpConfigLdapFilterState spConfigLdapFilterState;
    private SPAttributeSourceMappingState ldapConfigAttributeMappingState;
    private SPAttributeSourceMappingState customConfigAttributeMappingState;
    private SummaryCardState summaryCardState;
    private String noteKeySuffix;

    public SpAttributeSourceTasklet(Visit visit) {
        super("SpAttributeSourceTasklet", "Attribute Sources & User Lookup");
        this.setSystemVisit(visit);
        this.createStates();
    }

    @Override
    public void finish() {
        AttributeMapping mapping = new AttributeMapping();
        this.save(mapping);
        this.setPopulateData(mapping);
        super.finish();
    }

    public void setShowSaveAll(Boolean showSaveAll) {
        this.showSaveAll = showSaveAll;
    }

    @Override
    public boolean showSaveAll() {
        if (this.showSaveAll != null) {
            return this.showSaveAll;
        }
        return super.showSaveAll();
    }

    protected void createStates() {
        this.selectDataSourceState = new SelectDataSourceState(this, "spSelectDataSource");
        this.configCustomFiltersState = new ConfigureCustomSourceFiltersState(this);
        this.selectCustomFieldsState = new SelectCustomSourceFieldsState(this);
        this.selectDatabaseTableAndColumnsState = new SelectDatabaseTableAndColumnsState(this);
        this.configDatabaseFilterState = this.createConfigDatabaseFilterState();
        this.spConfigLdapFilterState = new SpConfigLdapFilterState(this, "spConfigLdapFilter");
        this.configLdapDirSearchState = new SpConfigLdapDirSearchState(this);
        this.configLdapDirAttrTypeState = new ConfigLdapDirAttrTypeState(this);
        this.databaseConfigAttributeMappingState = new SPAttributeSourceMappingState(this, "mapping");
        this.ldapConfigAttributeMappingState = new SPAttributeSourceMappingState(this, "mapping");
        this.customConfigAttributeMappingState = new SPAttributeSourceMappingState(this, "mapping");
        this.summaryCardState = new SummaryCardState(this);
        this.setInitialState(this.selectDataSourceState);
        this.reconfigureTransitions(this.getInitialState());
        this.setCancelAvailable(true);
    }

    protected ConfigDatabaseFilterState createConfigDatabaseFilterState() {
        return new ConfigDatabaseFilterState(this, "spConfigDatabaseFilter");
    }

    public void addNoteKeySuffixToStates(String noteKeySuffix) {
        this.noteKeySuffix = noteKeySuffix;
        if (noteKeySuffix != null) {
            this.addNoteKeySuffixToState(this.selectDataSourceState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.configCustomFiltersState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.selectCustomFieldsState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.selectDatabaseTableAndColumnsState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.configDatabaseFilterState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.spConfigLdapFilterState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.configLdapDirSearchState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.configLdapDirAttrTypeState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.databaseConfigAttributeMappingState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.ldapConfigAttributeMappingState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.customConfigAttributeMappingState, noteKeySuffix);
            this.addNoteKeySuffixToState(this.summaryCardState, noteKeySuffix);
        }
    }

    private void addNoteKeySuffixToState(TaskletState state, String noteKeySuffix) {
        String currentHelpId;
        String currentNoteKey = state.getNoteKey();
        if (!currentNoteKey.endsWith("_" + noteKeySuffix) && !currentNoteKey.endsWith("Vo")) {
            state.setNoteKey(state.getNoteKey() + "_" + noteKeySuffix);
        }
        if (!(currentHelpId = state.getHelpId()).endsWith("_" + noteKeySuffix)) {
            state.setHelpId(currentHelpId + "_" + noteKeySuffix);
        }
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
        DataSource.DSType curType = this.selectDataSourceState.getDataSourceType();
        switch (curType) {
            case Other: {
                this.createCustomTransitions();
                break;
            }
            case JDBC: {
                this.createJdbcTransitions();
                break;
            }
            case LDAP: {
                this.createLdapTransitions();
                break;
            }
            default: {
                this.createNoneTransitions();
            }
        }
    }

    protected void createLdapTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.configLdapDirSearchState);
        this.configLdapDirSearchState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configLdapDirAttrTypeState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpAttributeSourceTasklet.this.configLdapDirSearchState.isBinaryAttributeSelected();
            }
        });
        this.configLdapDirSearchState.addOutgoingTransition(this, this.spConfigLdapFilterState);
        this.configLdapDirAttrTypeState.addOutgoingTransition(this, this.spConfigLdapFilterState);
        this.spConfigLdapFilterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpAttributeSourceTasklet.this.isUseOtherValuesWithOneMapping();
            }
        });
        this.spConfigLdapFilterState.addOutgoingTransition(this, this.ldapConfigAttributeMappingState);
        this.ldapConfigAttributeMappingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createJdbcTransitions() {
        this.selectDataSourceState.setItClickable(true);
        this.selectDataSourceState.addOutgoingTransition(this, this.selectDatabaseTableAndColumnsState);
        this.selectDatabaseTableAndColumnsState.addOutgoingTransition(this, this.configDatabaseFilterState);
        this.configDatabaseFilterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpAttributeSourceTasklet.this.isUseOtherValuesWithOneMapping();
            }
        });
        this.configDatabaseFilterState.addOutgoingTransition(this, this.databaseConfigAttributeMappingState);
        this.databaseConfigAttributeMappingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createCustomTransitions() {
        this.selectDataSourceState.setItClickable(true);
        this.selectDataSourceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configCustomFiltersState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = SpAttributeSourceTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                return instance == null || descriptor == null ? false : descriptor instanceof CustomDataSourceDriverDescriptor;
            }
        });
        this.selectDataSourceState.addOutgoingTransition(this, this.selectCustomFieldsState);
        this.configCustomFiltersState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectCustomFieldsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = SpAttributeSourceTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                if (instance == null || descriptor == null) {
                    return true;
                }
                if (descriptor instanceof CustomDataSourceDriverDescriptor) {
                    return ((CustomDataSourceDriverDescriptor)descriptor).isShowSelectCustomSourceFields();
                }
                return true;
            }
        });
        this.configCustomFiltersState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpAttributeSourceTasklet.this.isUseOtherValuesWithOneMapping();
            }
        });
        this.selectCustomFieldsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpAttributeSourceTasklet.this.isUseOtherValuesWithOneMapping();
            }
        });
        this.configCustomFiltersState.addOutgoingTransition(this, this.customConfigAttributeMappingState);
        this.selectCustomFieldsState.addOutgoingTransition(this, this.customConfigAttributeMappingState);
        this.customConfigAttributeMappingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createNoneTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public boolean setStatesToVOMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.selectDataSourceState));
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.selectDatabaseTableAndColumnsState));
            this.configDatabaseFilterState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.configDatabaseFilterState));
            this.databaseConfigAttributeMappingState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.databaseConfigAttributeMappingState));
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.configLdapDirSearchState));
            this.spConfigLdapFilterState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.spConfigLdapFilterState));
            this.ldapConfigAttributeMappingState.setViewOnly(true, this.getViewOnlyNoteKeyForState(this.ldapConfigAttributeMappingState));
        }
        return false;
    }

    @Override
    public boolean setStatesToEditMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(false, this.getNoteKeyForState(this.selectDataSourceState));
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(false, this.getNoteKeyForState(this.selectDatabaseTableAndColumnsState));
            this.configDatabaseFilterState.setViewOnly(false, this.getNoteKeyForState(this.configDatabaseFilterState));
            this.databaseConfigAttributeMappingState.setViewOnly(false, this.getNoteKeyForState(this.databaseConfigAttributeMappingState));
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(false, this.getNoteKeyForState(this.configLdapDirSearchState));
            this.spConfigLdapFilterState.setViewOnly(false, this.getNoteKeyForState(this.spConfigLdapFilterState));
            this.ldapConfigAttributeMappingState.setViewOnly(false, this.getNoteKeyForState(this.ldapConfigAttributeMappingState));
        }
        return false;
    }

    private String getNoteKeyForState(TaskletState state) {
        StringBuilder noteKey = new StringBuilder();
        noteKey.append(state.getTaskletStateId());
        if (!StringUtils.isBlank((String)this.getNoteKeySuffix())) {
            noteKey.append("_");
            noteKey.append(this.getNoteKeySuffix());
        }
        return noteKey.toString();
    }

    private String getViewOnlyNoteKeyForState(TaskletState state) {
        return this.getNoteKeyForState(state) + "Vo";
    }

    public String getNoteKeySuffix() {
        return this.noteKeySuffix;
    }

    @Override
    public String getDataSourceType() {
        return this.selectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.selectDataSourceState.getSelectedDataSource();
    }

    @Override
    public List<String> getSelectedColumns() {
        return this.selectDatabaseTableAndColumnsState.getSelectedColumns();
    }

    @Override
    public List<String> getSelectedAttributes() {
        return this.configLdapDirSearchState.getSelectedAttributes();
    }

    @Override
    public List<String> getAllColumns() {
        return this.selectDatabaseTableAndColumnsState.getAllColumns();
    }

    @Override
    public List<String> getAllAttributes() {
        return this.configLdapDirSearchState.getAllAttributes();
    }

    @Override
    public List<String> getSelectedFields() {
        return this.selectCustomFieldsState.getSelectedFields();
    }

    @Override
    public List<String> getAllFields() {
        return this.selectCustomFieldsState.getAllFields();
    }

    @Override
    public String getTableName() {
        return this.selectDatabaseTableAndColumnsState.getSelectedTable();
    }

    public String getDesc() {
        return this.selectDataSourceState.getAttrSourceDesc();
    }

    @SuppressFBWarnings(value={"HE_EQUALS_USE_HASHCODE"})
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SpAttributeSourceTasklet) {
            return this.selectDataSourceState.getAttrSourceDesc().equals(((SpAttributeSourceTasklet)o).getDescription());
        }
        return false;
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.selectDataSourceState.getAttrSourceDesc().toLowerCase().compareTo(((SpAttributeSourceTasklet)o).getType().toLowerCase());
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return AttributeSourceApi.ConnectionType.SP;
    }

    @Override
    public String getDescription() {
        return this.selectDataSourceState.getAttrSourceDesc();
    }

    public String getId() {
        return this.selectDataSourceState.getAttrSourceId();
    }

    @Override
    public String getType() {
        return this.selectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return null;
    }

    @Override
    public boolean includeAdditionalValues() {
        return false;
    }

    @Override
    public List<String> getContractToFulfill() {
        return this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return this.selectDataSourceState.getSelectedCustomAttributeSource();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        if (this.getParentTasklet() instanceof OAuthIdpAdapter2TargetMappingTasklet || this.getParentTasklet() instanceof CibaPolicyManagementTasklet || this.getParentTasklet() instanceof RequestHintContractMappingTasklet) {
            return false;
        }
        PolicyManagementTasklet tasklet = this.findParent(PolicyManagementTasklet.class);
        if (tasklet != null) {
            return false;
        }
        AdministrativeUser user = this.getSystemVisit().getCurrentUser();
        return !user.isAuditor() && ((TaskletState)this.getCurrentState()).isSaveDraftAvailable();
    }

    public boolean isUseOtherValuesWithOneMapping() {
        MappingTasklet tasklet = this.findParent(MappingTasklet.class);
        if (tasklet != null) {
            return tasklet.isUseOtherValuesWithOneMapping();
        }
        return false;
    }

    public IPropertySelectionModel getIPropertySelectionModel() {
        ExtStringPropertySelectionModel propSelectionModel = null;
        propSelectionModel = this.getType().equals("JDBC") ? new ExtStringPropertySelectionModel(this.getSelectedColumns().toArray(new String[0])) : (this.getType().equals("LDAP") ? new ExtStringPropertySelectionModel(this.getSelectedAttributes().toArray(new String[0])) : new ExtStringPropertySelectionModel(this.getSelectedFields().toArray(new String[0])));
        return propSelectionModel;
    }

    public List<String> getAllSelectedAttributesForDisplay() {
        ArrayList<String> attrNamesWithPrefix = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.getId())) {
            List<String> attrs = this.getType().equals("JDBC") ? this.getSelectedColumns() : (this.getType().equals("LDAP") ? this.getSelectedAttributes() : this.getSelectedFields());
            for (String attr : attrs) {
                attrNamesWithPrefix.add("ds." + this.getId() + "." + attr);
            }
        }
        return attrNamesWithPrefix;
    }

    public List<String> getPreviousAttributeSourceValues() {
        return this.findParent(MappingTasklet.class).getPreviousAttributeSourceValues(this);
    }

    public String getLdapSearchScope() {
        return this.configLdapDirSearchState.getSelectedSearchScope();
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        if (this.isUseOtherValuesWithOneMapping()) {
            return null;
        }
        DataSource.DSType curType = this.selectDataSourceState.getDataSourceType();
        switch (curType) {
            case Other: {
                return this.customConfigAttributeMappingState.getModel();
            }
            case JDBC: {
                return this.databaseConfigAttributeMappingState.getModel();
            }
            case LDAP: {
                return this.ldapConfigAttributeMappingState.getModel();
            }
        }
        return null;
    }

    @Override
    public void jumpToState(IRequestCycle cycle, Queue<String> returnPath) {
        this.setMode(Mode.edit);
        super.jumpToState(cycle, returnPath);
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return null;
    }

    public void cleanAttributeMappings(Set<String> attributeContract) {
        this.databaseConfigAttributeMappingState.getModel().cleanMappings(attributeContract);
        this.ldapConfigAttributeMappingState.getModel().cleanMappings(attributeContract);
        this.customConfigAttributeMappingState.getModel().cleanMappings(attributeContract);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }
}

